/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.blocks.machines;

import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.proxy.ClientProxy;
import com.mjr.extraplanets.tile.machines.TileEntityUltimateOxygenCompressor;
import com.mjr.extraplanets.tile.machines.TileEntityUltimateOxygenDecompressor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class UltimateOxygenCompressor
extends BlockAdvancedTile
implements ItemBlockDesc.IBlockShiftDesc {
    public static final int OXYGEN_COMPRESSOR_METADATA = 0;
    public static final int OXYGEN_DECOMPRESSOR_METADATA = 4;
    private IIcon iconMachineSide;
    private IIcon iconCompressor1;
    private IIcon iconCompressor2;
    private IIcon iconDecompressor;
    private IIcon iconOxygenInput;
    private IIcon iconOxygenOutput;
    private IIcon iconInput;

    public UltimateOxygenCompressor(boolean isActive, String assetName) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return ClientProxy.getBlockRender((Block)this);
    }

    public CreativeTabs func_149708_J() {
        return ExtraPlanets.BlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.iconCompressor1 = par1IconRegister.func_94245_a("extraplanets:ultimate_oxygen_compressor");
        this.iconCompressor2 = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_compressor_2");
        this.iconDecompressor = par1IconRegister.func_94245_a("extraplanets:ultimate_oxygen_decompressor");
        this.iconOxygenInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_oxygen_input");
        this.iconOxygenOutput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_oxygen_output");
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_input");
    }

    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        if (metadata >= 4) {
            original -= 4;
        } else if (metadata >= 0) {
            original += 0;
        }
        int meta = 0;
        switch (original) {
            case 0: {
                meta = 3;
                break;
            }
            case 3: {
                meta = 1;
                break;
            }
            case 1: {
                meta = 2;
                break;
            }
            case 2: {
                meta = 0;
            }
        }
        if (metadata >= 4) {
            meta += 4;
        } else if (metadata >= 0) {
            meta += 0;
        }
        TileEntity te = par1World.func_147438_o(x, y, z);
        if (te instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, meta, 3);
        return true;
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)ExtraPlanets.instance, -1, world, x, y, z);
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= 4) {
            return new TileEntityUltimateOxygenDecompressor();
        }
        if (metadata >= 0) {
            return new TileEntityUltimateOxygenCompressor();
        }
        return null;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.iconMachineSide;
        }
        if (metadata >= 4) {
            if (side == (metadata -= 4) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconOxygenOutput;
            }
            if (metadata == 0 && side == 5 || metadata == 3 && side == 3 || metadata == 1 && side == 4 || metadata == 2 && side == 2) {
                return this.iconCompressor2;
            }
            return this.iconDecompressor;
        }
        if (metadata >= 0) {
            if (side == (metadata += 0) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconOxygenInput;
            }
            if (metadata == 0 && side == 5 || metadata == 3 && side == 3 || metadata == 1 && side == 4 || metadata == 2 && side == 2) {
                return this.iconCompressor2;
            }
            return this.iconCompressor1;
        }
        return this.iconMachineSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        if (itemStack.func_77960_j() >= 4) {
            change += 4;
        } else if (itemStack.func_77960_j() >= 0) {
            change += 0;
        }
        world.func_72921_c(x, y, z, change, 3);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Block)this, 1, 0));
        par3List.add(new ItemStack((Block)this, 1, 4));
    }

    public int func_149692_a(int metadata) {
        if (metadata >= 4) {
            return 4;
        }
        if (metadata >= 0) {
            return 0;
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }

    public String getShiftDescription(int meta) {
        switch (meta) {
            case 0: {
                return GCCoreUtil.translate((String)"tile.ultimate.oxygenCompressor.description");
            }
            case 4: {
                return GCCoreUtil.translate((String)"tile.ultimate.oxygenDecompressor.description");
            }
        }
        return "";
    }

    public boolean showDescription(int meta) {
        return true;
    }
}

