/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.entities.rockets;

import com.mjr.extraplanets.blocks.BlockCustomLandingPadFull;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.extraplanets.tile.machines.TileEntityTier2LandingPad;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class EntityTier7Rocket
extends EntityTieredRocket {
    public EntityTier7Rocket(World par1World) {
        super(par1World);
        this.func_70105_a(2.4f, 6.5f);
        this.field_70129_M = 1.5f;
    }

    public EntityTier7Rocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        this.func_70105_a(2.4f, 6.5f);
        this.field_70129_M = 1.5f;
    }

    public void landEntity(int x, int y, int z) {
        IFuelDock dock;
        TileEntity tile = this.field_70170_p.func_147438_o(x, y, z);
        if (tile instanceof IFuelDock && this.isDockValid(dock = (IFuelDock)tile)) {
            if (!this.field_70170_p.field_72995_K) {
                if (dock.getDockedEntity() instanceof EntitySpaceshipBase && dock.getDockedEntity() != this) {
                    ((EntitySpaceshipBase)dock.getDockedEntity()).dropShipAsItem();
                    ((EntitySpaceshipBase)dock.getDockedEntity()).func_70106_y();
                }
                this.setPad(dock);
            }
            this.onRocketLand(x + 1, y, z + 1);
        }
    }

    protected void onRocketLand(int x, int y, int z) {
        this.func_70080_a((double)x + 0.5, (double)y + 2.0, (double)z + 0.5, this.field_70177_z, 0.0f);
        this.stopRocketSound();
    }

    public double func_70042_X() {
        return 0.5;
    }

    public float getRotateOffset() {
        return -0.6f;
    }

    public double getOnPadYOffset() {
        return 1.5;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, this.rocketType.getIndex());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (!this.landing) {
                double d = this.timeSinceLaunch / 150.0f;
                d = this.field_70170_p.field_73011_w instanceof WorldProviderSpace && !((WorldProviderSpace)this.field_70170_p.field_73011_w).hasAtmosphere() ? Math.min(d * 1.2, 1.8) : Math.min(d, 1.2);
                if (d != 0.0) {
                    this.field_70181_x = -d * 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) * Math.PI / 180.0);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    public void onTeleport(EntityPlayerMP player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase != null) {
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)playerBase);
            stats.rocketStacks = this.cargoItems == null || this.cargoItems.length == 0 ? new ItemStack[2] : this.cargoItems;
            stats.rocketType = this.rocketType.getIndex();
            stats.rocketItem = ExtraPlanets_Items.tier7Rocket;
            stats.fuelLevel = this.fuelTank.getFluidAmount();
        }
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double x1 = 3.2 * Math.cos((double)this.field_70177_z / 57.2957795) * Math.sin((double)this.field_70125_A / 57.2957795);
            double z1 = 3.2 * Math.sin((double)this.field_70177_z / 57.2957795) * Math.sin((double)this.field_70125_A / 57.2957795);
            double y1 = 3.2 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.2957795);
            if (this.landing && this.targetVec != null) {
                double modifier = this.field_70163_u - (double)this.targetVec.y;
                modifier = Math.max(modifier, 180.0);
                x1 *= modifier / 200.0;
                y1 *= Math.min(modifier / 200.0, 2.5);
                z1 *= modifier / 200.0;
            }
            double y2 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - 0.75 * this.field_70181_x - 0.3;
            double x2 = this.field_70165_t + x1 + this.field_70159_w;
            double z2 = this.field_70161_v + z1 + this.field_70179_y;
            Vector3 motionVec = new Vector3(x1 + this.field_70159_w, y1 + this.field_70181_x, z1 + this.field_70179_y);
            Vector3 d1 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d2 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d3 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d4 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 mv1 = motionVec.clone().translate(d1);
            Vector3 mv2 = motionVec.clone().translate(d2);
            Vector3 mv3 = motionVec.clone().translate(d3);
            Vector3 mv4 = motionVec.clone().translate(d4);
            this.makeFlame(x2 + d1.x, y2 + d1.y, z2 + d1.z, mv1, this.getLaunched());
            this.makeFlame(x2 + d2.x, y2 + d2.y, z2 + d2.z, mv2, this.getLaunched());
            this.makeFlame(x2 + d3.x, y2 + d3.y, z2 + d3.z, mv3, this.getLaunched());
            this.makeFlame(x2 + d4.x, y2 + d4.y, z2 + d4.z, mv4, this.getLaunched());
        }
    }

    private void makeFlame(double x2, double y2, double z2, Vector3 motionVec, boolean getLaunched) {
        if (getLaunched) {
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, new Object[]{this.field_70153_n});
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, new Object[]{this.field_70153_n});
            return;
        }
        double x1 = motionVec.x;
        double y1 = motionVec.y;
        double z1 = motionVec.z;
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.5, y1 - 0.3, z1 + 0.5), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.5, y1 - 0.3, z1 + 0.5), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.5, y1 - 0.3, z1 - 0.5), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.5, y1 - 0.3, z1 - 0.5), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4, y2, z2), new Vector3(x1 + 0.8, y1 - 0.3, z1), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4, y2, z2), new Vector3(x1 - 0.8, y1 - 0.3, z1), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 + 0.4), new Vector3(x1, y1 - 0.3, z1 + 0.8), new Object[]{this.field_70153_n});
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 - 0.4), new Vector3(x1, y1 - 0.3, z1 - 0.8), new Object[]{this.field_70153_n});
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70128_L ? false : par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
    }

    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityTier2LandingPad;
    }

    public int getRocketTier() {
        return 7;
    }

    public int getFuelTankCapacity() {
        return 3500;
    }

    public int getPreLaunchWait() {
        return 400;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, this.rocketType.getIndex());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItems.add(rocket);
        return droppedItems;
    }

    public float getCameraZoom() {
        return 15.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public void onLaunch() {
        if (this.field_70170_p.field_73011_w.field_76574_g != GalacticraftCore.planetOverworld.getDimensionID() && !(this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider)) {
            if (ConfigManagerCore.disableRocketLaunchAllNonGC) {
                this.cancelLaunch();
                return;
            }
            for (int i = ConfigManagerCore.disableRocketLaunchDimensions.length - 1; i >= 0; --i) {
                if (ConfigManagerCore.disableRocketLaunchDimensions[i] != this.field_70170_p.field_73011_w.field_76574_g) continue;
                this.cancelLaunch();
                return;
            }
        }
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            GCPlayerStats stats = null;
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayerMP) {
                stats = GCPlayerStats.get((EntityPlayerMP)((EntityPlayerMP)this.field_70153_n));
                if (!(this.field_70170_p.field_73011_w instanceof IOrbitDimension)) {
                    stats.coordsTeleportedFromX = this.field_70153_n.field_70165_t;
                    stats.coordsTeleportedFromZ = this.field_70153_n.field_70161_v;
                }
            }
            int amountRemoved = 0;
            this.field_70165_t += 1.0;
            this.field_70161_v += 1.0;
            block1: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 3; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 3; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 3; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 3; ++z) {
                        Block block = this.field_70170_p.func_147439_a(x, y, z);
                        if (block == null || !(block instanceof BlockCustomLandingPadFull) || amountRemoved >= 25) continue;
                        EventLandingPadRemoval event = new EventLandingPadRemoval(this.field_70170_p, x, y, z);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block1;
                        this.field_70170_p.func_147468_f(x, y, z);
                        amountRemoved = 25;
                        break block1;
                    }
                }
            }
            if (stats != null) {
                stats.launchpadStack = new ItemStack(ExtraPlanets_Blocks.advancedLaunchPad, 25, 0);
            }
            this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }
}

