/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.extraplanets.nei.CircuitFabricatorRecipeHandler;
import com.mjr.extraplanets.nei.MarsRoverRecipeHandler;
import com.mjr.extraplanets.nei.RocketT10RecipeHandler;
import com.mjr.extraplanets.nei.RocketT4RecipeHandler;
import com.mjr.extraplanets.nei.RocketT5RecipeHandler;
import com.mjr.extraplanets.nei.RocketT6RecipeHandler;
import com.mjr.extraplanets.nei.RocketT7RecipeHandler;
import com.mjr.extraplanets.nei.RocketT8RecipeHandler;
import com.mjr.extraplanets.nei.RocketT9RecipeHandler;
import com.mjr.extraplanets.nei.VenusRoverRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class NEIExtraPlanetsConfig
implements IConfigureNEI {
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> t4rocketBenchRecipes = new HashMap();
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> t5rocketBenchRecipes = new HashMap();
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> t6rocketBenchRecipes = new HashMap();
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> t7rocketBenchRecipes = new HashMap();
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> t8rocketBenchRecipes = new HashMap();
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> t9rocketBenchRecipes = new HashMap();
    private static HashMap<ArrayList<PositionedStack>, PositionedStack> t10rocketBenchRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> circuitFabricatorRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> marsRoverBenchRecipes = new HashMap();
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> venusRoverBenchRecipes = new HashMap();

    public void loadConfig() {
        if (Config.neiSupport) {
            if (!Config.morePlanetsCompatibilityAdv) {
                if (Config.venus) {
                    this.registerTier4Recipe();
                }
                if (Config.jupiter) {
                    this.registerTier5Recipe();
                }
                if (Config.saturn) {
                    this.registerTier6Recipe();
                }
                if (Config.uranus) {
                    this.registerTier7Recipe();
                }
                if (Config.neptune) {
                    this.registerTier8Recipe();
                }
                if (Config.pluto) {
                    this.registerTier9Recipe();
                }
                if (Config.eris) {
                    this.registerTier10Recipe();
                }
            }
            this.addCircuitFabricatorRecipes();
            if (Config.marsRover) {
                this.addMarsRoverRecipes();
            }
            if (Config.venusRover) {
                this.addVenusRoverRecipes();
            }
            if (Config.venus) {
                if (!Config.morePlanetsCompatibilityAdv) {
                    API.registerRecipeHandler((ICraftingHandler)new RocketT4RecipeHandler());
                    API.registerUsageHandler((IUsageHandler)new RocketT4RecipeHandler());
                }
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.venusSpawner));
            }
            if (Config.jupiter) {
                if (!Config.morePlanetsCompatibilityAdv) {
                    API.registerRecipeHandler((ICraftingHandler)new RocketT5RecipeHandler());
                    API.registerUsageHandler((IUsageHandler)new RocketT5RecipeHandler());
                }
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.jupiterSpawner));
            }
            if (Config.saturn) {
                if (!Config.morePlanetsCompatibilityAdv) {
                    API.registerRecipeHandler((ICraftingHandler)new RocketT6RecipeHandler());
                    API.registerUsageHandler((IUsageHandler)new RocketT6RecipeHandler());
                }
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.saturnSpawner));
            }
            if (Config.uranus) {
                if (!Config.morePlanetsCompatibilityAdv) {
                    API.registerRecipeHandler((ICraftingHandler)new RocketT7RecipeHandler());
                    API.registerUsageHandler((IUsageHandler)new RocketT7RecipeHandler());
                }
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.uranusSpawner));
            }
            if (Config.neptune) {
                if (!Config.morePlanetsCompatibilityAdv) {
                    API.registerRecipeHandler((ICraftingHandler)new RocketT8RecipeHandler());
                    API.registerUsageHandler((IUsageHandler)new RocketT8RecipeHandler());
                }
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.neptuneSpawner));
            }
            if (Config.pluto) {
                if (!Config.morePlanetsCompatibilityAdv) {
                    API.registerRecipeHandler((ICraftingHandler)new RocketT9RecipeHandler());
                    API.registerUsageHandler((IUsageHandler)new RocketT9RecipeHandler());
                }
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.plutoSpawner));
            }
            if (Config.eris) {
                if (!Config.morePlanetsCompatibilityAdv) {
                    API.registerRecipeHandler((ICraftingHandler)new RocketT10RecipeHandler());
                    API.registerUsageHandler((IUsageHandler)new RocketT10RecipeHandler());
                }
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.erisSpawner));
            }
            API.registerRecipeHandler((ICraftingHandler)new CircuitFabricatorRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new CircuitFabricatorRecipeHandler());
            if (Config.morePlanetsCompatibilityAdv) {
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Items.wafers, 0, 1));
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Items.wafers, 0, 3));
            }
            API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.advancedLaunchPadFull, 0, 0));
            API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Blocks.advancedLaunchPadFull, 0, 1));
            if (Config.marsRover || Config.venusRover) {
                API.hideItem((ItemStack)new ItemStack(ExtraPlanets_Items.electricParts, 0, 2));
            }
            if (Config.marsRover) {
                API.registerRecipeHandler((ICraftingHandler)new MarsRoverRecipeHandler());
                API.registerUsageHandler((IUsageHandler)new MarsRoverRecipeHandler());
            }
            if (Config.venusRover) {
                API.registerRecipeHandler((ICraftingHandler)new VenusRoverRecipeHandler());
                API.registerUsageHandler((IUsageHandler)new VenusRoverRecipeHandler());
            }
        }
    }

    public String getName() {
        return "ExtraPlanets NEI Plugin";
    }

    public String getVersion() {
        return "3.0.12";
    }

    public void registerTier4RocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        t4rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getTier4RocketBenchRecipes() {
        return t4rocketBenchRecipes.entrySet();
    }

    public void registerTier5RocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        t5rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getTier5RocketBenchRecipes() {
        return t5rocketBenchRecipes.entrySet();
    }

    public void registerTier6RocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        t6rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getTier6RocketBenchRecipes() {
        return t6rocketBenchRecipes.entrySet();
    }

    public void registerTier7RocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        t7rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getTier7RocketBenchRecipes() {
        return t7rocketBenchRecipes.entrySet();
    }

    public void registerTier8RocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        t8rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getTier8RocketBenchRecipes() {
        return t8rocketBenchRecipes.entrySet();
    }

    public void registerTier9RocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        t9rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getTier9RocketBenchRecipes() {
        return t9rocketBenchRecipes.entrySet();
    }

    public void registerTier10RocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        t10rocketBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getTier10RocketBenchRecipes() {
        return t10rocketBenchRecipes.entrySet();
    }

    public void registerCircuitFabricatorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        circuitFabricatorRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes.entrySet();
    }

    public void registerMarsRoverBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        marsRoverBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getMarsRoverBenchRecipes() {
        return marsRoverBenchRecipes.entrySet();
    }

    public void registerVenusRoverBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        venusRoverBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getVenusRoverBenchRecipes() {
        return venusRoverBenchRecipes.entrySet();
    }

    public void registerTier4Recipe() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.noseConeTier4), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 0), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 2), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 2), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 2), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 2), 72, 115));
        this.registerTier4RocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerTier4RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier4RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier4RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier4RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier4RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier4RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier4RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Rocket, 1, 3), 139, 102));
    }

    public void registerTier5Recipe() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.noseConeTier5), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 3), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 0), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 2), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 2), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 2), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 2), 72, 115));
        this.registerTier5RocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerTier5RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier5RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier5RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier5RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier5RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier5RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier5RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Rocket, 1, 3), 139, 102));
    }

    public void registerTier6Recipe() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.noseConeTier6), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 3), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 0), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 2), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 2), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 2), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Items, 1, 2), 72, 115));
        this.registerTier6RocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerTier6RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier6RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier6RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier6RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier6RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier6RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier6RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier6Rocket, 1, 3), 139, 102));
    }

    public void registerTier7Recipe() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.noseConeTier7), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 0), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 2), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 2), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 2), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 2), 72, 115));
        this.registerTier7RocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerTier7RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier7RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier7RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier7RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier7RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier7RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier7RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Rocket, 1, 3), 139, 102));
    }

    public void registerTier8Recipe() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.noseConeTier8), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 3), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 0), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 2), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 2), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 2), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 2), 72, 115));
        this.registerTier8RocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerTier8RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier8RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier8RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier8RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier8RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier8RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier8RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Rocket, 1, 3), 139, 102));
    }

    public void registerTier9Recipe() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.noseConeTier9), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 3), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 0), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 2), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 2), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 2), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Items, 1, 2), 72, 115));
        this.registerTier9RocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerTier9RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier9RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier9RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier9RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier9RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier9RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier9RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier9Rocket, 1, 3), 139, 102));
    }

    public void registerTier10Recipe() {
        int changeY = 15;
        ArrayList<PositionedStack> input1 = new ArrayList<PositionedStack>();
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.noseConeTier10), 45, 7));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 36, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 36, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 36, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 36, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 36, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 54, 25));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 54, 43));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 54, 61));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 54, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 3), 54, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 0), 45, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 1), 18, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 1), 72, 79));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 2), 18, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 2), 18, 115));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 2), 72, 97));
        input1.add(new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Items, 1, 2), 72, 115));
        this.registerTier10RocketBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Rocket, 1, 0), 139, 102));
        ArrayList<PositionedStack> input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        this.registerTier10RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier10RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier10RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Rocket, 1, 1), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        this.registerTier10RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier10RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier10RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Rocket, 1, 2), 139, 102));
        input2 = new ArrayList<PositionedStack>(input1);
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 90, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 116, 0));
        input2.add(new PositionedStack((Object)new ItemStack((Block)Blocks.field_150486_ae), 142, 0));
        this.registerTier10RocketBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier10Rocket, 1, 3), 139, 102));
    }

    private void addCircuitFabricatorRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        int siliconCount = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).size();
        ItemStack[] silicons = new ItemStack[siliconCount + 1];
        silicons[0] = new ItemStack(GCItems.basicItem, 1, 2);
        for (int j = 0; j < siliconCount; ++j) {
            silicons[j + 1] = (ItemStack)OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).get(j);
        }
        input1.put(1, new PositionedStack((Object)silicons, 69, 51));
        input1.put(2, new PositionedStack((Object)silicons, 69, 69));
        input1.put(3, new PositionedStack((Object)new ItemStack(Items.field_151137_ax), 117, 51));
        input1.put(0, new PositionedStack((Object)new ItemStack(Items.field_151045_i), 10, 22));
        input1.put(4, new PositionedStack((Object)new ItemStack(Blocks.field_150379_bu), 140, 25));
        this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.wafers, 3, 0), 147, 91));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        if (Config.venus) {
            input2.put(0, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 5), 10, 22));
            input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151132_bS), 140, 25));
            this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.wafers, 3, 1), 147, 91));
        }
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(0, new PositionedStack((Object)new ItemStack(AsteroidsItems.basicItem, 1, 5), 10, 22));
        input2.put(4, new PositionedStack((Object)new ItemStack(Blocks.field_150429_aA), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.wafers, 3, 2), 147, 91));
        if (Config.jupiter) {
            input2 = new HashMap<Integer, PositionedStack>(input1);
            input2.put(0, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier5Items, 1, 8), 10, 22));
            input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151107_aW), 140, 25));
            this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.wafers, 3, 3), 147, 91));
        }
        if (Config.neptune) {
            input2 = new HashMap<Integer, PositionedStack>(input1);
            if (Config.morePlanetsCompatibilityAdv) {
                input2.put(0, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 2), 10, 22));
            } else {
                input2.put(0, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier8Items, 1, 6), 10, 22));
            }
            input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151107_aW), 140, 25));
            this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.wafers, 3, 4), 147, 91));
        }
        if (Config.uranus) {
            input2 = new HashMap<Integer, PositionedStack>(input1);
            if (Config.morePlanetsCompatibilityAdv) {
                input2.put(0, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 3), 10, 22));
            } else {
                input2.put(0, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier7Items, 1, 7), 10, 22));
            }
            input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151107_aW), 140, 25));
            this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.wafers, 3, 5), 147, 91));
        }
    }

    private void addMarsRoverRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1 = new HashMap();
        input1.put(0, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 3), 18, 29));
        input1.put(1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 3), 90, 29));
        input1.put(2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 3), 18, 65));
        input1.put(3, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 3), 90, 65));
        input1.put(4, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 3), 18, 101));
        input1.put(5, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 3), 90, 101));
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 5; ++y) {
                if (x == 2 && y == 1) {
                    input1.put(y * 3 + x + 6, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 0), 36 + x * 18, 29 + y * 18));
                    continue;
                }
                if (x == 1 && y == 1) {
                    input1.put(y * 3 + x + 6, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 1), 36 + x * 18, 29 + y * 18));
                    continue;
                }
                input1.put(y * 3 + x + 6, new PositionedStack((Object)new ItemStack(MarsItems.marsItemBasic, 1, 3), 36 + x * 18, 29 + y * 18));
            }
        }
        this.registerMarsRoverBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.marsRover, 1, 0), 139, 101));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(22, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.marsRover, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(23, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.marsRover, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(24, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.marsRover, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(22, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(23, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.marsRover, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(23, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        input2.put(24, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.marsRover, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(22, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(24, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.marsRover, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(22, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(23, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        input2.put(24, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.marsRover, 1, 3), 139, 101));
    }

    private void addVenusRoverRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1 = new HashMap();
        input1.put(0, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 4), 18, 29));
        input1.put(1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 4), 90, 29));
        input1.put(2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 1), 18, 65));
        input1.put(3, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 1), 90, 65));
        input1.put(4, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 4), 18, 101));
        input1.put(5, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.electricParts, 1, 4), 90, 101));
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 5; ++y) {
                if (x == 1 && y == 1) {
                    input1.put(y * 3 + x + 6, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 1), 36 + x * 18, 29 + y * 18));
                    continue;
                }
                input1.put(y * 3 + x + 6, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.tier4Items, 1, 3), 36 + x * 18, 29 + y * 18));
            }
        }
        this.registerMarsRoverBenchRecipe(input1, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.venusRover, 1, 0), 139, 101));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(22, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.venusRover, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(23, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.venusRover, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(24, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.venusRover, 1, 1), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(22, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(23, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.venusRover, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(23, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        input2.put(24, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.venusRover, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(22, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(24, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.venusRover, 1, 2), 139, 101));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(22, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 90, 8));
        input2.put(23, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 116, 8));
        input2.put(24, new PositionedStack((Object)new ItemStack(GCItems.partBuggy, 1, 2), 142, 8));
        this.registerMarsRoverBenchRecipe(input2, new PositionedStack((Object)new ItemStack(ExtraPlanets_Items.venusRover, 1, 3), 139, 101));
    }
}

