/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Eris.worldgen.dungeon;

import com.mjr.extraplanets.planets.Eris.worldgen.dungeon.DungeonBoundingBox;
import com.mjr.extraplanets.planets.Eris.worldgen.dungeon.DungeonRoom;
import com.mjr.extraplanets.planets.Eris.worldgen.dungeon.MapGenDungeon;
import com.mjr.extraplanets.tile.dungeonSpawners.TileEntityDungeonSpawnerEris;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomBossEris
extends DungeonRoom {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    Random rand;
    ChunkCoordinates spawnerCoords;

    public RoomBossEris(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            this.rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = 24;
            this.sizeY = 11;
            this.sizeZ = 24;
        }
    }

    @Override
    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    if (i == this.posX && k == this.posZ || i == this.posX + this.sizeX - 1 && k == this.posZ || i == this.posX && k == this.posZ + this.sizeZ - 1 || i == this.posX + this.sizeX - 1 && k == this.posZ + this.sizeZ - 1) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, (Block)Blocks.field_150356_k, 0);
                        continue;
                    }
                    if (j % 3 == 0 && j >= this.posY + 2 && (i == this.posX || i == this.posX + this.sizeX - 1 || k == this.posZ || k == this.posZ + this.sizeZ - 1) || i == this.posX + 1 && k == this.posZ || i == this.posX && k == this.posZ + 1 || i == this.posX + this.sizeX - 2 && k == this.posZ || i == this.posX + this.sizeX - 1 && k == this.posZ + 1 || i == this.posX + 1 && k == this.posZ + this.sizeZ - 1 || i == this.posX && k == this.posZ + this.sizeZ - 2 || i == this.posX + this.sizeX - 2 && k == this.posZ + this.sizeZ - 1 || i == this.posX + this.sizeX - 1 && k == this.posZ + this.sizeZ - 2) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150411_aY, 0);
                        continue;
                    }
                    if ((i == this.posX + 1 && k == this.posZ + 1 || i == this.posX + this.sizeX - 2 && k == this.posZ + 1 || i == this.posX + 1 && k == this.posZ + this.sizeZ - 2 || i == this.posX + this.sizeX - 2 && k == this.posZ + this.sizeZ - 2) && j % 3 == 0) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150411_aY, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        this.spawnerCoords = new ChunkCoordinates(hx, this.posY + 2, hz);
    }

    @Override
    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomBossEris(dungeon, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        if (this.spawnerCoords == null) {
            return;
        }
        this.worldObj.func_147465_d(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c, GCBlocks.blockMoon, 15, 3);
        TileEntity tile = this.worldObj.func_147438_o(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c);
        if (tile == null || !(tile instanceof TileEntityDungeonSpawnerEris)) {
            TileEntityDungeonSpawnerEris spawner = new TileEntityDungeonSpawnerEris();
            spawner.setRoom(new Vector3((double)this.posX, (double)this.posY, (double)this.posZ), new Vector3((double)this.sizeX, (double)this.sizeY, (double)this.sizeZ));
            this.worldObj.func_147455_a(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c, (TileEntity)spawner);
        } else if (tile instanceof TileEntityDungeonSpawner) {
            ((TileEntityDungeonSpawner)tile).setRoom(new Vector3((double)this.posX, (double)this.posY, (double)this.posZ), new Vector3((double)this.sizeX, (double)this.sizeY, (double)this.sizeZ));
        }
    }
}

