/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Jupiter.worldgen;

import com.google.common.collect.Lists;
import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedBlaze;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedEnderman;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedMagmaCube;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedPowerSkeleton;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedRedCreeper;
import com.mjr.extraplanets.entities.monsters.EntityEvolvedWitch;
import com.mjr.extraplanets.planets.Jupiter.worldgen.BiomeDecoratorJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.JupiterBiomes;
import com.mjr.extraplanets.planets.Jupiter.worldgen.MapGenCaveJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.MapGenRavineJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.MapGenDungeon;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.RoomBossJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.RoomChestsJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.RoomEmptyJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.RoomSpawnerJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.RoomTreasureJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.village.MapGenVillageJupiter;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.ChunkProviderSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class ChunkProviderJupiter
extends ChunkProviderSpace {
    private final BiomeDecoratorJupiter biomeDecorator = new BiomeDecoratorJupiter();
    private final MapGenCaveJupiter caveGenerator = new MapGenCaveJupiter();
    private final MapGenRavineJupiter ravineGenerator = new MapGenRavineJupiter();
    private final MapGenVillageJupiter villageGenerator = new MapGenVillageJupiter();
    private final MapGenDungeon dungeonGenerator = new MapGenDungeon(ExtraPlanets_Blocks.jupiterDungeonBrick, 14, 8, 16, 3);

    public ChunkProviderJupiter(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
        this.dungeonGenerator.otherRooms.add(new RoomEmptyJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.bossRooms.add(new RoomBossJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.treasureRooms.add(new RoomTreasureJupiter(null, 0, 0, 0, ForgeDirection.UNKNOWN));
    }

    protected BiomeDecoratorSpace getBiomeGenerator() {
        return this.biomeDecorator;
    }

    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{JupiterBiomes.jupiter};
    }

    protected int getSeaLevel() {
        return 64;
    }

    protected List<MapGenBaseMeta> getWorldGenerators() {
        ArrayList generators = Lists.newArrayList();
        generators.add(this.caveGenerator);
        return generators;
    }

    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
        monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
        monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
        monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
        monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
        if (Config.evolvedMagmaCube) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedMagmaCube.class, 8, 2, 3));
        }
        if (Config.evolvedWitch) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedWitch.class, 8, 2, 3));
        }
        if (Config.evolvedEnderman) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 8, 2, 3));
        }
        if (Config.evolvedPowerSkeleton) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedPowerSkeleton.class, 8, 2, 3));
        }
        if (Config.evolvedRedCreeper) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedRedCreeper.class, 8, 2, 3));
        }
        if (Config.evolvedBlaze) {
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedBlaze.class, 8, 2, 3));
        }
        return monsters.toArray(new BiomeGenBase.SpawnListEntry[monsters.size()]);
    }

    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    protected BlockMetaPair getGrassBlock() {
        if (Config.jupiterLiquid) {
            return new BlockMetaPair(ExtraPlanets_Fluids.magma, 0);
        }
        return new BlockMetaPair(ExtraPlanets_Blocks.jupiterBlocks, 0);
    }

    protected BlockMetaPair getDirtBlock() {
        if (Config.jupiterLiquid) {
            return new BlockMetaPair(ExtraPlanets_Fluids.magma, 0);
        }
        return new BlockMetaPair(ExtraPlanets_Blocks.jupiterBlocks, 1);
    }

    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair(ExtraPlanets_Blocks.jupiterBlocks, 2);
    }

    public double getHeightModifier() {
        return 12.0;
    }

    public double getSmallFeatureHeightModifier() {
        return 26.0;
    }

    public double getMountainHeightModifier() {
        return 95.0;
    }

    public double getValleyHeightModifier() {
        return 50.0;
    }

    public int getCraterProbability() {
        return 2000;
    }

    public void onChunkProvide(int cX, int cZ, Block[] blocks, byte[] metadata) {
        this.dungeonGenerator.generateUsingArrays(this.field_73230_p, this.field_73230_p.func_72905_C(), cX * 16, 25, cZ * 16, cX, cZ, blocks, metadata);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, cX, cZ, blocks);
    }

    public void onPopulate(IChunkProvider provider, int cX, int cZ) {
        if (!Config.jupiterLiquid) {
            this.villageGenerator.func_75051_a(this.field_73230_p, this.field_73220_k, cX, cZ);
        }
        this.dungeonGenerator.handleTileEntities(this.field_73220_k);
    }

    public void func_82695_e(int par1, int par2) {
        if (!Config.jupiterLiquid) {
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, par1, par2, null);
        }
    }
}

