/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Neptune.worldgen;

import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.world.features.WorldGenCustomLake;
import com.mjr.extraplanets.world.features.WorldGenFrozenNitrogenPile;
import cpw.mods.fml.common.eventhandler.Event;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class BiomeDecoratorNeptune
extends BiomeDecoratorSpace {
    private WorldGenerator copperGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.neptuneBlocks, 4, 5, true, ExtraPlanets_Blocks.neptuneBlocks, 2);
    private WorldGenerator tinGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.neptuneBlocks, 4, 4, true, ExtraPlanets_Blocks.neptuneBlocks, 2);
    private WorldGenerator ironGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.neptuneBlocks, 8, 3, true, ExtraPlanets_Blocks.neptuneBlocks, 2);
    private WorldGenerator zincGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.neptuneBlocks, 4, 6, true, ExtraPlanets_Blocks.neptuneBlocks, 2);
    private WorldGenerator frozenNitrogenGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.frozenNitrogen, 8, 0, true, ExtraPlanets_Blocks.neptuneBlocks, 0);
    private WorldGenerator blueGemGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.neptuneBlocks, 4, 9, true, ExtraPlanets_Blocks.neptuneBlocks, 2);
    private int LakesPerChunk = 5;
    private World currentWorld;
    private boolean isDecorating = false;

    protected void setCurrentWorld(World world) {
        this.currentWorld = world;
    }

    protected World getCurrentWorld() {
        return this.currentWorld;
    }

    protected void decorate() {
        if (this.isDecorating) {
            return;
        }
        this.isDecorating = true;
        this.generateOre(26, this.copperGen, 0, 60);
        this.generateOre(23, this.tinGen, 0, 60);
        this.generateOre(20, this.ironGen, 0, 64);
        this.generateOre(20, this.zincGen, 0, 32);
        this.generateOre(5, this.frozenNitrogenGen, 0, 256);
        this.generateOre(10, this.blueGemGen, 0, 10);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        for (int i = 0; i < this.LakesPerChunk; ++i) {
            if (this.rand.nextInt(10) != 0) continue;
            int x = this.chunkX + 8;
            int z = this.chunkZ + 8;
            int y = this.currentWorld.func_72976_f(x, z);
            new WorldGenCustomLake(ExtraPlanets_Fluids.nitrogen).generate(this.currentWorld, this.rand, x, y, z, ExtraPlanets_Blocks.neptuneBlocks);
        }
        if (this.rand.nextInt(20) == 1) {
            int x = this.chunkX + 8;
            int z = this.chunkZ + 8;
            int y = this.currentWorld.func_72976_f(x, z);
            new WorldGenFrozenNitrogenPile().func_76484_a(this.currentWorld, this.rand, x, --y, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        this.isDecorating = false;
    }
}

