/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Neptune.worldgen.biome;

import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.planets.Neptune.worldgen.BiomeDecoratorNeptuneNew;
import com.mjr.extraplanets.planets.Neptune.worldgen.biome.BiomeGenNeptune;
import com.mjr.extraplanets.planets.Neptune.worldgen.biome.BiomeGenTest;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeGenBaseNeptune
extends BiomeGenBase {
    public static BiomeGenBase neptune = new BiomeGenNeptune().func_76735_a("Neptune").func_76742_b().func_76732_a(0.8f, 0.9f).func_150570_a(new BiomeGenBase.Height(0.1f, 0.2f));
    public static BiomeGenBase test = new BiomeGenTest().func_76735_a("Test").func_76742_b().func_76732_a(0.8f, 0.9f).func_150570_a(new BiomeGenBase.Height(0.1f, 0.2f));
    protected Block stoneBlock;
    protected byte topMeta;
    protected byte fillerMeta;
    protected byte stoneMeta;

    public BiomeGenBaseNeptune(int id) {
        super(id);
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.clear();
        this.field_82914_M.clear();
        this.field_76751_G = 0.0f;
        this.func_76739_b(-16744448);
        this.field_76765_S = true;
        this.field_76766_R = true;
        this.field_76752_A = ExtraPlanets_Blocks.neptuneBlocks;
        this.field_76753_B = ExtraPlanets_Blocks.neptuneBlocks;
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 100, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 100, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 100, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 100, 4, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 100, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 5, 1, 1));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntitySheep.class, 12, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityPig.class, 10, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityCow.class, 8, 4, 4));
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorNeptuneNew();
    }

    protected BiomeDecorator getBiomeDecorator() {
        return this.field_76760_I;
    }

    public void func_150573_a(World world, Random rand, Block[] block, byte[] meta, int x, int z, double stoneNoise) {
        this.generateBiomeTerrain(world, rand, block, meta, x, z, stoneNoise);
    }

    public boolean func_76738_d() {
        return this.func_150559_j() ? false : this.field_76765_S;
    }

    public void generateBiomeTerrain(World world, Random rand, Block[] block, byte[] meta, int x, int z, double stoneNoise) {
        Block topBlock = this.field_76752_A;
        byte topMeta = this.topMeta;
        Block fillerBlock = this.field_76753_B;
        int fillerMeta = this.fillerMeta;
        int currentFillerDepth = -1;
        int maxFillerDepth = (int)(stoneNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int maskX = x & 0xF;
        int maskZ = z & 0xF;
        int worldHeight = block.length / 256;
        int seaLevel = 32;
        for (int y = 255; y >= 0; --y) {
            int index = (maskZ * 16 + maskX) * worldHeight + y;
            if (y <= 0 + rand.nextInt(5)) {
                block[index] = Blocks.field_150357_h;
                continue;
            }
            Block currentBlock = block[index];
            if (currentBlock == null || currentBlock.func_149688_o() == Material.field_151579_a || currentBlock != Blocks.field_150348_b) continue;
            if (this.stoneBlock != null) {
                block[index] = this.stoneBlock;
                meta[index] = this.stoneMeta;
            }
            if (currentFillerDepth == -1) {
                if (maxFillerDepth <= 0) {
                    topBlock = null;
                    topMeta = 0;
                    fillerBlock = ExtraPlanets_Blocks.neptuneBlocks;
                    fillerMeta = 2;
                } else if (y >= seaLevel - 5 && y <= seaLevel) {
                    topBlock = this.field_76752_A;
                    topMeta = this.topMeta;
                    fillerBlock = this.field_76753_B;
                    fillerMeta = 0;
                }
                if (y < seaLevel - 1 && (topBlock == null || topBlock.func_149688_o() == Material.field_151579_a)) {
                    if (this.func_150564_a(x, y, z) < 0.15f) {
                        topBlock = Blocks.field_150432_aD;
                        topMeta = 0;
                    } else {
                        topBlock = Blocks.field_150355_j;
                        topMeta = 0;
                    }
                }
                currentFillerDepth = maxFillerDepth;
                if (y >= seaLevel - 2) {
                    block[index] = topBlock;
                    meta[index] = topMeta;
                    continue;
                }
                if (y < seaLevel - 8 - maxFillerDepth) {
                    topBlock = null;
                    fillerBlock = ExtraPlanets_Blocks.neptuneBlocks;
                    fillerMeta = 2;
                    block[index] = Blocks.field_150351_n;
                    continue;
                }
                block[index] = fillerBlock;
                meta[index] = fillerMeta;
                continue;
            }
            if (currentFillerDepth <= 0) continue;
            block[index] = fillerBlock;
            meta[index] = fillerMeta;
            if (--currentFillerDepth != 0 || fillerBlock != Blocks.field_150354_m) continue;
            currentFillerDepth = rand.nextInt(4) + Math.max(0, y - (seaLevel - 1));
            fillerBlock = Blocks.field_150322_A;
            fillerMeta = 0;
        }
    }

    public BiomeGenBase func_76739_b(int var1) {
        return super.func_76739_b(var1);
    }

    public float func_76741_f() {
        return 0.1f;
    }
}

