/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Uranus.worldgen;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.world.features.WorldGenCustomIceSpike;
import com.mjr.extraplanets.world.features.WorldGenCustomLake;
import com.mjr.extraplanets.world.features.WorldGenIgloo;
import cpw.mods.fml.common.eventhandler.Event;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class BiomeDecoratorUranus
extends BiomeDecoratorSpace {
    private WorldGenerator iceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 18, 0, true, ExtraPlanets_Blocks.uranusBlocks, 2);
    private WorldGenerator crystalGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.uranusBlocks, 4, 3, true, ExtraPlanets_Blocks.uranusBlocks, 2);
    private WorldGenerator denseIceGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.denseIce, 8, 0, true, ExtraPlanets_Blocks.uranusBlocks, 0);
    private WorldGenerator whiteGemGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.uranusBlocks, 4, 6, true, ExtraPlanets_Blocks.uranusBlocks, 2);
    private World currentWorld;
    private int iceSpikesPerChunk = 5;
    private int LakesPerChunk = 5;
    private boolean isDecorating = false;

    protected void setCurrentWorld(World world) {
        this.currentWorld = world;
    }

    protected World getCurrentWorld() {
        return this.currentWorld;
    }

    protected void decorate() {
        int y;
        int z;
        int x;
        int i;
        if (this.isDecorating) {
            return;
        }
        this.isDecorating = true;
        this.generateOre(8, this.iceGen, 50, 120);
        this.generateOre(20, this.crystalGen, 0, 32);
        this.generateOre(20, this.denseIceGen, 0, 256);
        this.generateOre(5, this.whiteGemGen, 0, 10);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        if (Config.genUranusIceSpikes) {
            for (i = 0; i < this.iceSpikesPerChunk; ++i) {
                if (this.rand.nextInt(20) != 0) continue;
                x = this.chunkX + 6;
                z = this.chunkZ + 6;
                y = this.currentWorld.func_72976_f(x, z);
                new WorldGenCustomIceSpike().generate(this.currentWorld, this.rand, x, y, z, ExtraPlanets_Blocks.uranusBlocks);
            }
        }
        for (i = 0; i < this.LakesPerChunk; ++i) {
            if (this.rand.nextInt(30) != 0) continue;
            x = this.chunkX + 8;
            z = this.chunkZ + 8;
            y = this.currentWorld.func_72976_f(x, z);
            new WorldGenCustomLake(ExtraPlanets_Fluids.frozen_water).generate(this.currentWorld, this.rand, x, y, z, ExtraPlanets_Blocks.uranusBlocks);
        }
        if (Config.genUranusIgloos && this.rand.nextInt(100) == 1) {
            int x2 = this.chunkX + 8;
            int z2 = this.chunkZ + 8;
            int y2 = this.currentWorld.func_72976_f(x2, z2);
            new WorldGenIgloo().func_76484_a(this.currentWorld, this.rand, x2, y2, z2);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.currentWorld, this.rand, this.chunkX, this.chunkZ));
        this.isDecorating = false;
    }
}

