/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Collection;
import mcjty.lib.varia.Logging;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GeneralConfiguration {
    public static final String CATEGORY_GENERAL = "general";
    public static boolean enableDimensionBuilderRecipe = true;
    public static boolean enableDimensionEditorRecipe = true;
    public static boolean enableMatterTransmitterRecipe = true;
    public static boolean enableMatterReceiverRecipe = true;
    public static boolean enableDialingDeviceRecipe = true;
    public static boolean enableBuilderRecipe = true;
    public static boolean enableShieldProjectorRecipe = true;
    public static boolean enableEndergenRecipe = true;
    public static boolean enableBlockProtectorRecipe = true;
    public static boolean enableDynamicPhaseCost = false;
    public static float dynamicPhaseCostAmount = 0.05f;
    public static int villagerId = 0;

    public static void init(Configuration cfg) {
        Logging.doLogging = cfg.get(CATEGORY_GENERAL, "logging", Logging.doLogging, "If true dump a lot of logging information about various things in RFTools. Useful for debugging.").getBoolean();
        enableDimensionBuilderRecipe = cfg.get(CATEGORY_GENERAL, "enableDimensionBuilderRecipe", enableDimensionBuilderRecipe, "Enable the dimension builder recipe.").getBoolean();
        enableDimensionEditorRecipe = cfg.get(CATEGORY_GENERAL, "enableDimensionEditorRecipe", enableDimensionEditorRecipe, "Enable the dimension editor recipe.").getBoolean();
        enableMatterTransmitterRecipe = cfg.get(CATEGORY_GENERAL, "enableMatterTransmitterRecipe", enableMatterTransmitterRecipe, "Enable the matter transmitter recipe.").getBoolean();
        enableMatterReceiverRecipe = cfg.get(CATEGORY_GENERAL, "enableMatterReceiverRecipe", enableMatterReceiverRecipe, "Enable the matter receiver recipe.").getBoolean();
        enableDialingDeviceRecipe = cfg.get(CATEGORY_GENERAL, "enableDialingDeviceRecipe", enableDialingDeviceRecipe, "Enable the dialing device recipe.").getBoolean();
        enableBuilderRecipe = cfg.get(CATEGORY_GENERAL, "enableBuilderRecipe", enableBuilderRecipe, "Enable the builder recipe.").getBoolean();
        enableShieldProjectorRecipe = cfg.get(CATEGORY_GENERAL, "enableShieldProjectorRecipe", enableShieldProjectorRecipe, "Enable the shield projector recipe.").getBoolean();
        enableEndergenRecipe = cfg.get(CATEGORY_GENERAL, "enableEndergenRecipe", enableEndergenRecipe, "Enable the endergenic generator recipe.").getBoolean();
        enableBlockProtectorRecipe = cfg.get(CATEGORY_GENERAL, "enableBlockProtectorRecipe", enableBlockProtectorRecipe, "Enable the block protector recipe.").getBoolean();
        enableDynamicPhaseCost = cfg.get(CATEGORY_GENERAL, "enableDynamicPhaseCost", enableDynamicPhaseCost, "Enable dynamic scaling of the Phase Field Generator cost based on world tick cost").getBoolean();
        dynamicPhaseCostAmount = (float)cfg.get(CATEGORY_GENERAL, "dynamicPhaseCostAmount", (double)dynamicPhaseCostAmount, "How much of the tick cost of the world is applied to the PFG cost, as a ratio from 0 to 1").getDouble();
        if ((villagerId = cfg.get(CATEGORY_GENERAL, "villagerId", villagerId, "The ID for the RFTools villager. -1 means disable, 0 means to automatically assigns an id, any other number will use that as fixed id").getInt()) == 0) {
            villagerId = GeneralConfiguration.findFreeVillagerId();
            ConfigCategory category = cfg.getCategory(CATEGORY_GENERAL);
            Property property = new Property("villagerId", Integer.toString(villagerId), Property.Type.INTEGER);
            property.comment = "The ID for the RFTools villager. -1 means disable, 0 means to automatically assigns an id, any other number will use that as fixed id";
            category.put("villagerId", property);
        }
    }

    private static int findFreeVillagerId() {
        int id = 10;
        Collection registeredVillagers = VillagerRegistry.getRegisteredVillagers();
        while (registeredVillagers.contains(id)) {
            ++id;
        }
        return id;
    }
}

