/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.spawner.GuiMatterBeamer;
import mcjty.rftools.blocks.spawner.MatterBeamerContainer;
import mcjty.rftools.blocks.spawner.MatterBeamerTileEntity;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="EnderIO")})
public class MatterBeamerBlock
extends GenericRFToolsBlock
implements Infusable,
IRedstoneConnectable {
    private IIcon iconSideOn;

    public MatterBeamerBlock() {
        super(Material.field_151573_f, MatterBeamerTileEntity.class, true);
        this.func_149663_c("matterBeamerBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This block converts matter into a beam");
            list.add(EnumChatFormatting.WHITE + "of energy. It can then send that beam to");
            list.add(EnumChatFormatting.WHITE + "a connected spawner. Connect by using a wrench.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power usage");
            list.add(EnumChatFormatting.YELLOW + "and increased speed.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof MatterBeamerTileEntity) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)te;
            Coordinate coordinate = matterBeamerTileEntity.getDestination();
            if (coordinate == null) {
                currenttip.add(EnumChatFormatting.RED + "Not connected to a spawner!");
            } else {
                currenttip.add(EnumChatFormatting.GREEN + "Connected!");
            }
        }
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_MATTER_BEAMER;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        MatterBeamerTileEntity beamerTileEntity = (MatterBeamerTileEntity)tileEntity;
        MatterBeamerContainer beamerContainer = new MatterBeamerContainer(entityPlayer, beamerTileEntity);
        return new GuiMatterBeamer(beamerTileEntity, beamerContainer);
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new MatterBeamerContainer(entityPlayer, (MatterBeamerTileEntity)tileEntity);
    }

    protected boolean wrenchUse(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)world.func_147438_o(x, y, z);
            world.func_72980_b((double)x, (double)y, (double)z, "note.pling", 1.0f, 1.0f, false);
            matterBeamerTileEntity.useWrench(player);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:machineBeamerOff");
        this.iconSideOn = iconRegister.func_94245_a("rftools:machineBeamer");
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int meta = blockAccess.func_72805_g(x, y, z);
        if ((meta & 1) > 0) {
            return this.iconSideOn;
        }
        return this.iconSide;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.iconSide;
    }
}

