/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import java.io.File;
import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CmdSaveDims
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<directory>";
    }

    @Override
    public String getCommand() {
        return "savedims";
    }

    @Override
    public int getPermissionLevel() {
        return 1;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The directory parameters is missing!"));
            return;
        }
        if (args.length > 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
            return;
        }
        String directory = this.fetchString(sender, args, 1, null);
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        if (!new File(directory).mkdirs()) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Failed to create directory!"));
            return;
        }
        World world = sender.func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        for (Integer dim : dimensionManager.getDimensions().keySet()) {
            String filename;
            String error;
            DimensionInformation information = dimensionManager.getDimensionInformation(dim);
            if (information == null || (error = information.buildJson(filename = directory + "dimension" + dim)) == null) continue;
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Error: " + error));
        }
    }
}

