/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.utils;

import java.util.ArrayList;
import java.util.List;
import neresources.api.utils.Modifier;
import neresources.api.utils.conditionals.Conditional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class DropItem
implements Comparable<DropItem> {
    public int minDrop;
    public int maxDrop;
    public ItemStack item;
    public float chance;
    public List<String> conditionals = new ArrayList<String>();
    private float sortIndex;

    public DropItem(ItemStack item, float chance) {
        this(item, 0, 1, chance, new Conditional[0]);
    }

    public DropItem(ItemStack item, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(item, minDrop, maxDrop, 1.0f, conditionals);
    }

    public DropItem(ItemStack item, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this.item = item;
        this.minDrop = minDrop;
        this.maxDrop = maxDrop;
        this.chance = chance;
        this.sortIndex = Math.min(chance, 1.0f) * (float)(minDrop + maxDrop);
        for (Conditional conditional : conditionals) {
            this.conditionals.add(conditional.toString());
        }
    }

    public DropItem(Item item, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(new ItemStack(item), minDrop, maxDrop, 1.0f, conditionals);
    }

    public DropItem(Item item, int itemDamage, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(new ItemStack(item, 1, itemDamage), minDrop, maxDrop, 1.0f, conditionals);
    }

    public DropItem(Item item, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this(new ItemStack(item), minDrop, maxDrop, chance, conditionals);
    }

    public DropItem(Item item, int itemDamage, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this(new ItemStack(item, 1, itemDamage), minDrop, maxDrop, chance, conditionals);
    }

    public String toString() {
        if (this.minDrop == this.maxDrop) {
            return this.minDrop + this.getDropChance();
        }
        return this.minDrop + "-" + this.maxDrop + this.getDropChance();
    }

    private String getDropChance() {
        return this.chance < 1.0f ? " (" + this.formatChance() + "%)" : "";
    }

    private String formatChance() {
        float chance = this.chance * 100.0f;
        if (chance < 10.0f) {
            return String.format("%.1f", Float.valueOf(chance));
        }
        return String.format("%2d", (int)chance);
    }

    public List<String> getTooltipText() {
        return this.conditionals;
    }

    public void addConditionals(List<String> conditionals) {
        this.conditionals.addAll(conditionals);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("stack", (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
        compound.func_74768_a("max", this.maxDrop);
        compound.func_74768_a("min", this.minDrop);
        compound.func_74776_a("chance", this.chance);
        NBTTagList conditionals = new NBTTagList();
        for (String condition : this.conditionals) {
            conditionals.func_74742_a((NBTBase)new NBTTagString(condition));
        }
        compound.func_74782_a("conditionals", (NBTBase)conditionals);
        return compound;
    }

    public static DropItem readFromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound item = tagCompound.func_74775_l("stack");
        if (item.func_82582_d()) {
            return null;
        }
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)item);
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        int max = Math.max(tagCompound.func_74762_e("max"), 1);
        int min = tagCompound.func_74762_e("min");
        float chance = tagCompound.func_74760_g("chance");
        if (chance == 0.0f) {
            chance = 1.0f;
        }
        Conditional[] conditionals = DropItem.decodeConditionals(tagCompound.func_150295_c("conditionals", 8));
        return new DropItem(stack, min, max, chance, conditionals);
    }

    public static Conditional[] decodeConditionals(NBTTagList conditional) {
        ArrayList<Conditional> result = new ArrayList<Conditional>();
        for (int i = 0; i < conditional.func_74745_c(); ++i) {
            String condition = conditional.func_150307_f(i);
            if (condition.equals("")) continue;
            result.add(new Conditional(condition, new Modifier[0]));
        }
        return result.toArray(new Conditional[result.size()]);
    }

    public float getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public int compareTo(DropItem o) {
        float result = this.getSortIndex() - o.getSortIndex();
        return result < 0.0f ? 1 : -1;
    }
}

