/*
 * Decompiled with CFR 0.152.
 */
package neresources.compatibility.reliquary;

import neresources.api.messages.ModifyMobMessage;
import neresources.api.utils.DropItem;
import neresources.api.utils.LightLevel;
import neresources.api.utils.conditionals.Conditional;
import neresources.compatibility.CompatBase;
import neresources.entries.MobEntry;
import neresources.registry.MessageRegistry;
import neresources.utils.ReflectionHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.item.Item;
import xreliquary.Reliquary;
import xreliquary.event.CommonEventHandler;
import xreliquary.init.XRRecipes;

public class ReliquaryCompat
extends CompatBase {
    @Override
    protected void init() {
        if (ReflectionHelper.doesFieldExist(Reliquary.class, "CONTENT")) {
            this.registerReliquaryMobs();
        } else {
            this.registerReliquaryOldMobs();
        }
    }

    private void registerReliquaryOldMobs() {
        DropItem beak = new DropItem((Item)Item.field_150901_e.func_82594_a("xreliquary:squid_beak"), 1, 1, 0.04f, Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntitySquid.class, beak));
        DropItem witch_hat = new DropItem((Item)Item.field_150901_e.func_82594_a("xreliquary:witch_hat"), 0, 1, Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityWitch.class, witch_hat));
    }

    private void registerReliquaryMobs() {
        CommonEventHandler eventHandler = new CommonEventHandler();
        DropItem squid_beak = new DropItem(XRRecipes.ingredient((int)12), 1, 1, eventHandler.getBaseDrop("squid_beak"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntitySquid.class, squid_beak));
        DropItem witch_hat = new DropItem(XRRecipes.getItem((String)"witch_hat"), 1, 1, eventHandler.getBaseDrop("witch_hat"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityWitch.class, witch_hat));
        DropItem spider_fangs = new DropItem(XRRecipes.ingredient((int)2), 1, 1, eventHandler.getBaseDrop("spider_chelicerae"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntitySpider.class, true, spider_fangs));
        DropItem cave_spider_fangs = new DropItem(XRRecipes.ingredient((int)2), 1, 1, eventHandler.getBaseDrop("cave_spider_chelicerae"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityCaveSpider.class, cave_spider_fangs));
        DropItem rib_bone = new DropItem(XRRecipes.ingredient((int)0), 1, 1, eventHandler.getBaseDrop("rib_bone"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntitySkeleton.class, true, rib_bone));
        DropItem withered_rib = new DropItem(XRRecipes.ingredient((int)1), 1, 1, eventHandler.getBaseDrop("wither_rib"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntitySkeleton.class, true, true, withered_rib));
        DropItem zombie_heart = new DropItem(XRRecipes.ingredient((int)6), 1, 1, eventHandler.getBaseDrop("necrotic_heart_zombie"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityZombie.class, true, zombie_heart));
        DropItem pigman_heart = new DropItem(XRRecipes.ingredient((int)6), 1, 1, eventHandler.getBaseDrop("necrotic_heart_pigman"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityPigZombie.class, pigman_heart));
        DropItem slime_pearl = new DropItem(XRRecipes.ingredient((int)4), 1, 1, eventHandler.getBaseDrop("slime_pearl"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntitySlime.class, slime_pearl));
        DropItem blaze_molten_core = new DropItem(XRRecipes.ingredient((int)7), 1, 1, eventHandler.getBaseDrop("molten_core_blaze"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityBlaze.class, blaze_molten_core));
        DropItem magma_cube_molten_core = new DropItem(XRRecipes.ingredient((int)7), 1, 1, eventHandler.getBaseDrop("molten_core_magma_cube"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityMagmaCube.class, magma_cube_molten_core));
        DropItem ghast_gland = new DropItem(XRRecipes.ingredient((int)3), 1, 1, eventHandler.getBaseDrop("catalyzing_gland_ghast"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityGhast.class, ghast_gland));
        DropItem creeper_gland = new DropItem(XRRecipes.ingredient((int)3), 1, 1, eventHandler.getBaseDrop("catalyzing_gland_creeper"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityCreeper.class, creeper_gland));
        DropItem eye_of_the_storm = new DropItem(XRRecipes.ingredient((int)8), 1, 1, eventHandler.getBaseDrop("eye_of_the_storm"), Conditional.playerKill);
        EntityCreeper chargedCreeper = new EntityCreeper(world);
        chargedCreeper.func_70096_w().func_75692_b(17, (Object)1);
        this.registerMob(new MobEntry((EntityLivingBase)chargedCreeper, LightLevel.hostile, eye_of_the_storm));
        DropItem ender_heart = new DropItem(XRRecipes.ingredient((int)11), 1, 1, eventHandler.getBaseDrop("nebulous_heart"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityEnderman.class, ender_heart));
        DropItem bat_wing = new DropItem(XRRecipes.ingredient((int)5), 1, 1, eventHandler.getBaseDrop("bat_wing"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityBat.class, bat_wing));
        DropItem frozen_core = new DropItem(XRRecipes.ingredient((int)10), 1, 1, eventHandler.getBaseDrop("frozen_core"), Conditional.playerKill);
        MessageRegistry.addMessage(new ModifyMobMessage(EntitySnowman.class, frozen_core));
    }
}

