/*
 * Decompiled with CFR 0.152.
 */
package neresources.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import neresources.api.messages.Message;
import neresources.api.messages.SendMessage;
import neresources.network.message.ClientSyncRequestMessage;
import neresources.utils.LogHelper;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class ClientSyncMessage
implements IMessage,
IMessageHandler<ClientSyncRequestMessage, ClientSyncMessage> {
    private List<Message.Storage> storageList;

    public ClientSyncMessage() {
        this.storageList = new LinkedList<Message.Storage>();
    }

    public ClientSyncMessage(List<Message.Storage> storageList) {
        LogHelper.info("Sending Sync...");
        this.storageList = storageList;
    }

    public List<Message.Storage> getStorageList() {
        return this.storageList;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            if (!buf.readBoolean()) continue;
            int keySize = buf.readInt();
            String key = new String(buf.readBytes(keySize).array());
            int messageSize = buf.readInt();
            byte[] message = buf.readBytes(messageSize).array();
            try {
                NBTTagCompound messageTag = CompressedStreamTools.func_152457_a((byte[])message, (NBTSizeTracker)new NBTSizeTracker((long)(message.length * 8)));
                this.storageList.add(new Message.Storage(key, messageTag));
                continue;
            }
            catch (IOException e) {
                LogHelper.warn("Failed to read message with key " + key);
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.storageList.size());
        for (Message.Storage stored : this.storageList) {
            try {
                byte[] bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)stored.getMessageNBT());
                buf.writeBoolean(true);
                buf.writeInt(stored.getKey().getBytes().length);
                buf.writeBytes(stored.getKey().getBytes());
                buf.writeInt(bytes.length);
                buf.writeBytes(bytes);
            }
            catch (IOException e) {
                LogHelper.warn("Dropped message with key " + stored.getKey());
                buf.writeBoolean(false);
                e.printStackTrace();
            }
        }
    }

    public ClientSyncMessage onMessage(ClientSyncRequestMessage message, MessageContext ctx) {
        LogHelper.info("Received Sync Request");
        return new ClientSyncMessage(SendMessage.getStorage());
    }
}

