/*
 * Decompiled with CFR 0.152.
 */
package neresources.registry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import neresources.entries.EnchantmentEntry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class EnchantmentRegistry {
    private static Set<EnchantmentEntry> enchantments = new HashSet<EnchantmentEntry>();
    private static EnchantmentRegistry instance = null;

    public static EnchantmentRegistry getInstance() {
        if (instance == null) {
            instance = new EnchantmentRegistry();
            return instance;
        }
        return instance;
    }

    public EnchantmentRegistry() {
        for (Enchantment enchantment : Enchantment.field_77331_b) {
            if (enchantment == null) continue;
            enchantments.add(new EnchantmentEntry(enchantment));
        }
    }

    public Set<EnchantmentEntry> getEnchantments(ItemStack itemStack) {
        HashSet<EnchantmentEntry> set = new HashSet<EnchantmentEntry>();
        for (EnchantmentEntry enchantment : enchantments) {
            if (itemStack.func_77973_b() == Items.field_151122_aG && enchantment.getEnchantment().isAllowedOnBooks()) {
                set.add(enchantment);
                continue;
            }
            if (!enchantment.getEnchantment().func_92089_a(itemStack)) continue;
            set.add(enchantment);
        }
        return set;
    }

    public Set<EnchantmentEntry> getEnchantments() {
        return enchantments;
    }

    private void excludeFormRegistry(Enchantment enchantment) {
        Iterator<EnchantmentEntry> itr = enchantments.iterator();
        while (itr.hasNext()) {
            if (itr.next().getEnchantment().field_77352_x != enchantment.field_77352_x) continue;
            itr.remove();
        }
    }

    private void excludeFormRegistry(String sEnchantment) {
        for (Enchantment enchantment : Enchantment.field_77331_b) {
            if (enchantment == null || !enchantment.func_77320_a().toLowerCase().contains(sEnchantment.toLowerCase())) continue;
            this.excludeFormRegistry(enchantment);
        }
    }

    public void removeAll(String[] excludedEnchants) {
        for (String enchant : excludedEnchants) {
            this.excludeFormRegistry(enchant);
        }
    }

    public void clear() {
        instance = new EnchantmentRegistry();
    }
}

