/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerOreDictExport;
import extracells.gui.GuiOreDictExport;
import extracells.part.PartECBase;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.render.TextureManager;
import extracells.util.ItemUtils;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class PartOreDictExporter
extends PartECBase
implements IGridTickable {
    public String filter = "";

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    private boolean checkItem(IAEItemStack s) {
        int[] ids;
        if (s == null || this.filter.equals("")) {
            return false;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)s.getItemStack())) {
            String filter2;
            String name = OreDictionary.getOreName((int)id);
            if (this.filter.startsWith("*") && this.filter.endsWith("*")) {
                filter2 = this.filter.replace("*", "");
                if (filter2.equals("")) {
                    return true;
                }
                if (!name.contains(filter2)) continue;
                return true;
            }
            if (!(this.filter.startsWith("*") ? name.endsWith(filter2 = this.filter.replace("*", "")) : (this.filter.endsWith("*") ? name.startsWith(filter2 = this.filter.replace("*", "")) : name.equals(this.filter)))) continue;
            return true;
        }
        return false;
    }

    public boolean doWork(int rate, int TicksSinceLastCall) {
        int amount = rate * TicksSinceLastCall >= 64 ? 64 : rate * TicksSinceLastCall;
        IStorageGrid storage = this.getStorageGrid();
        IAEItemStack stack = null;
        for (IAEItemStack s : storage.getItemInventory().getStorageList()) {
            if (!this.checkItem(s.copy())) continue;
            stack = s.copy();
            break;
        }
        if (stack == null) {
            return false;
        }
        stack.setStackSize((long)amount);
        stack = (IAEItemStack)storage.getItemInventory().extractItems((IAEStack)stack.copy(), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        if (stack == null) {
            return false;
        }
        IAEItemStack exported = this.exportStack(stack.copy());
        if (exported == null) {
            return false;
        }
        storage.getItemInventory().extractItems((IAEStack)exported, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        return true;
    }

    public IAEItemStack exportStack(IAEItemStack stack0) {
        block10: {
            if (this.tile == null || !this.tile.func_145830_o() || stack0 == null) {
                return null;
            }
            ForgeDirection dir = this.getSide();
            TileEntity tile = this.tile.func_145831_w().func_147438_o(this.tile.field_145851_c + dir.offsetX, this.tile.field_145848_d + dir.offsetY, this.tile.field_145849_e + dir.offsetZ);
            if (tile == null) {
                return null;
            }
            IAEItemStack stack = stack0.copy();
            if (!(tile instanceof IInventory)) break block10;
            if (tile instanceof ISidedInventory) {
                ISidedInventory inv = (ISidedInventory)tile;
                for (int i : inv.func_94128_d(dir.getOpposite().ordinal())) {
                    if (!inv.func_102007_a(i, stack.getItemStack(), dir.getOpposite().ordinal())) continue;
                    if (inv.func_70301_a(i) == null) {
                        inv.func_70299_a(i, stack.getItemStack());
                        return stack0;
                    }
                    if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), stack.getItemStack())) continue;
                    int max = inv.func_70297_j_();
                    int current = inv.func_70301_a((int)i).field_77994_a;
                    int outStack = (int)stack.getStackSize();
                    if (max == current) continue;
                    if (current + outStack <= max) {
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.field_77994_a += outStack;
                        inv.func_70299_a(i, s);
                        return stack0;
                    }
                    ItemStack s = inv.func_70301_a(i).func_77946_l();
                    s.field_77994_a = max;
                    inv.func_70299_a(i, s);
                    stack.setStackSize((long)(max - current));
                    return stack;
                }
            } else {
                IInventory inv = (IInventory)tile;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    if (!inv.func_94041_b(i, stack.getItemStack())) continue;
                    if (inv.func_70301_a(i) == null) {
                        inv.func_70299_a(i, stack.getItemStack());
                        return stack0;
                    }
                    if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), stack.getItemStack())) continue;
                    int max = inv.func_70297_j_();
                    int current = inv.func_70301_a((int)i).field_77994_a;
                    int outStack = (int)stack.getStackSize();
                    if (max == current) continue;
                    if (current + outStack <= max) {
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.field_77994_a += outStack;
                        inv.func_70299_a(i, s);
                        return stack0;
                    }
                    ItemStack s = inv.func_70301_a(i).func_77946_l();
                    s.field_77994_a = max;
                    inv.func_70299_a(i, s);
                    stack.setStackSize((long)(max - current));
                    return stack;
                }
            }
        }
        return null;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiOreDictExport(player, this);
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        ItemStack is = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID(this));
        if (type != PartItemStack.Break) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("filter", this.filter);
            is.func_77982_d(tag);
        }
        return is;
    }

    @Override
    public double getPowerUsage() {
        return 10.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerOreDictExport(player, this);
    }

    private IStorageGrid getStorageGrid() {
        IGridNode node = this.getGridNode();
        if (node == null) {
            return null;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return null;
        }
        return (IStorageGrid)grid.getCache(IStorageGrid.class);
    }

    public final TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound data, List<String> list) {
        super.getWailaBodey(data, list);
        if (data.func_74764_b("name")) {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.oredict") + ": " + data.func_74779_i("name"));
        } else {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.oredict") + ":");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        super.getWailaTag(tag);
        tag.func_74778_a("name", this.filter);
        return tag;
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange event) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("filter")) {
            this.filter = data.func_74779_i("filter");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        rh.setTexture(TextureManager.EXPORT_SIDE.getTexture());
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        IIcon side = TextureManager.EXPORT_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.EXPORT_FRONT.getTexture(), side, side);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setInvColor(AEColor.Black.mediumVariant);
        ts.func_78380_c(0xF000F0);
        rh.renderInventoryFace(TextureManager.EXPORT_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        rh.setTexture(TextureManager.EXPORT_SIDE.getTexture());
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        IIcon side = TextureManager.EXPORT_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.EXPORT_FRONT.getTextures()[0], side, side);
        rh.setBounds(6.0f, 6.0f, 15.0f, 10.0f, 10.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        ts.func_78378_d(AEColor.Black.mediumVariant);
        if (this.isActive()) {
            ts.func_78380_c(0xF000F0);
        }
        rh.renderFace(x, y, z, TextureManager.EXPORT_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    public final TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.isActive()) {
            return this.doWork(10, TicksSinceLastCall) ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        return TickRateModulation.SLOWER;
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged channel) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74778_a("filter", this.filter);
    }
}

