/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.minecraft.McBlockPart;
import codechicken.multipart.minecraft.McSidedMetaPart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ButtonPart
extends McSidedMetaPart
implements IFaceRedstonePart {
    public static BlockButton stoneButton = (BlockButton)Blocks.field_150430_aB;
    public static BlockButton woodenButton = (BlockButton)Blocks.field_150471_bO;
    public static int[] metaSideMap = new int[]{-1, 4, 5, 2, 3};
    public static int[] sideMetaMap = new int[]{-1, -1, 3, 4, 1, 2};

    public static BlockButton getButton(int meta) {
        return (meta & 0x10) > 0 ? woodenButton : stoneButton;
    }

    public ButtonPart() {
    }

    public ButtonPart(int meta) {
        super(meta);
    }

    @Override
    public int sideForMeta(int meta) {
        return metaSideMap[meta & 7];
    }

    @Override
    public Block getBlock() {
        return ButtonPart.getButton(this.meta);
    }

    @Override
    public String getType() {
        return "mc_button";
    }

    public int delay() {
        return this.sensitive() ? 30 : 20;
    }

    public boolean sensitive() {
        return (this.meta & 0x10) > 0;
    }

    @Override
    public Cuboid6 getBounds() {
        double d;
        int m = this.meta & 7;
        double d2 = d = this.pressed() ? 0.0625 : 0.125;
        if (m == 1) {
            return new Cuboid6(0.0, 0.375, 0.3125, d, 0.625, 0.6875);
        }
        if (m == 2) {
            return new Cuboid6(1.0 - d, 0.375, 0.3125, 1.0, 0.625, 0.6875);
        }
        if (m == 3) {
            return new Cuboid6(0.3125, 0.375, 0.0, 0.6875, 0.625, d);
        }
        if (m == 4) {
            return new Cuboid6(0.3125, 0.375, 1.0 - d, 0.6875, 0.625, 1.0);
        }
        return null;
    }

    public static McBlockPart placement(World world, BlockCoord pos, int side, int type) {
        if (side == 0 || side == 1) {
            return null;
        }
        pos = pos.copy().offset(side ^ 1);
        if (!world.isSideSolid(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)side))) {
            return null;
        }
        return new ButtonPart(sideMetaMap[side ^ 1] | type << 4);
    }

    @Override
    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (this.pressed()) {
            return false;
        }
        if (!this.world().field_72995_K) {
            this.toggle();
        }
        return true;
    }

    @Override
    public void scheduledTick() {
        if (this.pressed()) {
            this.updateState();
        }
    }

    public boolean pressed() {
        return (this.meta & 8) > 0;
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (!this.pressed() && !this.world().field_72995_K && entity instanceof EntityArrow) {
            this.updateState();
        }
    }

    private void toggle() {
        boolean in = !this.pressed();
        this.meta = (byte)(this.meta ^ 8);
        this.world().func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "random.click", 0.3f, in ? 0.6f : 0.5f);
        if (in) {
            this.scheduleTick(this.delay());
        }
        this.sendDescUpdate();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        this.tile().func_70296_d();
    }

    private void updateState() {
        boolean pressed;
        boolean arrows = this.sensitive() && !this.world().func_72872_a(EntityArrow.class, this.getBounds().add(Vector3.fromTileEntity((TileEntity)this.tile())).toAABB()).isEmpty();
        if (arrows != (pressed = this.pressed())) {
            this.toggle();
        }
        if (arrows && pressed) {
            this.scheduleTick(this.delay());
        }
    }

    @Override
    public void onRemoved() {
        if (this.pressed()) {
            this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.pressed() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.pressed() && side == metaSideMap[this.meta & 7] ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return metaSideMap[this.meta & 7];
    }
}

