/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.api.guide;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.FTBLib;
import ftb.lib.FTBWorld;
import ftb.lib.api.cmd.ICustomCommandInfo;
import ftb.lib.api.notification.ClickAction;
import ftb.lib.api.notification.ClickActionType;
import ftb.utils.api.guide.EventFTBUServerGuide;
import ftb.utils.api.guide.GuidePage;
import ftb.utils.api.guide.Top;
import ftb.utils.api.guide.lines.GuideExtendedTextLine;
import ftb.utils.mod.FTBU;
import ftb.utils.mod.FTBUTicks;
import ftb.utils.mod.config.FTBUConfigBackups;
import ftb.utils.mod.config.FTBUConfigGeneral;
import ftb.utils.mod.config.FTBUConfigLogin;
import ftb.utils.mod.config.FTBUConfigTops;
import ftb.utils.world.Backups;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldServer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import latmod.lib.LMFileUtils;
import latmod.lib.LMStringUtils;
import latmod.lib.LMUtils;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ServerGuideFile
extends GuidePage {
    private List<LMPlayerServer> players = null;
    private LMPlayerServer self;
    private GuidePage categoryTops = null;

    public ServerGuideFile(LMPlayerServer pself) {
        super(CachedInfo.main.getID());
        this.setTitle(CachedInfo.main.getTitleComponent());
        this.self = pself;
        if (this.self == null) {
            return;
        }
        boolean isDedi = FTBLib.getServer().func_71262_S();
        if (!FTBUConfigLogin.motd.components.isEmpty()) {
            for (IChatComponent iChatComponent : FTBUConfigLogin.motd.components) {
                this.println(iChatComponent);
            }
            this.text.add(null);
        }
        this.copyFrom(CachedInfo.main);
        this.categoryTops = this.getSub("tops").setTitle(FTBU.mod.chatComponent("top.title", new Object[0]));
        this.players = LMWorldServer.inst.getServerPlayers();
        for (LMPlayerServer lMPlayerServer : this.players) {
            lMPlayerServer.refreshStats();
        }
        if (FTBUConfigGeneral.restart_timer.get() > 0.0) {
            this.println(FTBU.mod.chatComponent("cmd.timer_restart", new Object[]{LMStringUtils.getTimeString((long)(FTBUTicks.restartMillis - LMUtils.millis()))}));
        }
        if (FTBUConfigBackups.enabled.get()) {
            this.println(FTBU.mod.chatComponent("cmd.timer_backup", new Object[]{LMStringUtils.getTimeString((long)(Backups.nextBackup - LMUtils.millis()))}));
        }
        if (FTBUConfigGeneral.server_info_difficulty.get()) {
            this.println(FTBU.mod.chatComponent("cmd.world_difficulty", new Object[]{LMStringUtils.firstUppercase((String)pself.getPlayer().field_70170_p.field_73013_u.toString().toLowerCase())}));
        }
        if (FTBUConfigGeneral.server_info_mode.get()) {
            this.println(FTBU.mod.chatComponent("cmd.ftb_gamemode", new Object[]{LMStringUtils.firstUppercase((String)FTBWorld.server.getMode().toString().toLowerCase())}));
        }
        if (FTBUConfigTops.first_joined.get()) {
            this.addTop(Top.first_joined);
        }
        if (FTBUConfigTops.deaths.get()) {
            this.addTop(Top.deaths);
        }
        if (FTBUConfigTops.deaths_ph.get()) {
            this.addTop(Top.deaths_ph);
        }
        if (FTBUConfigTops.last_seen.get()) {
            this.addTop(Top.last_seen);
        }
        if (FTBUConfigTops.time_played.get()) {
            this.addTop(Top.time_played);
        }
        new EventFTBUServerGuide(this, this.self).post();
        GuidePage page = this.getSub("commands").setTitle((IChatComponent)new ChatComponentText("Commands"));
        page.clear();
        try {
            for (ICommand c : FTBLib.getAllCommands((ICommandSender)this.self.getPlayer())) {
                try {
                    GuidePage cat = new GuidePage('/' + c.func_71517_b());
                    List al = c.func_71514_a();
                    if (al != null && !al.isEmpty()) {
                        for (Object s : al) {
                            cat.printlnText('/' + (String)s);
                        }
                    }
                    if (c instanceof ICustomCommandInfo) {
                        Object s;
                        ArrayList list = new ArrayList();
                        ((ICustomCommandInfo)c).addInfo(list, (ICommandSender)this.self.getPlayer());
                        s = list.iterator();
                        while (s.hasNext()) {
                            IChatComponent c1 = (IChatComponent)s.next();
                            cat.println(c1);
                        }
                    } else {
                        String usage = c.func_71518_a((ICommandSender)this.self.getPlayer());
                        if (usage != null) {
                            if (usage.indexOf(10) != -1) {
                                String[] usageL;
                                for (String s1 : usageL = usage.split("\n")) {
                                    cat.printlnText(s1);
                                }
                            } else if (usage.indexOf(37) != -1 || usage.indexOf(47) != -1) {
                                cat.println((IChatComponent)new ChatComponentText(usage));
                            } else {
                                cat.println((IChatComponent)new ChatComponentTranslation(usage, new Object[0]));
                            }
                        }
                    }
                    cat.setParent(page);
                    page.addSub(cat);
                }
                catch (Exception ex1) {
                    ChatComponentText cc = new ChatComponentText('/' + c.func_71517_b());
                    cc.func_150256_b().func_150238_a(EnumChatFormatting.DARK_RED);
                    page.getSub('/' + c.func_71517_b()).setTitle((IChatComponent)cc).printlnText("Errored");
                    if (!FTBLib.DEV_ENV) continue;
                    ex1.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        page = this.getSub("warps").setTitle((IChatComponent)new ChatComponentText("Warps"));
        for (String s : LMWorldServer.inst.warps.list()) {
            GuideExtendedTextLine guideExtendedTextLine = new GuideExtendedTextLine(page, (IChatComponent)new ChatComponentText(s));
            guideExtendedTextLine.setClickAction(new ClickAction(ClickActionType.CMD, (JsonElement)new JsonPrimitive("warp " + s)));
            page.text.add(guideExtendedTextLine);
        }
        page = this.getSub("homes").setTitle((IChatComponent)new ChatComponentText("Homes"));
        for (String s : this.self.homes.list()) {
            GuideExtendedTextLine guideExtendedTextLine = new GuideExtendedTextLine(page, (IChatComponent)new ChatComponentText(s));
            guideExtendedTextLine.setClickAction(new ClickAction(ClickActionType.CMD, (JsonElement)new JsonPrimitive("home " + s)));
            page.text.add(guideExtendedTextLine);
        }
        this.cleanup();
        this.sortAll();
    }

    public void addTop(Top t) {
        GuidePage thisTop = this.categoryTops.getSub(t.ID).setTitle(t.title);
        Collections.sort(this.players, t);
        int size = Math.min(this.players.size(), 250);
        for (int j = 0; j < size; ++j) {
            LMPlayerServer p = this.players.get(j);
            Object data = t.getData(p);
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append(j + 1);
            sb.append(']');
            sb.append(' ');
            sb.append(p.getProfile().getName());
            sb.append(':');
            sb.append(' ');
            if (!(data instanceof IChatComponent)) {
                sb.append(data);
            }
            ChatComponentText c = new ChatComponentText(sb.toString());
            if (p == this.self) {
                c.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GREEN);
            } else if (j < 3) {
                c.func_150256_b().func_150238_a(EnumChatFormatting.LIGHT_PURPLE);
            }
            if (data instanceof IChatComponent) {
                c.func_150257_a(FTBLib.getChatComponent((Object)data));
            }
            thisTop.println((IChatComponent)c);
        }
    }

    public static class CachedInfo {
        public static final GuidePage main = new GuidePage("server_info").setTitle((IChatComponent)new ChatComponentTranslation("player_action.ftbu.server_info", new Object[0]));
        public static GuidePage categoryServer;

        public static void reload() {
            File[] f;
            main.clear();
            File file = new File(FTBLib.folderLocal, "guide/");
            if (file.exists() && file.isDirectory() && (f = file.listFiles()) != null && f.length > 0) {
                Arrays.sort(f, LMFileUtils.fileComparator);
                for (int i = 0; i < f.length; ++i) {
                    GuidePage.loadFromFiles(main, f[i]);
                }
            }
            if ((file = new File(FTBLib.folderLocal, "guide_cover.txt")).exists() && file.isFile()) {
                try {
                    String text = LMFileUtils.loadAsText((File)file);
                    if (text != null && !text.isEmpty()) {
                        main.printlnText(text.replace("\r", ""));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            main.cleanup();
        }
    }
}

