/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.api.guide.lines;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.FTBLib;
import ftb.lib.TextureCoords;
import ftb.lib.api.client.FTBLibClient;
import ftb.utils.api.guide.GuidePage;
import ftb.utils.api.guide.lines.GuideExtendedTextLine;
import ftb.utils.mod.client.gui.guide.ButtonGuideImage;
import ftb.utils.mod.client.gui.guide.ButtonGuideTextLine;
import ftb.utils.mod.client.gui.guide.GuiGuide;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import latmod.lib.LMUtils;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;

public class GuideImageLine
extends GuideExtendedTextLine {
    private String imageURL;
    private TextureCoords texture;
    private double displayW;
    private double displayH;
    private double displayS;

    public GuideImageLine(GuidePage c) {
        super(c, (IChatComponent)null);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureCoords getImage() {
        if (this.texture == TextureCoords.nullTexture) {
            return null;
        }
        if (this.texture != null) {
            return this.texture;
        }
        if (this.imageURL == null) {
            return null;
        }
        this.texture = TextureCoords.nullTexture;
        try {
            File file = new File(FTBLib.folderModpack, "images/" + this.imageURL);
            if (FTBLib.DEV_ENV) {
                FTBLib.dev_logger.info("Loading Guide image: " + file.getAbsolutePath());
            }
            BufferedImage img = ImageIO.read(file);
            ResourceLocation tex = FTBLibClient.mc.func_110434_K().func_110578_a("ftbu_guide/" + this.imageURL, new DynamicTexture(img));
            this.texture = new TextureCoords(tex, 0.0, 0.0, (double)img.getWidth(), (double)img.getHeight(), (double)img.getWidth(), (double)img.getHeight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.texture;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureCoords getDisplayImage() {
        double w;
        TextureCoords img = this.getImage();
        if (img == null) {
            return null;
        }
        double d = this.displayW > 0.0 ? this.displayW : (this.displayS == 0.0 ? this.texture.width : (w = this.displayS > 0.0 ? this.texture.width * this.displayS : this.texture.width / -this.displayS));
        double h = this.displayH > 0.0 ? this.displayH : (this.displayS == 0.0 ? this.texture.height : (this.displayS > 0.0 ? this.texture.height * this.displayS : this.texture.height / -this.displayS));
        return new TextureCoords(this.texture.texture, 0.0, 0.0, w, h, w, h);
    }

    public void setImage(String img) {
        String imageURL0 = this.imageURL == null ? null : this.imageURL + "";
        this.imageURL = img;
        if (!LMUtils.areObjectsEqual((Object)imageURL0, (Object)this.imageURL, (boolean)true)) {
            this.texture = null;
        }
        if (this.imageURL != null) {
            this.text = null;
        }
    }

    public void setImage(TextureCoords t) {
        this.texture = t;
        this.imageURL = null;
        this.text = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ButtonGuideTextLine createWidget(GuiGuide gui) {
        if (this.getImage() == null) {
            return null;
        }
        return new ButtonGuideImage(gui, this);
    }

    @Override
    public void func_152753_a(JsonElement e) {
        super.func_152753_a(e);
        this.displayS = 0.0;
        this.displayH = 0.0;
        this.displayW = 0.0;
        JsonObject o = e.getAsJsonObject();
        this.setImage(o.has("image") ? o.get("image").getAsString() : null);
        if (o.has("scale")) {
            this.displayS = o.get("scale").getAsDouble();
        } else {
            if (o.has("width")) {
                this.displayW = o.get("width").getAsDouble();
            }
            if (o.has("height")) {
                this.displayH = o.get("height").getAsDouble();
            }
        }
    }

    @Override
    public JsonElement func_151003_a() {
        JsonObject o = (JsonObject)super.func_151003_a();
        if (this.imageURL != null && !this.imageURL.isEmpty()) {
            o.add("image", (JsonElement)new JsonPrimitive(this.imageURL));
        }
        return o;
    }
}

