/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.badges;

import ftb.utils.badges.Badge;
import ftb.utils.net.MessageRequestBadge;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ClientBadges {
    private static final Map<String, Badge> map = new HashMap<String, Badge>();
    private static final Map<UUID, Badge> playerBadges = new HashMap<UUID, Badge>();

    public static void clear() {
        map.clear();
        ClientBadges.clearPlayerBadges();
    }

    public static void clearPlayerBadges() {
        playerBadges.clear();
    }

    public static Badge getClientBadge(UUID playerID) {
        Badge b = playerBadges.get(playerID);
        if (b == null) {
            b = Badge.emptyBadge;
            playerBadges.put(playerID, b);
            new MessageRequestBadge(playerID).sendToServer();
        }
        return b;
    }

    public static void addBadge(Badge b) {
        if (b != null && !b.equals((Object)Badge.emptyBadge)) {
            map.put(b.getID(), b);
        }
    }

    public static void setClientBadge(UUID playerID, String badge) {
        if (playerID == null || badge == null || badge.isEmpty() || badge.equalsIgnoreCase(Badge.emptyBadge.getID())) {
            return;
        }
        Badge b = map.get(badge);
        if (b != null) {
            playerBadges.put(playerID, b);
        } else {
            playerBadges.put(playerID, Badge.emptyBadge);
        }
    }
}

