/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.badges;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ftb.lib.FTBLib;
import ftb.utils.badges.Badge;
import ftb.utils.mod.FTBU;
import ftb.utils.net.MessageUpdateBadges;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldServer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import latmod.lib.LMFileUtils;
import latmod.lib.LMJsonUtils;
import latmod.lib.LMUtils;
import latmod.lib.net.LMURLConnection;
import latmod.lib.net.RequestMethod;
import latmod.lib.util.Phase;
import net.minecraft.entity.player.EntityPlayerMP;

public class ServerBadges {
    private static final Map<String, Badge> map = new HashMap<String, Badge>();
    private static final Map<UUID, Badge> uuid = new HashMap<UUID, Badge>();
    public static ThreadReloadBadges thread;

    public static void reload() {
        thread = new ThreadReloadBadges();
        thread.setDaemon(true);
        thread.start();
    }

    public static void sendToPlayer(EntityPlayerMP ep) {
        new MessageUpdateBadges(map.values()).sendTo(ep);
    }

    private static void loadBadges(JsonElement e, Phase p) {
        block5: {
            JsonObject o;
            block4: {
                if (e == null || !e.isJsonObject()) {
                    return;
                }
                o = e.getAsJsonObject();
                if (p != Phase.PRE) break block4;
                if (!o.has("badges")) break block5;
                JsonObject o1 = o.get("badges").getAsJsonObject();
                for (Map.Entry entry : o1.entrySet()) {
                    Badge b = new Badge((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    map.put(b.getID(), b);
                }
                break block5;
            }
            if (o.has("players")) {
                JsonObject o1 = o.get("players").getAsJsonObject();
                for (Map.Entry entry : o1.entrySet()) {
                    Badge b;
                    UUID id = LMUtils.fromString((String)((String)entry.getKey()));
                    if (id == null || (b = map.get(((JsonElement)entry.getValue()).getAsString())) == null) continue;
                    uuid.put(id, b);
                }
            }
        }
    }

    public static Badge getServerBadge(UUID id) {
        if (id == null) {
            return Badge.emptyBadge;
        }
        Badge b = uuid.get(id);
        if (b != null) {
            return b;
        }
        uuid.put(id, Badge.emptyBadge);
        try {
            LMPlayerServer p = LMWorldServer.inst.getPlayer(id);
            String rank = p.getRank().config.badge.get();
            if (!rank.isEmpty() && (b = map.get(rank)) != null) {
                return b;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Badge.emptyBadge;
    }

    public static class ThreadReloadBadges
    extends Thread {
        public boolean isDone = false;

        @Override
        public void run() {
            this.isDone = false;
            long msStarted = LMUtils.millis();
            map.clear();
            uuid.clear();
            JsonElement global = null;
            JsonElement local = null;
            try {
                LMURLConnection connection = new LMURLConnection(RequestMethod.SIMPLE_GET, "http://pastebin.com/raw/Mu8McdDR");
                global = connection.connect().asJson();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                File file = LMFileUtils.newFile((File)new File(FTBLib.folderLocal, "badges.json"));
                local = LMJsonUtils.fromJson((File)file);
                if (local.isJsonNull()) {
                    local = new JsonObject();
                    ((JsonObject)local).add("badges", (JsonElement)new JsonObject());
                    ((JsonObject)local).add("players", (JsonElement)new JsonObject());
                    LMJsonUtils.toJson((File)file, (JsonElement)local);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ServerBadges.loadBadges(global, Phase.PRE);
            ServerBadges.loadBadges(local, Phase.PRE);
            ServerBadges.loadBadges(global, Phase.POST);
            ServerBadges.loadBadges(local, Phase.POST);
            FTBU.logger.info("Loaded " + map.size() + " badges in " + (LMUtils.millis() - msStarted) + " ms!");
            this.isDone = true;
        }
    }
}

