/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.handlers;

import com.google.common.collect.MapMaker;
import ftb.lib.EventBusHelper;
import ftb.lib.FTBLib;
import ftb.lib.LMDimUtils;
import ftb.utils.mod.FTBU;
import ftb.utils.mod.config.FTBUConfigChunkloading;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldServer;
import ftb.utils.world.claims.ClaimedChunk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class FTBUChunkEventHandler
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback {
    public static final FTBUChunkEventHandler instance = new FTBUChunkEventHandler();
    private final Map<World, Map<Integer, ForgeChunkManager.Ticket>> table = new MapMaker().weakKeys().makeMap();
    private static final String PLAYER_ID_TAG = "PID";

    public void init() {
        if (!ForgeChunkManager.getConfig().hasCategory("FTBU")) {
            ForgeChunkManager.getConfig().get("FTBU", "maximumTicketCount", 2000).setMinValue(0);
            ForgeChunkManager.getConfig().get("FTBU", "maximumChunksPerTicket", 30000).setMinValue(0);
            ForgeChunkManager.getConfig().save();
        }
        EventBusHelper.register((Object)this);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FTBU.inst, (ForgeChunkManager.LoadingCallback)this);
    }

    private ForgeChunkManager.Ticket request(World w, LMPlayerServer player) {
        ForgeChunkManager.Ticket t;
        if (w == null || player == null) {
            return null;
        }
        Integer playerID = player.getPlayerID();
        Map<Integer, ForgeChunkManager.Ticket> map = this.table.get(w);
        ForgeChunkManager.Ticket ticket = t = map == null ? null : map.get(playerID);
        if (t == null) {
            t = ForgeChunkManager.requestTicket((Object)FTBU.inst, (World)w, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (t == null) {
                return null;
            }
            t.getModData().func_74768_a(PLAYER_ID_TAG, playerID.intValue());
            if (map == null) {
                map = new HashMap<Integer, ForgeChunkManager.Ticket>();
                this.table.put(w, map);
            }
            map.put(playerID, t);
        }
        return t;
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        this.table.remove(world);
        ArrayList<ForgeChunkManager.Ticket> tickets1 = new ArrayList<ForgeChunkManager.Ticket>();
        if (tickets.isEmpty() || !FTBUConfigChunkloading.enabled.get()) {
            return tickets1;
        }
        HashMap<Integer, ForgeChunkManager.Ticket> map = new HashMap<Integer, ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket t : tickets) {
            int playerID = t.getModData().func_74762_e(PLAYER_ID_TAG);
            if (playerID <= 0) continue;
            map.put(playerID, t);
            tickets1.add(t);
        }
        this.table.put(world, map);
        return tickets1;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket t : tickets) {
            List<ClaimedChunk> chunks;
            int playerID = t.getModData().func_74762_e(PLAYER_ID_TAG);
            if (playerID <= 0 || (chunks = LMWorldServer.inst.claimedChunks.getChunks(LMWorldServer.inst.getPlayer(playerID), world.field_73011_w.field_76574_g)) == null || chunks.isEmpty()) continue;
            for (ClaimedChunk c : chunks) {
                if (!c.isChunkloaded) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)t, (ChunkCoordIntPair)c.getPos());
            }
        }
        this.markDirty(world);
    }

    public void markDirty(World w) {
        if (LMWorldServer.inst == null || FTBLib.getServerWorld() == null) {
            return;
        }
        if (w != null) {
            this.markDirty0(w);
        }
        if (!this.table.isEmpty()) {
            World[] worlds;
            for (World w1 : worlds = this.table.keySet().toArray(new World[this.table.size()])) {
                this.markDirty0(w1);
            }
        }
    }

    private void markDirty0(World w) {
        double max;
        Map<Long, ClaimedChunk> chunksMap = LMWorldServer.inst.claimedChunks.chunks.get(w.field_73011_w.field_76574_g);
        double d = max = FTBUConfigChunkloading.enabled.get() ? FTBUConfigChunkloading.max_player_offline_hours.get() : -2.0;
        if (chunksMap != null) {
            for (ClaimedChunk c : chunksMap.values()) {
                ForgeChunkManager.Ticket ticket;
                boolean isLoaded = c.isChunkloaded;
                if (c.isChunkloaded) {
                    LMPlayerServer p = c.getOwnerS();
                    if (p == null) {
                        isLoaded = false;
                    } else if (max == -2.0) {
                        isLoaded = false;
                    } else if (max == -1.0) {
                        isLoaded = true;
                    } else if (max == 0.0) {
                        isLoaded = p.isOnline();
                    } else if (max > 0.0 && !p.isOnline() && max > 0.0 && p.stats.getLastSeenDeltaInHours(p) > max) {
                        isLoaded = false;
                    }
                }
                if (c.isForced == isLoaded || (ticket = this.request(LMDimUtils.getWorld((int)c.dim), c.getOwnerS())) == null) continue;
                if (isLoaded) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)c.getPos());
                } else {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)c.getPos());
                }
                c.isForced = isLoaded;
            }
        }
    }

    private void releaseTicket(ForgeChunkManager.Ticket t) {
        Map<Integer, ForgeChunkManager.Ticket> map;
        if (t.getModData().func_74764_b(PLAYER_ID_TAG) && (map = this.table.get(t.world)) != null) {
            map.remove(t.getModData().func_74762_e(PLAYER_ID_TAG));
            if (map.isEmpty()) {
                this.table.remove(t.world);
            }
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)t);
    }

    public void clear() {
        this.table.clear();
    }
}

