/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import ftb.lib.BroadcastSender;
import ftb.utils.mod.FTBU;
import ftb.utils.mod.config.FTBUConfigBackups;
import ftb.utils.world.Backups;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import latmod.lib.LMFileUtils;
import latmod.lib.LMStringUtils;
import latmod.lib.LMUtils;
import latmod.lib.MathHelperLM;
import latmod.lib.Time;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ThreadBackup
extends Thread {
    private File src0;
    public boolean isDone = false;

    public ThreadBackup(File w) {
        this.src0 = w;
        this.setPriority(7);
    }

    @Override
    public void run() {
        this.isDone = false;
        ThreadBackup.doBackup(this.src0);
        this.isDone = true;
    }

    public static void doBackup(File src) {
        block11: {
            Time time = Time.now();
            File dstFile = null;
            try {
                StringBuilder out = new StringBuilder();
                ThreadBackup.appendNum(out, time.year, '-');
                ThreadBackup.appendNum(out, time.month, '-');
                ThreadBackup.appendNum(out, time.day, '-');
                ThreadBackup.appendNum(out, time.hours, '-');
                ThreadBackup.appendNum(out, time.minutes, '-');
                ThreadBackup.appendNum(out, time.seconds, File.separatorChar);
                List files = LMFileUtils.listAll((File)src);
                int allFiles = files.size();
                Backups.logger.info("Backing up " + files.size() + " files...");
                if (FTBUConfigBackups.compression_level.get() > 0) {
                    out.append("backup.zip");
                    dstFile = LMFileUtils.newFile((File)new File(Backups.backupsFolder, out.toString()));
                    long start = LMUtils.millis();
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
                    zos.setLevel(FTBUConfigBackups.compression_level.get());
                    long logMillis = LMUtils.millis() + 5000L;
                    byte[] buffer = new byte[4096];
                    Backups.logger.info("Compressing " + allFiles + " files!");
                    for (int i = 0; i < allFiles; ++i) {
                        int len;
                        File file = (File)files.get(i);
                        String filePath = file.getAbsolutePath();
                        ZipEntry ze = new ZipEntry(src.getName() + File.separator + filePath.substring(src.getAbsolutePath().length() + 1, filePath.length()));
                        long millis = LMUtils.millis();
                        if (i == 0 || millis > logMillis || i == allFiles - 1) {
                            logMillis = millis + 5000L;
                            StringBuilder log = new StringBuilder();
                            log.append('[');
                            log.append(i);
                            log.append(" | ");
                            log.append(MathHelperLM.toSmallDouble((double)((double)i / (double)allFiles * 100.0)));
                            log.append("%]: ");
                            log.append(ze.getName());
                            Backups.logger.info(log.toString());
                        }
                        zos.putNextEntry(ze);
                        FileInputStream fis = new FileInputStream(file);
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        fis.close();
                    }
                    zos.close();
                    Backups.logger.info("Done compressing in " + ThreadBackup.getDoneTime(start) + " seconds (" + LMFileUtils.getSizeS((File)dstFile) + ")!");
                } else {
                    out.append(src.getName());
                    dstFile = new File(Backups.backupsFolder, out.toString());
                    dstFile.mkdirs();
                    String dstPath = dstFile.getAbsolutePath() + File.separator;
                    String srcPath = src.getAbsolutePath();
                    long logMillis = LMUtils.millis() + 2000L;
                    for (int i = 0; i < allFiles; ++i) {
                        File file = (File)files.get(i);
                        long millis = LMUtils.millis();
                        if (i == 0 || millis > logMillis || i == allFiles - 1) {
                            logMillis = millis + 2000L;
                            StringBuilder log = new StringBuilder();
                            log.append('[');
                            log.append(i);
                            log.append(" | ");
                            log.append(MathHelperLM.toSmallDouble((double)((double)i / (double)allFiles * 100.0)));
                            log.append("%]: ");
                            log.append(file.getName());
                            Backups.logger.info(log.toString());
                        }
                        File dst1 = new File(dstPath + file.getAbsolutePath().replace(srcPath, ""));
                        LMUtils.throwException((Exception)LMFileUtils.copyFile((File)file, (File)dst1));
                    }
                }
                Backups.logger.info("Created " + dstFile.getAbsolutePath() + " from " + src.getAbsolutePath());
                Backups.clearOldBackups();
                if (FTBUConfigBackups.display_file_size.get()) {
                    String sizeB = LMFileUtils.getSizeS((File)dstFile);
                    String sizeT = LMFileUtils.getSizeS((File)Backups.backupsFolder);
                    IChatComponent c = FTBU.mod.chatComponent("cmd.backup_end_2", new Object[]{ThreadBackup.getDoneTime(time.millis), sizeB.equals(sizeT) ? sizeB : sizeB + " | " + sizeT});
                    c.func_150256_b().func_150238_a(EnumChatFormatting.LIGHT_PURPLE);
                    BroadcastSender.inst.func_145747_a(c);
                } else {
                    IChatComponent c = FTBU.mod.chatComponent("cmd.backup_end_1", new Object[]{ThreadBackup.getDoneTime(time.millis)});
                    c.func_150256_b().func_150238_a(EnumChatFormatting.LIGHT_PURPLE);
                    BroadcastSender.inst.func_145747_a(c);
                }
            }
            catch (Exception e) {
                IChatComponent c = FTBU.mod.chatComponent("cmd.backup_fail", new Object[]{LMUtils.classpath(e.getClass())});
                c.func_150256_b().func_150238_a(EnumChatFormatting.DARK_RED);
                BroadcastSender.inst.func_145747_a(c);
                e.printStackTrace();
                if (dstFile == null) break block11;
                LMFileUtils.delete(dstFile);
            }
        }
    }

    private static String getDoneTime(long l) {
        return LMStringUtils.getTimeString((long)(LMUtils.millis() - l));
    }

    private static void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }
}

