/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ShaderCaseDrill
extends ShaderCase {
    public String additionalTexture = null;
    public IIcon i_drillBase;
    public IIcon i_drillOverlay;
    public IIcon i_drillUncoloured;
    public IIcon i_drillAdditional;

    public ShaderCaseDrill(String overlayType, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, String additionalTexture) {
        super(overlayType, colourGrip, colourPrimary, colourSecondary, "immersiveengineering:shaders/drill_diesel_");
        this.additionalTexture = additionalTexture;
    }

    @Override
    public String getShaderType() {
        return "drill";
    }

    @Override
    public int getPasses(ItemStack shader, ItemStack item, String modelPart) {
        if (modelPart.equals("upgrade_speed") || modelPart.equals("upgrade_waterproof")) {
            return 2;
        }
        int i = this.additionalTexture != null ? 1 : 0;
        return 3 + i;
    }

    @Override
    public IIcon getReplacementIcon(ItemStack shader, ItemStack item, String modelPart, int pass) {
        int maxPass = this.getPasses(shader, item, modelPart);
        if (pass == maxPass - 1) {
            return this.i_drillUncoloured;
        }
        if (pass == maxPass - 2 && this.i_drillAdditional != null) {
            return this.i_drillAdditional;
        }
        return pass == 0 ? this.i_drillBase : this.i_drillOverlay;
    }

    @Override
    public int[] getRGBAColourModifier(ItemStack shader, ItemStack item, String modelPart, int pass) {
        int maxPass = this.getPasses(shader, item, modelPart);
        if (pass == maxPass - 1) {
            return defaultWhite;
        }
        if (pass == maxPass - 2 && this.i_drillAdditional != null) {
            return this.colourOverlay;
        }
        int i = this.getTextureType(modelPart, pass);
        if (i == 0) {
            return this.colourUnderlying;
        }
        if (i == 1) {
            return this.colourPrimary;
        }
        if (i == 2) {
            return this.colourSecondary;
        }
        return defaultWhite;
    }

    public int getTextureType(String modelPart, int pass) {
        if (modelPart.equals("drill_grip")) {
            return pass == 0 ? 0 : pass + 1;
        }
        return pass + 1;
    }

    @Override
    public void stichTextures(IIconRegister ir, int sheetID) {
        if (sheetID == 1) {
            this.i_drillBase = ir.func_94245_a("immersiveengineering:shaders/drill_diesel_0");
            this.i_drillOverlay = ir.func_94245_a(this.baseTexturePath + "1_" + this.overlayType);
            this.i_drillUncoloured = ir.func_94245_a("immersiveengineering:shaders/drill_diesel_uncoloured");
            if (this.additionalTexture != null) {
                this.i_drillAdditional = ir.func_94245_a(this.baseTexturePath + this.additionalTexture);
            }
        }
    }

    @Override
    public void modifyRender(ItemStack shader, ItemStack item, String modelPart, int pass, boolean pre, boolean inventory) {
    }
}

