/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;

public class TileEntityEnergyMeter
extends TileEntityImmersiveConnectable {
    public int facing = 3;
    public int lastEnergyPassed = 0;
    public ArrayList<Integer> lastPackets = new ArrayList(25);
    public boolean dummy = false;
    private int maxTransfer = -1;
    public int compVal = -1;

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    protected boolean canTakeHV() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_145845_h() {
        if (this.dummy || this.field_145850_b.field_72995_K) {
            return;
        }
        ArrayList<Integer> arrayList = this.lastPackets;
        synchronized (arrayList) {
            this.lastPackets.add(this.lastEnergyPassed);
            if (this.lastPackets.size() > 20) {
                this.lastPackets.remove(0);
            }
            if ((this.field_145850_b.func_82737_E() & 0x1FL) == (long)((this.field_145851_c ^ this.field_145849_e) & 0x1F) || this.compVal < 0) {
                this.updateComparatorValues();
            }
        }
        this.lastEnergyPassed = 0;
    }

    private void updateComparatorValues() {
        if (this.maxTransfer < 0) {
            Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC(this));
            if (conns == null) {
                return;
            }
            this.maxTransfer = 0;
            for (ImmersiveNetHandler.Connection c : conns) {
                this.maxTransfer += c.cableType.getTransferRate();
            }
        }
        float percentage = (float)(this.getAveragePower() * 2) / (float)this.maxTransfer;
        int oldComp = this.compVal;
        this.compVal = (int)Math.min(Math.ceil(15.0f * percentage), 15.0);
        if (oldComp != this.compVal) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            if (!(te instanceof TileEntityEnergyMeter)) {
                return;
            }
            ((TileEntityEnergyMeter)te).compVal = this.compVal;
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        }
    }

    @Override
    public boolean canConnect() {
        return !this.dummy;
    }

    @Override
    public void onEnergyPassthrough(int amount) {
        this.lastEnergyPassed += amount;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (this.dummy) {
            TileEntity above = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (above instanceof TileEntityEnergyMeter) {
                return ((TileEntityEnergyMeter)above).canConnectCable(cableType, target);
            }
            return false;
        }
        return super.canConnectCable(cableType, target);
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
        if (this.dummy) {
            TileEntity above = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (above instanceof TileEntityEnergyMeter) {
                ((TileEntityEnergyMeter)above).connectCable(cableType, target);
            }
        } else {
            super.connectCable(cableType, target);
            if (!this.field_145850_b.field_72995_K) {
                this.maxTransfer += cableType.getTransferRate();
            }
        }
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        super.removeCable(connection);
        if (!this.field_145850_b.field_72995_K) {
            this.maxTransfer = connection == null ? 0 : (this.maxTransfer -= connection.cableType.getTransferRate());
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74757_a("dummy", this.dummy);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.dummy = nbt.func_74767_n("dummy");
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        int xDif = ((TileEntity)link).field_145851_c - this.field_145851_c;
        int zDif = ((TileEntity)link).field_145849_e - this.field_145849_e;
        if (this.facing > 3) {
            return Vec3.func_72443_a((double)0.5, (double)0.4375, (double)(zDif > 0 ? 0.8125 : 0.1875));
        }
        return Vec3.func_72443_a((double)(xDif > 0 ? 0.8125 : 0.1875), (double)0.4375, (double)0.5);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.field_71574_a - this.field_145851_c : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.field_71574_a - this.field_145851_c : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.field_71573_c - this.field_145849_e : (zDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.field_71573_c - this.field_145849_e : 0));
        if (this.facing > 3) {
            return Vec3.func_72443_a((double)0.5, (double)0.4375, (double)(zDif > 0 ? 0.8125 : 0.1875));
        }
        return Vec3.func_72443_a((double)(xDif > 0 ? 0.8125 : 0.1875), (double)0.4375, (double)0.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAveragePower() {
        TileEntityEnergyMeter te = this;
        if (te.dummy) {
            TileEntity tmp = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (!(tmp instanceof TileEntityEnergyMeter)) {
                return -1;
            }
            te = (TileEntityEnergyMeter)tmp;
        }
        if (te.lastPackets.size() == 0) {
            return 0;
        }
        int sum = 0;
        ArrayList<Integer> arrayList = te.lastPackets;
        synchronized (arrayList) {
            for (int transfer : te.lastPackets) {
                sum += transfer;
            }
        }
        return sum / te.lastPackets.size();
    }
}

