/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockFakeLight;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityFloodlight
extends TileEntityImmersiveConnectable {
    public int energyStorage = 0;
    public boolean active = false;
    public int facing = -1;
    public int side = 1;
    public float rotY = 0.0f;
    public float rotX = 0.0f;
    public List<ChunkCoordinates> fakeLights = new ArrayList<ChunkCoordinates>();
    public List<ChunkCoordinates> lightsToBePlaced = new ArrayList<ChunkCoordinates>();
    public List<ChunkCoordinates> lightsToBeRemoved = new ArrayList<ChunkCoordinates>();
    final int timeBetweenSwitches = 20;
    int switchCooldown = 0;
    public int computerTurnCooldown = 0;
    public boolean computerControlled;
    public boolean computerOn;
    private boolean shouldUpdate = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean b = this.active;
        if (this.shouldUpdate) {
            this.updateFakeLights(true, this.active);
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.shouldUpdate = false;
        }
        boolean enabled = this.computerControlled ? this.computerOn : !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.energyStorage >= (!this.active ? 50 : 5) && enabled && this.switchCooldown <= 0) {
            this.energyStorage -= 5;
            if (!this.active) {
                this.active = true;
            }
        } else if (this.active) {
            this.active = false;
            this.switchCooldown = 20;
        }
        --this.switchCooldown;
        --this.computerTurnCooldown;
        if (this.computerTurnCooldown == 0) {
            TileEntityFloodlight tileEntityFloodlight = this;
            synchronized (tileEntityFloodlight) {
                this.notifyAll();
            }
        }
        if (this.active != b || this.field_145850_b.func_82737_E() % 512L == (long)((this.field_145851_c ^ this.field_145849_e) & 0x1FF)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.updateFakeLights(true, this.active);
        }
        if (!this.active) {
            if (!this.lightsToBePlaced.isEmpty()) {
                this.lightsToBePlaced.clear();
            }
        } else if (!this.lightsToBePlaced.isEmpty() || !this.lightsToBeRemoved.isEmpty() && this.field_145850_b.func_82737_E() % 8L == (long)((this.field_145851_c ^ this.field_145849_e) & 7)) {
            ChunkCoordinates cc;
            Iterator<ChunkCoordinates> it = this.lightsToBePlaced.iterator();
            int timeout = 0;
            while (it.hasNext() && timeout++ < 16) {
                cc = it.next();
                this.field_145850_b.func_147465_d(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, IEContent.blockFakeLight, 0, 2);
                TileEntity te = this.field_145850_b.func_147438_o(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
                if (te instanceof BlockFakeLight.TileEntityFakeLight) {
                    ((BlockFakeLight.TileEntityFakeLight)te).floodlightCoords = new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
                }
                this.fakeLights.add(cc);
                it.remove();
            }
            it = this.lightsToBeRemoved.iterator();
            timeout = 0;
            while (it.hasNext() && timeout++ < 16) {
                cc = it.next();
                if (this.field_145850_b.func_147438_o(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c) instanceof BlockFakeLight.TileEntityFakeLight) {
                    this.field_145850_b.func_147468_f(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
                }
                it.remove();
            }
        }
    }

    public void updateFakeLights(boolean deleteOld, boolean genNew) {
        Iterator<ChunkCoordinates> it = this.fakeLights.iterator();
        ArrayList<ChunkCoordinates> tempRemove = new ArrayList<ChunkCoordinates>();
        while (it.hasNext()) {
            ChunkCoordinates cc = it.next();
            TileEntity te = this.field_145850_b.func_147438_o(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
            if (te instanceof BlockFakeLight.TileEntityFakeLight) {
                if (!deleteOld) continue;
                tempRemove.add(cc);
                continue;
            }
            it.remove();
        }
        if (genNew) {
            float angle = this.facing == 3 ? 180 : (this.facing == 4 ? 90 : (this.facing == 5 ? -90 : 0));
            double angleX = Math.toRadians(this.rotX);
            double angleY = Math.toRadians(angle + this.rotY);
            Vec3[] rays = new Vec3[]{Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0)};
            Matrix4 mat = new Matrix4();
            if (this.side == 0) {
                mat.rotate(Math.PI, this.facing < 4 ? 0.0 : 1.0, 0.0, this.facing < 4 ? 1.0 : 0.0);
            } else if (this.side != 1) {
                mat.rotate(1.5707963267948966, this.side == 2 ? -1.0 : (this.side == 3 ? 1.0 : 0.0), 0.0, this.side == 5 ? -1.0 : (this.side == 4 ? 1.0 : 0.0));
            }
            mat.rotate(angleY, 0.0, 1.0, 0.0);
            mat.rotate(-angleX, 1.0, 0.0, 0.0);
            mat.apply(rays[0]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.apply(rays[1]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            mat.apply(rays[5]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            mat.apply(rays[6]);
            mat.rotate(-0.19634954084936207, 0.0, 1.0, 0.0);
            mat.apply(rays[2]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            mat.apply(rays[3]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            mat.apply(rays[7]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            mat.apply(rays[8]);
            mat.rotate(-0.19634954084936207, 1.0, 0.0, 0.0);
            mat.apply(rays[4]);
            mat.rotate(0.39269908169872414, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 1.0, 0.0, 0.0);
            mat.rotate(0.19634954084936207, 0.0, 1.0, 0.0);
            mat.apply(rays[9]);
            mat.rotate(-0.39269908169872414, 0.0, 1.0, 0.0);
            mat.apply(rays[10]);
            mat.rotate(-0.39269908169872414, 1.0, 0.0, 0.0);
            mat.apply(rays[11]);
            mat.rotate(0.39269908169872414, 0.0, 1.0, 0.0);
            mat.apply(rays[12]);
            for (int ray = 0; ray < rays.length; ++ray) {
                int offset = ray == 0 ? 0 : (ray < 4 ? 3 : 1);
                this.placeLightAlongVector(rays[ray], offset, tempRemove);
            }
        }
        this.lightsToBeRemoved.addAll(tempRemove);
    }

    public void placeLightAlongVector(Vec3 vec, int offset, ArrayList<ChunkCoordinates> checklist) {
        Vec3 light = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.75), (double)((double)this.field_145849_e + 0.5));
        int range = 32;
        HashSet<ChunkCoordinates> ignore = new HashSet<ChunkCoordinates>();
        ignore.add(new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        ChunkCoordinates hit = Utils.rayTraceForFirst(Utils.addVectors(vec, light), light.func_72441_c(vec.field_72450_a * (double)range, vec.field_72448_b * (double)range, vec.field_72449_c * (double)range), this.field_145850_b, ignore);
        double maxDistance = hit != null ? Vec3.func_72443_a((double)((double)hit.field_71574_a + 0.5), (double)((double)hit.field_71572_b + 0.75), (double)((double)hit.field_71573_c + 0.5)).func_72436_e(light) : (double)(range * range);
        for (int i = 1 + offset; i <= range; ++i) {
            int xx = this.field_145851_c + (int)Math.round(vec.field_72450_a * (double)i);
            int yy = this.field_145848_d + (int)Math.round(vec.field_72448_b * (double)i);
            int zz = this.field_145849_e + (int)Math.round(vec.field_72449_c * (double)i);
            double dist = vec.field_72450_a * (double)i * vec.field_72450_a * (double)i + vec.field_72448_b * (double)i * vec.field_72448_b * (double)i + vec.field_72449_c * (double)i * vec.field_72449_c * (double)i;
            if (dist > maxDistance) break;
            if (yy > 255 || yy < 0 || xx == this.field_145851_c && yy == this.field_145848_d && zz == this.field_145849_e || !this.field_145850_b.func_147437_c(xx, yy, zz)) continue;
            ChunkCoordinates cc = new ChunkCoordinates(xx, yy, zz);
            if (!checklist.remove(cc)) {
                this.lightsToBePlaced.add(cc);
            }
            i += 2;
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.active = nbt.func_74767_n("active");
        this.energyStorage = nbt.func_74762_e("energy");
        this.facing = nbt.func_74762_e("facing");
        this.side = nbt.func_74762_e("side");
        this.rotY = nbt.func_74760_g("rotY");
        this.rotX = nbt.func_74760_g("rotX");
        int lightAmount = nbt.func_74762_e("lightAmount");
        this.fakeLights.clear();
        for (int i = 0; i < lightAmount; ++i) {
            int[] icc = nbt.func_74759_k("fakeLight_" + i);
            this.fakeLights.add(new ChunkCoordinates(icc[0], icc[1], icc[2]));
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("energyStorage", this.energyStorage);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74768_a("side", this.side);
        nbt.func_74776_a("rotY", this.rotY);
        nbt.func_74776_a("rotX", this.rotX);
        nbt.func_74768_a("lightAmount", this.fakeLights.size());
        for (int i = 0; i < this.fakeLights.size(); ++i) {
            ChunkCoordinates cc = this.fakeLights.get(i);
            nbt.func_74783_a("fakeLight_" + i, new int[]{cc.field_71574_a, cc.field_71572_b, cc.field_71573_c});
        }
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return true;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < 80) {
            int accepted = Math.min(80 - this.energyStorage, amount);
            if (!simulate) {
                this.energyStorage += accepted;
            }
            return accepted;
        }
        return 0;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        double z;
        double y;
        double x;
        int xDif = ((TileEntity)link).field_145851_c - this.field_145851_c;
        int yDif = ((TileEntity)link).field_145848_d - this.field_145848_d;
        int zDif = ((TileEntity)link).field_145849_e - this.field_145849_e;
        switch (this.side) {
            case 0: 
            case 1: {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double d = y = this.side == 0 ? 0.9375 : 0.0625;
                z = Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                break;
            }
            case 2: 
            case 3: {
                double d = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                z = this.side == 2 ? 0.9375 : 0.0625;
                break;
            }
            default: {
                double d = x = this.side == 4 ? 0.9375 : 0.0625;
                double d2 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                z = Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        }
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        double z;
        double y;
        double x;
        int yDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.field_71574_a - this.field_145851_c : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.field_71574_a - this.field_145851_c : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.field_71572_b - this.field_145848_d : (yDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.field_71572_b - this.field_145848_d : 0));
        int zDif = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.field_71573_c - this.field_145849_e : (con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.field_71573_c - this.field_145849_e : 0));
        switch (this.side) {
            case 0: 
            case 1: {
                x = Math.abs(xDif) >= Math.abs(zDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                double d = y = this.side == 0 ? 0.9375 : 0.0625;
                z = Math.abs(zDif) > Math.abs(xDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                break;
            }
            case 2: 
            case 3: {
                double d = Math.abs(xDif) >= Math.abs(yDif) ? (xDif >= 0 ? 0.9375 : 0.0625) : (x = 0.5);
                y = Math.abs(yDif) > Math.abs(xDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : 0.5;
                z = this.side == 2 ? 0.9375 : 0.0625;
                break;
            }
            default: {
                double d = x = this.side == 4 ? 0.9375 : 0.0625;
                double d2 = Math.abs(yDif) >= Math.abs(zDif) ? (yDif >= 0 ? 0.9375 : 0.0625) : (y = 0.5);
                z = Math.abs(zDif) > Math.abs(yDif) ? (zDif >= 0 ? 0.9375 : 0.0625) : 0.5;
            }
        }
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public void turnY(boolean down, boolean computer) {
        this.rotY = (float)((double)this.rotY + (down ? -11.25 : 11.25));
        this.rotY %= 360.0f;
        if (computer) {
            this.computerTurnCooldown = 20;
        }
        this.shouldUpdate = true;
    }

    public void turnX(boolean up, boolean computer) {
        float newX = (this.rotX + (up ? 11.25f : -11.25f)) % 360.0f;
        if ((double)newX >= -11.25 && (double)newX <= 191.25) {
            this.rotX = newX;
        }
        if (computer) {
            this.computerTurnCooldown = 20;
        }
        this.shouldUpdate = true;
    }

    public boolean canComputerTurn() {
        return this.computerTurnCooldown <= 0 || !this.active;
    }
}

