/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ExternalHeaterHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.damagesource.DamageSourceThaumcraft;

public class ThaumcraftHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        ChemthrowerHandler.registerEffect("fluiddeath", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Damage(DamageSourceThaumcraft.dissolve, 4.0f));
        for (Potion potion : Potion.field_76425_a) {
            if (potion != null && potion.func_76393_a().equals("potion.warpward")) {
                ChemthrowerHandler.registerEffect("fluidpure", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, potion, 100, 0));
                continue;
            }
            if (potion == null || !potion.func_76393_a().equals("potion.visexhaust")) continue;
            ChemthrowerHandler.registerEffect("fluxgoo", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, potion, 100, 0));
        }
        try {
            Class<?> c_TileAlchemyFurnace = Class.forName("thaumcraft.common.tiles.TileAlchemyFurnace");
            if (c_TileAlchemyFurnace != null) {
                ExternalHeaterHandler.registerHeatableAdapter(c_TileAlchemyFurnace, new AlchemyFurnaceAdapter());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void postInit() {
    }

    public static class AlchemyFurnaceAdapter
    extends ExternalHeaterHandler.HeatableAdapter {
        Method m_canSmelt;
        Field f_furnaceBurnTime;

        public AlchemyFurnaceAdapter() {
            try {
                Class<?> c_TileEvaporator = Class.forName("thaumcraft.common.tiles.TileAlchemyFurnace");
                this.m_canSmelt = c_TileEvaporator.getDeclaredMethod("canSmelt", new Class[0]);
                this.m_canSmelt.setAccessible(true);
                this.f_furnaceBurnTime = c_TileEvaporator.getDeclaredField("furnaceBurnTime");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean canSmelt(TileEntity tileEntity) throws Exception {
            if (this.m_canSmelt != null) {
                return (Boolean)this.m_canSmelt.invoke((Object)tileEntity, new Object[0]);
            }
            return false;
        }

        public int doHeatTick(TileEntity tileEntity, int energyAvailable, boolean redstone) {
            int energyConsumed = 0;
            try {
                boolean canSmelt;
                int time = this.f_furnaceBurnTime.getInt(tileEntity);
                boolean bl = canSmelt = redstone ? true : this.canSmelt(tileEntity);
                if (canSmelt) {
                    int heatEnergyRatio;
                    int heatAttempt;
                    int energyToUse;
                    int heat;
                    boolean burning;
                    boolean bl2 = burning = time == 0;
                    if (time < 200 && (heat = (energyToUse = Math.min(energyAvailable, (heatAttempt = 4) * (heatEnergyRatio = Math.max(1, ExternalHeaterHandler.defaultFurnaceEnergyCost)))) / heatEnergyRatio) > 0) {
                        time += heat;
                        energyConsumed += heat * heatEnergyRatio;
                        if (!burning) {
                            tileEntity.func_145831_w().func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                        }
                    }
                    this.f_furnaceBurnTime.setInt(tileEntity, time);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return energyConsumed;
        }
    }
}

