/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFermenter;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import net.minecraft.world.World;

public class PeripheralFermenter
extends IEPeripheral {
    public static final String[] cmds = new String[]{"getRecipe", "getInputStack", "getOutputStack", "getFluid", "getEmptyCannisters", "getFilledCannisters", "getEnergyStored", "getMaxEnergyStored", "getProgress"};

    public PeripheralFermenter(World w, int _x, int _y, int _z) {
        super(w, _x, _y, _z);
    }

    public String getType() {
        return "IE:fermenter";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityFermenter te = (TileEntityFermenter)this.getTileEntity(TileEntityFermenter.class);
        if (te == null) {
            throw new LuaException("The fermenter was removed");
        }
        switch (method) {
            case 0: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot < 1 || slot > 9) {
                    throw new LuaException("Input slots are numbers 1-9");
                }
                DieselHandler.FermenterRecipe recipe = DieselHandler.findFermenterRecipe(te.func_70301_a(slot - 1));
                if (recipe != null) {
                    return new Object[]{Utils.saveStack(te.func_70301_a(slot - 1)), Utils.saveStack(recipe.output), Utils.saveFluidStack(recipe.fluid), recipe.time};
                }
                return new Object[]{"No recipe found"};
            }
            case 1: {
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot < 1 || slot > 9) {
                    throw new LuaException("Input slots are numbers 1-9");
                }
                return new Object[]{Utils.saveStack(te.func_70301_a(slot - 1))};
            }
            case 2: {
                return new Object[]{Utils.saveStack(te.func_70301_a(11))};
            }
            case 3: {
                return new Object[]{Utils.saveFluidTank(te.tank)};
            }
            case 4: {
                return new Object[]{Utils.saveStack(te.func_70301_a(9))};
            }
            case 5: {
                return new Object[]{Utils.saveStack(te.func_70301_a(10))};
            }
            case 6: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
            case 7: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 8: {
                return new Object[]{te.tick};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }
}

