/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.module.tabula.common.project.components;

import java.util.ArrayList;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.RandomStringUtils;
import us.ichun.module.tabula.common.math.PolynomialFunctionLagrangeForm;
import us.ichun.module.tabula.common.project.components.CubeInfo;

public class AnimationComponent
implements Comparable {
    public double[] posChange = new double[3];
    public double[] rotChange = new double[3];
    public double[] scaleChange = new double[3];
    public double opacityChange = 0.0;
    public double[] posOffset = new double[3];
    public double[] rotOffset = new double[3];
    public double[] scaleOffset = new double[3];
    public double opacityOffset = 0.0;
    public ArrayList<double[]> progressionCoords;
    public transient PolynomialFunctionLagrangeForm progressionCurve;
    public String name;
    public int length;
    public int startKey;
    public boolean hidden;
    public String identifier;

    public AnimationComponent(String name, int length, int startKey) {
        this.name = name;
        this.length = length;
        this.startKey = startKey;
        this.identifier = RandomStringUtils.randomAscii((int)20);
    }

    public void animate(CubeInfo info, float time) {
        int i;
        float prog;
        float mag = prog = MathHelper.func_76131_a((float)((time - (float)this.startKey) / (float)this.length), (float)0.0f, (float)1.0f);
        if (this.getProgressionCurve() != null) {
            mag = MathHelper.func_76131_a((float)((float)this.getProgressionCurve().value(prog)), (float)0.0f, (float)1.0f);
        }
        if (time >= (float)this.startKey) {
            for (i = 0; i < 3; ++i) {
                int n = i;
                info.position[n] = info.position[n] + this.posOffset[i];
                int n2 = i;
                info.rotation[n2] = info.rotation[n2] + this.rotOffset[i];
                int n3 = i;
                info.scale[n3] = info.scale[n3] + this.scaleOffset[i];
            }
            info.opacity += this.opacityOffset;
        }
        for (i = 0; i < 3; ++i) {
            int n = i;
            info.position[n] = info.position[n] + this.posChange[i] * (double)mag;
            int n4 = i;
            info.rotation[n4] = info.rotation[n4] + this.rotChange[i] * (double)mag;
            int n5 = i;
            info.scale[n5] = info.scale[n5] + this.scaleChange[i] * (double)mag;
        }
        info.opacity += this.opacityChange * (double)mag;
        if (info.modelCube != null) {
            info.modelCube.func_78793_a((float)info.position[0], (float)info.position[1], (float)info.position[2]);
            info.modelCube.field_78795_f = (float)Math.toRadians(info.rotation[0]);
            info.modelCube.field_78796_g = (float)Math.toRadians(info.rotation[1]);
            info.modelCube.field_78808_h = (float)Math.toRadians(info.rotation[2]);
        }
    }

    public void reset(CubeInfo info, float time) {
        int i;
        float prog;
        float mag = prog = MathHelper.func_76131_a((float)((time - (float)this.startKey) / (float)this.length), (float)0.0f, (float)1.0f);
        if (this.getProgressionCurve() != null) {
            mag = MathHelper.func_76131_a((float)((float)this.getProgressionCurve().value(prog)), (float)0.0f, (float)1.0f);
        }
        if (time >= (float)this.startKey) {
            for (i = 0; i < 3; ++i) {
                int n = i;
                info.position[n] = info.position[n] - this.posOffset[i];
                int n2 = i;
                info.rotation[n2] = info.rotation[n2] - this.rotOffset[i];
                int n3 = i;
                info.scale[n3] = info.scale[n3] - this.scaleOffset[i];
            }
            info.opacity -= this.opacityOffset;
        }
        for (i = 0; i < 3; ++i) {
            int n = i;
            info.position[n] = info.position[n] - this.posChange[i] * (double)mag;
            int n4 = i;
            info.rotation[n4] = info.rotation[n4] - this.rotChange[i] * (double)mag;
            int n5 = i;
            info.scale[n5] = info.scale[n5] - this.scaleChange[i] * (double)mag;
        }
        info.opacity -= this.opacityChange * (double)mag;
        if (info.modelCube != null) {
            info.modelCube.func_78793_a((float)info.position[0], (float)info.position[1], (float)info.position[2]);
            info.modelCube.field_78795_f = (float)Math.toRadians(info.rotation[0]);
            info.modelCube.field_78796_g = (float)Math.toRadians(info.rotation[1]);
            info.modelCube.field_78808_h = (float)Math.toRadians(info.rotation[2]);
        }
    }

    public double getProgressionFactor(double progression) {
        if (this.progressionCurve == null) {
            return progression;
        }
        return this.progressionCurve.value(progression);
    }

    public void addProgressionCoords(double x, double y) {
        if (this.progressionCoords == null) {
            this.progressionCoords = new ArrayList();
        }
        this.progressionCoords.add(new double[]{x, y});
        this.createProgressionCurve();
    }

    public void removeProgressionCoords(double x, double y) {
        for (int i = this.progressionCoords.size() - 1; i >= 0; --i) {
            double[] coord = this.progressionCoords.get(i);
            if (coord[0] != x || coord[1] != y) continue;
            this.progressionCoords.remove(i);
        }
        if (this.progressionCoords.isEmpty()) {
            this.progressionCoords = null;
            this.progressionCurve = null;
        } else {
            this.createProgressionCurve();
        }
    }

    public void moveProgressionCoords(double x, double y, double newX, double newY) {
        for (int i = this.progressionCoords.size() - 1; i >= 0; --i) {
            double[] coord = this.progressionCoords.get(i);
            if (coord[0] != x || coord[1] != y) continue;
            coord[0] = newX;
            coord[1] = newY;
        }
        this.createProgressionCurve();
    }

    public void createProgressionCurve() {
        if (this.progressionCoords != null) {
            double[] xes = new double[this.progressionCoords.size() + 2];
            double[] yes = new double[this.progressionCoords.size() + 2];
            yes[0] = 0.0;
            xes[0] = 0.0;
            yes[1] = 1.0;
            xes[1] = 1.0;
            for (int i = 0; i < this.progressionCoords.size(); ++i) {
                xes[2 + i] = this.progressionCoords.get(i)[0];
                yes[2 + i] = this.progressionCoords.get(i)[1];
            }
            this.progressionCurve = new PolynomialFunctionLagrangeForm(xes, yes);
        }
    }

    public PolynomialFunctionLagrangeForm getProgressionCurve() {
        if (this.progressionCoords != null && this.progressionCurve == null) {
            this.createProgressionCurve();
        }
        return this.progressionCurve;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof AnimationComponent) {
            AnimationComponent comp = (AnimationComponent)arg0;
            return Integer.compare(this.startKey, comp.startKey);
        }
        return 0;
    }
}

