/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import api.player.server.ServerPlayerAPI;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.core.blocks.BlockFluidGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.MaterialOleaginous;
import micdoodle8.mods.galacticraft.core.client.gui.GuiHandler;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GameScreenBasic;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GameScreenCelestial;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GameScreenText;
import micdoodle8.mods.galacticraft.core.command.CommandGCEnergyUnits;
import micdoodle8.mods.galacticraft.core.command.CommandGCHelp;
import micdoodle8.mods.galacticraft.core.command.CommandGCInv;
import micdoodle8.mods.galacticraft.core.command.CommandJoinSpaceRace;
import micdoodle8.mods.galacticraft.core.command.CommandKeepDim;
import micdoodle8.mods.galacticraft.core.command.CommandPlanetTeleport;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationAddOwner;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationChangeOwner;
import micdoodle8.mods.galacticraft.core.command.CommandSpaceStationRemoveOwner;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeMoon;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOrbit;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOverworld;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.grid.ChunkPowerHandler;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.EntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntityFlag;
import micdoodle8.mods.galacticraft.core.entities.EntityLander;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteorChunk;
import micdoodle8.mods.galacticraft.core.entities.EntityParachest;
import micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.EntityTier1Rocket;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerBaseMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemBlockGC;
import micdoodle8.mods.galacticraft.core.items.ItemBucketGC;
import micdoodle8.mods.galacticraft.core.network.ConnectionEvents;
import micdoodle8.mods.galacticraft.core.network.ConnectionPacket;
import micdoodle8.mods.galacticraft.core.network.GalacticraftChannelHandler;
import micdoodle8.mods.galacticraft.core.proxy.CommonProxyCore;
import micdoodle8.mods.galacticraft.core.recipe.RecipeManagerGC;
import micdoodle8.mods.galacticraft.core.schematic.SchematicAdd;
import micdoodle8.mods.galacticraft.core.schematic.SchematicMoonBuggy;
import micdoodle8.mods.galacticraft.core.schematic.SchematicRocketT1;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityArclamp;
import micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFueler;
import micdoodle8.mods.galacticraft.core.tile.TileEntityBuggyFuelerSingle;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoUnloader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCircuitFabricator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFallenMeteor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPadSingle;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNasaWorkbench;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDecompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenPipe;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityParaChest;
import micdoodle8.mods.galacticraft.core.tile.TileEntityRefinery;
import micdoodle8.mods.galacticraft.core.tile.TileEntityScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySolar;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySpaceStationBase;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.tile.TileEntityThruster;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.ThreadRequirementMissing;
import micdoodle8.mods.galacticraft.core.util.ThreadVersionCheck;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeGenBaseMoon;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeGenBaseOrbit;
import micdoodle8.mods.galacticraft.core.world.gen.OreGenOtherMods;
import micdoodle8.mods.galacticraft.core.world.gen.OverworldGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Mod(modid="GalacticraftCore", name="Galacticraft Core", version="3.0.12", acceptedMinecraftVersions="[1.7.2],[1.7.10]", useMetadata=true, dependencies="required-after:Forge@[10.12.2.1147,); required-after:FML@[7.2.217.1147,); required-after:Micdoodlecore; after:IC2; after:BuildCraft|Core; after:BuildCraft|Energy; after:PlayerAPI@[1.3,)", guiFactory="micdoodle8.mods.galacticraft.core.client.gui.screen.ConfigGuiFactoryCore")
public class GalacticraftCore {
    public static final String NAME = "Galacticraft Core";
    @SidedProxy(clientSide="micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore", serverSide="micdoodle8.mods.galacticraft.core.proxy.CommonProxyCore")
    public static CommonProxyCore proxy;
    @Mod.Instance(value="GalacticraftCore")
    public static GalacticraftCore instance;
    public static boolean isPlanetsLoaded;
    public static boolean isHeightConflictingModInstalled;
    public static GalacticraftChannelHandler packetPipeline;
    public static GCPlayerHandler handler;
    public static CreativeTabs galacticraftBlocksTab;
    public static CreativeTabs galacticraftItemsTab;
    public static SolarSystem solarSystemSol;
    public static Planet planetMercury;
    public static Planet planetVenus;
    public static Planet planetMars;
    public static Planet planetOverworld;
    public static Planet planetJupiter;
    public static Planet planetSaturn;
    public static Planet planetUranus;
    public static Planet planetNeptune;
    public static Moon moonMoon;
    public static Satellite satelliteSpaceStation;
    public static final String CONFIG_FILE = "Galacticraft/core.conf";
    public static final String POWER_CONFIG_FILE = "Galacticraft/power-GC3.conf";
    public static final String CHUNKLOADER_CONFIG_FILE = "Galacticraft/chunkloading.conf";
    public static String ASSET_PREFIX;
    public static String TEXTURE_PREFIX;
    public static String PREFIX;
    public static Fluid fluidOil;
    public static Fluid fluidFuel;
    public static Material materialOil;
    public static HashMap<String, ItemStack> itemList;
    public static HashMap<String, ItemStack> blocksList;
    public static ImageWriter jpgWriter;
    public static ImageWriteParam writeParam;
    public static boolean enableJPEG;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        isPlanetsLoaded = Loader.isModLoaded((String)"GalacticraftMars");
        GCCoreUtil.nextID = 0;
        if (Loader.isModLoaded((String)"SmartMoving")) {
            isHeightConflictingModInstalled = true;
        }
        if (Loader.isModLoaded((String)"witchery")) {
            isHeightConflictingModInstalled = true;
        }
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerGC());
        handler = new GCPlayerHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        FMLCommonHandler.instance().bus().register((Object)handler);
        proxy.preInit(event);
        ConnectionPacket.bus = NetworkRegistry.INSTANCE.newEventDrivenChannel("galacticraft");
        ConnectionPacket.bus.register((Object)new ConnectionPacket());
        ConfigManagerCore.initialize(new File(event.getModConfigurationDirectory(), CONFIG_FILE));
        EnergyConfigHandler.setDefaultValues(new File(event.getModConfigurationDirectory(), POWER_CONFIG_FILE));
        ChunkLoadingCallback.loadConfig(new File(event.getModConfigurationDirectory(), CHUNKLOADER_CONFIG_FILE));
        this.registerOilandFuel();
        if (Loader.isModLoaded((String)"PlayerAPI")) {
            ServerPlayerAPI.register((String)"GalacticraftCore", GCPlayerBaseMP.class);
        }
        GCBlocks.initBlocks();
        GCItems.initItems();
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidFuel, 1000), new ItemStack(GCItems.fuelCanister, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidOil, 1000), new ItemStack(GCItems.oilCanister, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        BiomeGenBase biomeOrbitPreInit = BiomeGenBaseOrbit.space;
        BiomeGenBase biomeMoonPreInit = BiomeGenBaseMoon.moonFlat;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        galacticraftBlocksTab = new CreativeTabGC(CreativeTabs.getNextID(), "GalacticraftBlocks", Item.func_150898_a((Block)GCBlocks.machineBase2), 0);
        galacticraftItemsTab = new CreativeTabGC(CreativeTabs.getNextID(), "GalacticraftItems", GCItems.rocketTier1, 0);
        proxy.init(event);
        packetPipeline = GalacticraftChannelHandler.init();
        solarSystemSol = new SolarSystem("sol", "milkyWay").setMapPosition(new Vector3(0.0f, 0.0f));
        Star starSol = (Star)new Star("sol").setParentSolarSystem(solarSystemSol).setTierRequired(-1);
        starSol.setBodyIcon(new ResourceLocation(ASSET_PREFIX, "textures/gui/celestialbodies/sun.png"));
        solarSystemSol.setMainStar(starSol);
        planetOverworld = (Planet)new Planet("overworld").setParentSolarSystem(solarSystemSol).setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(0.0f);
        planetOverworld.setBodyIcon(new ResourceLocation(ASSET_PREFIX, "textures/gui/celestialbodies/earth.png"));
        planetOverworld.setDimensionInfo(ConfigManagerCore.idDimensionOverworld, WorldProvider.class, false).setTierRequired(1);
        planetOverworld.atmosphereComponent(IAtmosphericGas.NITROGEN).atmosphereComponent(IAtmosphericGas.OXYGEN).atmosphereComponent(IAtmosphericGas.ARGON).atmosphereComponent(IAtmosphericGas.WATER);
        moonMoon = (Moon)new Moon("moon").setParentPlanet(planetOverworld).setRelativeSize(0.2667f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(13.0f, 13.0f)).setRelativeOrbitTime(100.0f);
        moonMoon.setDimensionInfo(ConfigManagerCore.idDimensionMoon, WorldProviderMoon.class).setTierRequired(1);
        moonMoon.setBodyIcon(new ResourceLocation(ASSET_PREFIX, "textures/gui/celestialbodies/moon.png"));
        satelliteSpaceStation = (Satellite)new Satellite("spaceStation.overworld").setParentBody(planetOverworld).setRelativeSize(0.2667f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f)).setRelativeOrbitTime(20.0f);
        satelliteSpaceStation.setDimensionInfo(ConfigManagerCore.idDimensionOverworldOrbit, ConfigManagerCore.idDimensionOverworldOrbitStatic, WorldProviderOrbit.class).setTierRequired(1);
        satelliteSpaceStation.setBodyIcon(new ResourceLocation(ASSET_PREFIX, "textures/gui/celestialbodies/spaceStation.png"));
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new ChunkLoadingCallback());
        FMLCommonHandler.instance().bus().register((Object)new ConnectionEvents());
        SchematicRegistry.registerSchematicRecipe(new SchematicRocketT1());
        SchematicRegistry.registerSchematicRecipe(new SchematicMoonBuggy());
        SchematicRegistry.registerSchematicRecipe(new SchematicAdd());
        ChunkPowerHandler.initiate();
        EnergyConfigHandler.initGas();
        this.registerMicroBlocks();
        this.registerCreatures();
        this.registerOtherEntities();
        this.registerTileEntities();
        GalaxyRegistry.registerSolarSystem(solarSystemSol);
        GalaxyRegistry.registerPlanet(planetOverworld);
        GalaxyRegistry.registerMoon(moonMoon);
        GalaxyRegistry.registerSatellite(satelliteSpaceStation);
        GalacticraftRegistry.registerProvider(ConfigManagerCore.idDimensionOverworldOrbit, WorldProviderOrbit.class, false, 0);
        GalacticraftRegistry.registerProvider(ConfigManagerCore.idDimensionOverworldOrbitStatic, WorldProviderOrbit.class, true, 0);
        GalacticraftRegistry.registerTeleportType(WorldProviderSurface.class, new TeleportTypeOverworld());
        GalacticraftRegistry.registerTeleportType(WorldProviderOrbit.class, new TeleportTypeOrbit());
        GalacticraftRegistry.registerTeleportType(WorldProviderMoon.class, new TeleportTypeMoon());
        GalacticraftRegistry.registerRocketGui(WorldProviderOrbit.class, new ResourceLocation(ASSET_PREFIX, "textures/gui/overworldRocketGui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderSurface.class, new ResourceLocation(ASSET_PREFIX, "textures/gui/overworldRocketGui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderMoon.class, new ResourceLocation(ASSET_PREFIX, "textures/gui/moonRocketGui.png"));
        GalacticraftRegistry.addDungeonLoot(1, new ItemStack(GCItems.schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot(1, new ItemStack(GCItems.schematic, 1, 1));
        if (ConfigManagerCore.enableCopperOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 5, 24, 0, 75, 7), (int)4);
        }
        if (ConfigManagerCore.enableTinOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 6, 22, 0, 60, 7), (int)4);
        }
        if (ConfigManagerCore.enableAluminumOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 7, 18, 0, 45, 7), (int)4);
        }
        if (ConfigManagerCore.enableSiliconOreGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldGenerator(GCBlocks.basicBlock, 8, 3, 0, 25, 7), (int)4);
        }
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"http://www.patreon.com/micdoodle8");
        GalacticraftCore.registerCoreGameScreens();
        if (ConfigManagerCore.useOldFuelFluidID && FluidRegistry.isFluidRegistered((String)"fuel")) {
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(FluidRegistry.getFluid((String)"fuel"), 1000), new ItemStack(GCItems.fuelCanister, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        }
        if (ConfigManagerCore.useOldOilFluidID && FluidRegistry.isFluidRegistered((String)"oil")) {
            FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(FluidRegistry.getFluid((String)"oil"), 1000), new ItemStack(GCItems.oilCanister, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
            if (CompatibilityManager.isBCraftEnergyLoaded()) {
                FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidOil, 1000), GameRegistry.findItemStack((String)"BuildCraft|Core", (String)"bucketOil", (int)1), new ItemStack(Items.field_151133_ar)));
            }
        }
        if (!FluidRegistry.isFluidRegistered((String)"oil")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("oil").setDensity(800).setViscosity(1500));
        }
        if (!FluidRegistry.isFluidRegistered((String)"oilgc")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("oilgc").setDensity(800).setViscosity(1500));
        }
        if (!FluidRegistry.isFluidRegistered((String)"fuel")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("fuel").setDensity(400).setViscosity(900));
        }
        if (!FluidRegistry.isFluidRegistered((String)"fuelgc")) {
            FluidRegistry.registerFluid((Fluid)new Fluid("fuelgc").setDensity(400).setViscosity(900));
        }
    }

    private void registerOilandFuel() {
        String oilID = "oil";
        String fuelID = "fuel";
        if (ConfigManagerCore.useOldOilFluidID) {
            oilID = "oilgc";
        }
        if (ConfigManagerCore.useOldFuelFluidID) {
            fuelID = "fuelgc";
        }
        if (!FluidRegistry.isFluidRegistered((String)oilID)) {
            Fluid gcFluidOil = new Fluid(oilID).setDensity(800).setViscosity(1500);
            FluidRegistry.registerFluid((Fluid)gcFluidOil);
        } else {
            GCLog.info("Galacticraft oil is not default, issues may occur.");
        }
        fluidOil = FluidRegistry.getFluid((String)oilID);
        if (fluidOil.getBlock() == null) {
            GCBlocks.crudeOil = new BlockFluidGC(fluidOil, "oil");
            ((BlockFluidGC)GCBlocks.crudeOil).setQuantaPerBlock(3);
            GCBlocks.crudeOil.func_149663_c("crudeOilStill");
            GameRegistry.registerBlock((Block)GCBlocks.crudeOil, ItemBlockGC.class, (String)GCBlocks.crudeOil.func_149739_a());
            fluidOil.setBlock(GCBlocks.crudeOil);
        } else {
            GCBlocks.crudeOil = fluidOil.getBlock();
        }
        if (GCBlocks.crudeOil != null && Item.field_150901_e.func_82594_a("buildcraftenergy:items/bucketOil") == null) {
            GCItems.bucketOil = new ItemBucketGC(GCBlocks.crudeOil, TEXTURE_PREFIX);
            GCItems.bucketOil.func_77655_b("bucketOil");
            GCItems.registerItem(GCItems.bucketOil);
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)oilID, (int)1000), (ItemStack)new ItemStack(GCItems.bucketOil), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        EventHandlerGC.bucketList.put(GCBlocks.crudeOil, GCItems.bucketOil);
        if (!FluidRegistry.isFluidRegistered((String)fuelID)) {
            Fluid gcFluidFuel = new Fluid(fuelID).setDensity(400).setViscosity(900);
            FluidRegistry.registerFluid((Fluid)gcFluidFuel);
        } else {
            GCLog.info("Galacticraft fuel is not default, issues may occur.");
        }
        fluidFuel = FluidRegistry.getFluid((String)fuelID);
        if (fluidFuel.getBlock() == null) {
            GCBlocks.fuel = new BlockFluidGC(fluidFuel, "fuel");
            ((BlockFluidGC)GCBlocks.fuel).setQuantaPerBlock(3);
            GCBlocks.fuel.func_149663_c("fuel");
            GameRegistry.registerBlock((Block)GCBlocks.fuel, ItemBlockGC.class, (String)GCBlocks.fuel.func_149739_a());
            fluidFuel.setBlock(GCBlocks.fuel);
        } else {
            GCBlocks.fuel = fluidFuel.getBlock();
        }
        if (GCBlocks.fuel != null && Item.field_150901_e.func_82594_a("buildcraftenergy:items/bucketFuel") == null) {
            GCItems.bucketFuel = new ItemBucketGC(GCBlocks.fuel, TEXTURE_PREFIX);
            GCItems.bucketFuel.func_77655_b("bucketFuel");
            GCItems.registerItem(GCItems.bucketFuel);
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)fuelID, (int)1000), (ItemStack)new ItemStack(GCItems.bucketFuel), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        EventHandlerGC.bucketList.put(GCBlocks.fuel, GCItems.bucketFuel);
    }

    public static void registerCoreGameScreens() {
        GameScreenBasic rendererBasic = new GameScreenBasic();
        GameScreenCelestial rendererCelest = new GameScreenCelestial();
        GalacticraftRegistry.registerScreen(rendererBasic);
        GalacticraftRegistry.registerScreen(rendererBasic);
        GalacticraftRegistry.registerScreen(rendererCelest);
        GalacticraftRegistry.registerScreen(rendererCelest);
        GalacticraftRegistry.registerScreen(rendererCelest);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        planetMercury = this.makeUnreachablePlanet("mercury", solarSystemSol);
        if (planetMercury != null) {
            planetMercury.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(0.24096386f);
        }
        if ((planetVenus = this.makeUnreachablePlanet("venus", solarSystemSol)) != null) {
            planetVenus.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(2.0f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f, 0.75f)).setRelativeOrbitTime(0.6152793f);
        }
        if ((planetMars = this.makeUnreachablePlanet("mars", solarSystemSol)) != null) {
            planetMars.setRingColorRGB(0.67f, 0.1f, 0.1f).setPhaseShift(0.1667f).setRelativeSize(0.5319f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.25f, 1.25f)).setRelativeOrbitTime(1.881161f);
        }
        if ((planetJupiter = this.makeUnreachablePlanet("jupiter", solarSystemSol)) != null) {
            planetJupiter.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift((float)Math.PI).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f)).setRelativeOrbitTime(11.861994f);
        }
        if ((planetSaturn = this.makeUnreachablePlanet("saturn", solarSystemSol)) != null) {
            planetSaturn.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(5.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f)).setRelativeOrbitTime(29.463308f);
        }
        if ((planetUranus = this.makeUnreachablePlanet("uranus", solarSystemSol)) != null) {
            planetUranus.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.38f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f)).setRelativeOrbitTime(84.06353f);
        }
        if ((planetNeptune = this.makeUnreachablePlanet("neptune", solarSystemSol)) != null) {
            planetNeptune.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.0f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.25f, 2.25f)).setRelativeOrbitTime(164.84119f);
        }
        MinecraftForge.EVENT_BUS.register((Object)new OreGenOtherMods());
        proxy.postInit(event);
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (!body.shouldAutoRegister()) continue;
            int id = Arrays.binarySearch(ConfigManagerCore.staticLoadDimensions, body.getDimensionID());
            if (GalacticraftRegistry.registerProvider(body.getDimensionID(), body.getWorldProvider(), body.getForceStaticLoad() || id < 0, 0)) continue;
            body.setUnreachable();
        }
        CompatibilityManager.checkForCompatibleMods();
        RecipeManagerGC.loadRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerServer());
        GalaxyRegistry.refreshGalaxies();
        GalacticraftRegistry.registerScreen(new GameScreenText());
        try {
            jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            writeParam = jpgWriter.getDefaultWriteParam();
            writeParam.setCompressionMode(2);
            writeParam.setCompressionQuality(1.0f);
            enableJPEG = true;
        }
        catch (UnsatisfiedLinkError e) {
            GCLog.severe("Error initialising JPEG compressor - this is likely caused by OpenJDK - see https://wiki.micdoodle8.com/wiki/Compatibility#For_Linux_servers_running_OpenJDK");
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        if (ThreadRequirementMissing.INSTANCE == null) {
            ThreadRequirementMissing.beginCheck(FMLCommonHandler.instance().getEffectiveSide());
        }
        ThreadVersionCheck.startCheck();
        TickHandlerServer.restart();
        BlockVec3.chunkCacheDim = Integer.MAX_VALUE;
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSpaceStationAddOwner());
        event.registerServerCommand((ICommand)new CommandSpaceStationChangeOwner());
        event.registerServerCommand((ICommand)new CommandSpaceStationRemoveOwner());
        event.registerServerCommand((ICommand)new CommandPlanetTeleport());
        event.registerServerCommand((ICommand)new CommandKeepDim());
        event.registerServerCommand((ICommand)new CommandGCInv());
        event.registerServerCommand((ICommand)new CommandGCHelp());
        event.registerServerCommand((ICommand)new CommandGCEnergyUnits());
        event.registerServerCommand((ICommand)new CommandJoinSpaceRace());
        WorldUtil.initialiseDimensionNames();
        WorldUtil.registerSpaceStations(event.getServer().func_71218_a(0).func_72860_G().func_75758_b("dummy").getParentFile());
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (!body.shouldAutoRegister() || WorldUtil.registerPlanet(body.getDimensionID(), body.getReachable(), 0)) continue;
            body.setUnreachable();
        }
        RecipeManagerGC.setConfigurableRecipes();
    }

    @Mod.EventHandler
    public void unregisterDims(FMLServerStoppedEvent var1) {
        WorldUtil.unregisterPlanets();
        WorldUtil.unregisterSpaceStations();
    }

    private void registerMicroBlocks() {
        try {
            Class<?> clazz = Class.forName("codechicken.microblock.MicroMaterialRegistry");
            if (clazz != null) {
                Method[] methodz;
                Method registerMethod = null;
                for (Method m : methodz = clazz.getMethods()) {
                    if (!m.getName().equals("registerMaterial")) continue;
                    registerMethod = m;
                    break;
                }
                Class<?> clazzbm = Class.forName("codechicken.microblock.BlockMicroMaterial");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 3), "tile.gcBlockCore.decoblock1");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 4), "tile.gcBlockCore.decoblock2");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 9), "tile.gcBlockCore.copperBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 10), "tile.gcBlockCore.tinBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 11), "tile.gcBlockCore.aluminumBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 12), "tile.gcBlockCore.meteorironBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 3), "tile.moonBlock.moondirt");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 4), "tile.moonBlock.moonstone");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 5), "tile.moonBlock.moongrass");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 14), "tile.moonBlock.bricks");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityTreasureChest.class, (String)(CompatibilityManager.isAIILoaded() ? "Space Treasure Chest" : "Treasure Chest"));
        GameRegistry.registerTileEntity(TileEntityOxygenDistributor.class, (String)"Air Distributor");
        GameRegistry.registerTileEntity(TileEntityOxygenCollector.class, (String)"Air Collector");
        GameRegistry.registerTileEntity(TileEntityOxygenPipe.class, (String)"Oxygen Pipe");
        GameRegistry.registerTileEntity(TileEntityAirLock.class, (String)"Air Lock Frame");
        GameRegistry.registerTileEntity(TileEntityRefinery.class, (String)"Refinery");
        GameRegistry.registerTileEntity(TileEntityNasaWorkbench.class, (String)"NASA Workbench");
        GameRegistry.registerTileEntity(TileEntityOxygenCompressor.class, (String)"Air Compressor");
        GameRegistry.registerTileEntity(TileEntityFuelLoader.class, (String)"Fuel Loader");
        GameRegistry.registerTileEntity(TileEntityLandingPadSingle.class, (String)"Landing Pad");
        GameRegistry.registerTileEntity(TileEntityLandingPad.class, (String)"Landing Pad Full");
        GameRegistry.registerTileEntity(TileEntitySpaceStationBase.class, (String)"Space Station");
        GameRegistry.registerTileEntity(TileEntityMulti.class, (String)"Dummy Block");
        GameRegistry.registerTileEntity(TileEntityOxygenSealer.class, (String)"Air Sealer");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawner.class, (String)"Dungeon Boss Spawner");
        GameRegistry.registerTileEntity(TileEntityOxygenDetector.class, (String)"Oxygen Detector");
        GameRegistry.registerTileEntity(TileEntityBuggyFueler.class, (String)"Buggy Fueler");
        GameRegistry.registerTileEntity(TileEntityBuggyFuelerSingle.class, (String)"Buggy Fueler Single");
        GameRegistry.registerTileEntity(TileEntityCargoLoader.class, (String)"Cargo Loader");
        GameRegistry.registerTileEntity(TileEntityCargoUnloader.class, (String)"Cargo Unloader");
        GameRegistry.registerTileEntity(TileEntityParaChest.class, (String)"Parachest Tile");
        GameRegistry.registerTileEntity(TileEntitySolar.class, (String)"Galacticraft Solar Panel");
        GameRegistry.registerTileEntity(TileEntityDish.class, (String)"Radio Telescope");
        GameRegistry.registerTileEntity(TileEntityEnergyStorageModule.class, (String)"Energy Storage Module");
        GameRegistry.registerTileEntity(TileEntityCoalGenerator.class, (String)"Galacticraft Coal Generator");
        GameRegistry.registerTileEntity(TileEntityElectricFurnace.class, (String)"Galacticraft Electric Furnace");
        GameRegistry.registerTileEntity(TileEntityAluminumWire.class, (String)"Galacticraft Aluminum Wire");
        GameRegistry.registerTileEntity(TileEntityFallenMeteor.class, (String)"Fallen Meteor");
        GameRegistry.registerTileEntity(TileEntityIngotCompressor.class, (String)"Ingot Compressor");
        GameRegistry.registerTileEntity(TileEntityElectricIngotCompressor.class, (String)"Electric Ingot Compressor");
        GameRegistry.registerTileEntity(TileEntityCircuitFabricator.class, (String)"Circuit Fabricator");
        GameRegistry.registerTileEntity(TileEntityAirLockController.class, (String)"Air Lock Controller");
        GameRegistry.registerTileEntity(TileEntityOxygenStorageModule.class, (String)"Oxygen Storage Module");
        GameRegistry.registerTileEntity(TileEntityOxygenDecompressor.class, (String)"Oxygen Decompressor");
        GameRegistry.registerTileEntity(TileEntityThruster.class, (String)"Space Station Thruster");
        GameRegistry.registerTileEntity(TileEntityArclamp.class, (String)"Arc Lamp");
        GameRegistry.registerTileEntity(TileEntityScreen.class, (String)"View Screen");
        GameRegistry.registerTileEntity(TileEntityTelemetry.class, (String)"Telemetry Unit");
    }

    public void registerCreatures() {
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedSpider.class, "EvolvedSpider", 3419431, 11013646);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedZombie.class, "EvolvedZombie", 44975, 7969893);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedCreeper.class, "EvolvedCreeper", 894731, 0);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedSkeleton.class, "EvolvedSkeleton", 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(EntitySkeletonBoss.class, "EvolvedSkeletonBoss", 0xC1C1C1, 0x494949);
        GCCoreUtil.registerGalacticraftCreature(EntityAlienVillager.class, "AlienVillager", ColorUtil.to32BitColor(255, 103, 145, 181), 12422002);
    }

    public void registerOtherEntities() {
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier1Rocket.class, "Spaceship", 150, 1, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityMeteor.class, "Meteor", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityBuggy.class, "Buggy", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityFlag.class, "GCFlag", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityParachest.class, "ParaChest", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityLander.class, "Lander", 150, 5, false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityMeteorChunk.class, "MeteorChunk", 150, 5, true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityCelestialFake.class, "CelestialScreen", 150, 5, false);
    }

    public Planet makeUnreachablePlanet(String name, SolarSystem system) {
        ArrayList<Planet> cBodyList = new ArrayList<Planet>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        for (CelestialBody celestialBody : cBodyList) {
            if (!(celestialBody instanceof Planet) || !name.equals(celestialBody.getName()) || ((Planet)celestialBody).getParentSolarSystem() != system) continue;
            return null;
        }
        Planet planet = new Planet(name).setParentSolarSystem(system);
        planet.setBodyIcon(new ResourceLocation(ASSET_PREFIX, "textures/gui/celestialbodies/" + name + ".png"));
        GalaxyRegistry.registerPlanet(planet);
        return planet;
    }

    static {
        ASSET_PREFIX = "galacticraftcore";
        TEXTURE_PREFIX = ASSET_PREFIX + ":";
        PREFIX = "micdoodle8.";
        materialOil = new MaterialOleaginous(MapColor.field_151650_B);
        itemList = new HashMap();
        blocksList = new HashMap();
        enableJPEG = false;
    }
}

