/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import cpw.mods.fml.common.eventhandler.Event;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.IPlayerServer;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemArmorAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.items.ItemArmorMars;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;

public class PlayerServer
implements IPlayerServer {
    boolean updatingRidden = false;

    @Override
    public void clonePlayer(EntityPlayerMP player, EntityPlayer oldPlayer, boolean keepInv) {
        if (oldPlayer instanceof EntityPlayerMP) {
            GCPlayerStats.get(player).copyFrom(GCPlayerStats.get((EntityPlayerMP)oldPlayer), keepInv || player.field_70170_p.func_82736_K().func_82766_b("keepInventory"));
            TileEntityTelemetry.updateLinkedPlayer((EntityPlayerMP)oldPlayer, player);
        }
    }

    @Override
    public void updateRiddenPre(EntityPlayerMP player) {
        this.updatingRidden = true;
    }

    @Override
    public void updateRiddenPost(EntityPlayerMP player) {
        this.updatingRidden = false;
    }

    @Override
    public boolean mountEntity(EntityPlayerMP player, Entity par1Entity) {
        return this.updatingRidden && player.field_70154_o instanceof IIgnoreShift && ((IIgnoreShift)player.field_70154_o).shouldIgnoreShiftExit();
    }

    @Override
    public void moveEntity(EntityPlayerMP player, double par1, double par3, double par5) {
        if (player.field_70170_p.field_73011_w instanceof WorldProviderMoon && !player.field_70170_p.field_72995_K && player.field_70154_o == null) {
            GCPlayerHandler.updateFeet(player, par1, par5);
        }
    }

    @Override
    public boolean wakeUpPlayer(EntityPlayerMP player, boolean par1, boolean par2, boolean par3) {
        return this.wakeUpPlayer(player, par1, par2, par3, false);
    }

    @Override
    public float attackEntityFrom(EntityPlayerMP player, DamageSource par1DamageSource, float par2) {
        if (player.field_70154_o instanceof EntityCelestialFake) {
            return -1.0f;
        }
        if (GalacticraftCore.isPlanetsLoaded) {
            if (par1DamageSource == DamageSource.field_76380_i) {
                if (player.field_70170_p.field_73011_w instanceof WorldProviderAsteroids) {
                    if (player.field_70163_u > -120.0) {
                        return -1.0f;
                    }
                    if (player.field_70163_u > -180.0) {
                        par2 /= 2.0f;
                    }
                }
            } else if (par1DamageSource == DamageSource.field_76379_h || par1DamageSource == DamageSourceGC.spaceshipCrash) {
                int titaniumCount = 0;
                if (player.field_71071_by != null) {
                    for (int i = 0; i < 4; ++i) {
                        ItemStack armorPiece = player.func_82169_q(i);
                        if (armorPiece == null || !(armorPiece.func_77973_b() instanceof ItemArmorAsteroids)) continue;
                        ++titaniumCount;
                    }
                }
                if (titaniumCount == 4) {
                    titaniumCount = 5;
                }
                par2 = (float)((double)par2 * (1.0 - 0.15 * (double)titaniumCount));
            }
        }
        return par2;
    }

    @Override
    public void knockBack(EntityPlayerMP player, Entity p_70653_1_, float p_70653_2_, double impulseX, double impulseZ) {
        int deshCount = 0;
        if (player.field_71071_by != null && GalacticraftCore.isPlanetsLoaded) {
            for (int i = 0; i < 4; ++i) {
                ItemStack armorPiece = player.func_82169_q(i);
                if (armorPiece == null || !(armorPiece.func_77973_b() instanceof ItemArmorMars)) continue;
                ++deshCount;
            }
        }
        if (player.func_70681_au().nextDouble() >= player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            player.field_70160_al = deshCount < 2;
            float f1 = MathHelper.func_76133_a((double)(impulseX * impulseX + impulseZ * impulseZ));
            float f2 = 0.4f - (float)deshCount * 0.05f;
            double d1 = 2.0 - (double)deshCount * 0.15;
            player.field_70159_w /= d1;
            player.field_70181_x /= d1;
            player.field_70179_y /= d1;
            player.field_70159_w -= (double)f2 * impulseX / (double)f1;
            player.field_70181_x += (double)f2;
            player.field_70179_y -= (double)f2 * impulseZ / (double)f1;
            if (player.field_70181_x > 0.4) {
                player.field_70181_x = 0.4;
            }
        }
    }

    public boolean wakeUpPlayer(EntityPlayerMP player, boolean par1, boolean par2, boolean par3, boolean bypass) {
        ChunkCoordinates c = player.field_71081_bT;
        if (c != null) {
            EventWakePlayer event = new EventWakePlayer((EntityPlayer)player, c.field_71574_a, c.field_71572_b, c.field_71573_c, par1, par2, par3, bypass);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (bypass || event.result == null || event.result == EntityPlayer.EnumStatus.OK) {
                return false;
            }
        }
        return true;
    }
}

