/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityOxygenCompressor
extends TileEntityOxygen
implements IInventory,
ISidedInventory {
    private ItemStack[] containingItems = new ItemStack[3];
    public static final int TANK_TRANSFER_SPEED = 2;
    private boolean usingEnergy = false;

    public TileEntityOxygenCompressor() {
        super(1200.0f, 16.0f);
        this.storage.setMaxExtract(15.0f);
    }

    @Override
    public void func_145845_h() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(2)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            float oxygenDraw = Math.min(this.oxygenPerTick * 2.5f, this.maxOxygen - this.storedOxygen);
            this.storedOxygen += oxygenItem.discharge(oxygenItemStack, oxygenDraw);
            if (this.storedOxygen > this.maxOxygen) {
                this.storedOxygen = this.maxOxygen;
            }
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack tank0;
            this.usingEnergy = false;
            if (this.storedOxygen > 0.0f && this.hasEnoughEnergyToRun && (tank0 = this.containingItems[0]) != null && tank0.func_77973_b() instanceof ItemOxygenTank && tank0.func_77960_j() > 0) {
                tank0.func_77964_b(tank0.func_77960_j() - 2);
                this.storedOxygen -= 2.0f;
                this.usingEnergy = true;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.oxygencompressor.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77960_j() > 1;
                }
                case 1: {
                    return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
                }
                case 2: {
                    return itemstack.func_77960_j() < itemstack.func_77973_b().func_77612_l();
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof ItemOxygenTank && itemstack.func_77960_j() == 0;
            }
            case 1: {
                return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f;
            }
            case 2: {
                return FluidUtil.isEmptyContainer(itemstack);
            }
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof ItemOxygenTank;
            }
            case 1: {
                return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            case 2: {
                return itemstack.func_77973_b() instanceof IItemOxygenSupply;
            }
        }
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.usingEnergy;
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() + 2));
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(1);
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public EnumSet<ForgeDirection> getOxygenInputDirections() {
        return EnumSet.of(this.getElectricInputDirection().getOpposite());
    }

    @Override
    public EnumSet<ForgeDirection> getOxygenOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }
}

