/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.material.MachinePart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class MachinePartRenderer
implements IItemRenderer {
    private ItemRenderer itemRenderer = new ItemRenderer(Minecraft.func_71410_x());
    private RenderItem renderItem = new RenderItem();
    private boolean loggedError = false;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (item != null && item.func_77960_j() == MachinePart.MACHINE_CHASSI.ordinal()) {
            return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            RenderBlocks renderBlocks = (RenderBlocks)data[0];
            this.renderToInventory(item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderEquipped(item, (RenderBlocks)data[0]);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderEntity(item, (RenderBlocks)data[0]);
        } else if (this.loggedError) {
            Log.warn("MachinePartRenderer.renderItem: Unsupported render type");
            this.loggedError = true;
        }
    }

    private void renderEntity(ItemStack item, RenderBlocks renderBlocks) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderToInventory(item, renderBlocks);
        GL11.glPopMatrix();
    }

    private void renderEquipped(ItemStack item, RenderBlocks renderBlocks) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderToInventory(item, renderBlocks);
        GL11.glPopMatrix();
    }

    private void renderToInventory(ItemStack item, RenderBlocks renderBlocks) {
        GL11.glEnable((int)3008);
        renderBlocks.func_147757_a(EnderIO.itemMachinePart.func_77617_a(item.func_77960_j()));
        renderBlocks.func_147800_a(Blocks.field_150348_b, 0, 1.0f);
        renderBlocks.func_147771_a();
        GL11.glDisable((int)3008);
    }
}

