/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBootstrapComponent;
import appeng.bootstrap.IItemBuilder;
import appeng.bootstrap.ItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.core.AEConfig;
import appeng.core.CreativeTab;
import appeng.core.features.AEFeature;
import appeng.core.features.ItemDefinition;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

class ItemDefinitionBuilder
implements IItemBuilder {
    private final FeatureFactory factory;
    private final String registryName;
    private final Supplier<Item> itemSupplier;
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);
    private final List<Function<Item, IBootstrapComponent>> boostrapComponents = new ArrayList<Function<Item, IBootstrapComponent>>();
    private Supplier<IBehaviorDispenseItem> dispenserBehaviorSupplier;
    @SideOnly(value=Side.CLIENT)
    private ItemRendering itemRendering;
    private CreativeTabs creativeTab = CreativeTab.instance;

    ItemDefinitionBuilder(FeatureFactory factory, String registryName, Supplier<Item> itemSupplier) {
        this.factory = factory;
        this.registryName = registryName;
        this.itemSupplier = itemSupplier;
        if (Platform.isClient()) {
            this.itemRendering = new ItemRendering();
        }
    }

    @Override
    public IItemBuilder bootstrap(Function<Item, IBootstrapComponent> component) {
        this.boostrapComponents.add(component);
        return this;
    }

    @Override
    public IItemBuilder features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    @Override
    public IItemBuilder addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    @Override
    public IItemBuilder creativeTab(CreativeTabs tab) {
        this.creativeTab = tab;
        return this;
    }

    @Override
    public IItemBuilder rendering(ItemRenderingCustomizer callback) {
        if (Platform.isClient()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public IItemBuilder dispenserBehavior(Supplier<IBehaviorDispenseItem> behavior) {
        this.dispenserBehaviorSupplier = behavior;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void customizeForClient(ItemRenderingCustomizer callback) {
        callback.customize(this.itemRendering);
    }

    @Override
    public ItemDefinition build() {
        if (!AEConfig.instance().areFeaturesEnabled(this.features)) {
            return new ItemDefinition(this.registryName, null);
        }
        Item item = this.itemSupplier.get();
        item.setRegistryName("appliedenergistics2", this.registryName);
        ItemDefinition definition = new ItemDefinition(this.registryName, item);
        item.func_77655_b("appliedenergistics2." + this.registryName);
        item.func_77637_a(this.creativeTab);
        this.boostrapComponents.forEach(component -> {
            IBootstrapComponent cfr_ignored_0 = (IBootstrapComponent)component.apply(item);
        });
        if (this.dispenserBehaviorSupplier != null) {
            this.factory.addBootstrapComponent(side -> {
                IBehaviorDispenseItem behavior = this.dispenserBehaviorSupplier.get();
                BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)behavior);
            });
        }
        this.factory.addBootstrapComponent((side, reg) -> reg.register((IForgeRegistryEntry)item));
        if (Platform.isClient()) {
            this.itemRendering.apply(this.factory, item);
        }
        return definition;
    }
}

