/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageHelper;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.crafting.CraftingLink;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import appeng.util.item.FluidList;
import appeng.util.item.ItemList;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class ApiStorage
implements IStorageHelper {
    private final ClassToInstanceMap<IStorageChannel<?>> channels = MutableClassToInstanceMap.create();

    public ApiStorage() {
        this.registerStorageChannel(IItemStorageChannel.class, new ItemStorageChannel());
        this.registerStorageChannel(IFluidStorageChannel.class, new FluidStorageChannel());
    }

    @Override
    public <T extends IAEStack<T>, C extends IStorageChannel<T>> void registerStorageChannel(Class<C> channel, C factory) {
        Preconditions.checkNotNull(channel);
        Preconditions.checkNotNull(factory);
        Preconditions.checkArgument((boolean)channel.isInstance(factory));
        Preconditions.checkArgument((!this.channels.containsKey(channel) ? 1 : 0) != 0);
        this.channels.putInstance(channel, factory);
    }

    @Override
    public <T extends IAEStack<T>, C extends IStorageChannel<T>> C getStorageChannel(Class<C> channel) {
        Preconditions.checkNotNull(channel);
        IStorageChannel type = (IStorageChannel)this.channels.getInstance(channel);
        Preconditions.checkNotNull((Object)type);
        return (C)type;
    }

    @Override
    public Collection<IStorageChannel<? extends IAEStack<?>>> storageChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    @Override
    public ICraftingLink loadCraftingLink(NBTTagCompound data, ICraftingRequester req) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkNotNull((Object)req);
        return new CraftingLink(data, req);
    }

    private static final class FluidStorageChannel
    implements IFluidStorageChannel {
        private FluidStorageChannel() {
        }

        @Override
        public IItemList<IAEFluidStack> createList() {
            return new FluidList();
        }

        @Override
        public IAEFluidStack createStack(Object input) {
            Preconditions.checkNotNull((Object)input);
            if (input instanceof FluidStack) {
                return AEFluidStack.fromFluidStack((FluidStack)input);
            }
            return null;
        }

        @Override
        public IAEFluidStack readFromPacket(ByteBuf input) throws IOException {
            Preconditions.checkNotNull((Object)input);
            return AEFluidStack.fromPacket(input);
        }

        @Override
        public IAEFluidStack poweredExtraction(IEnergySource energy, IMEInventory<IAEFluidStack> cell, IAEFluidStack request, IActionSource src) {
            Preconditions.checkNotNull((Object)energy);
            Preconditions.checkNotNull(cell);
            Preconditions.checkNotNull((Object)request);
            Preconditions.checkNotNull((Object)src);
            return null;
        }

        @Override
        public IAEFluidStack poweredInsert(IEnergySource energy, IMEInventory<IAEFluidStack> cell, IAEFluidStack input, IActionSource src) {
            Preconditions.checkNotNull((Object)energy);
            Preconditions.checkNotNull(cell);
            Preconditions.checkNotNull((Object)input);
            Preconditions.checkNotNull((Object)src);
            return input;
        }
    }

    private static final class ItemStorageChannel
    implements IItemStorageChannel {
        private ItemStorageChannel() {
        }

        @Override
        public IItemList<IAEItemStack> createList() {
            return new ItemList();
        }

        @Override
        public IAEItemStack createStack(Object input) {
            Preconditions.checkNotNull((Object)input);
            if (input instanceof ItemStack) {
                return AEItemStack.fromItemStack((ItemStack)input);
            }
            return null;
        }

        @Override
        public IAEItemStack readFromPacket(ByteBuf input) throws IOException {
            Preconditions.checkNotNull((Object)input);
            return AEItemStack.fromPacket(input);
        }

        @Override
        public IAEItemStack poweredExtraction(IEnergySource energy, IMEInventory<IAEItemStack> cell, IAEItemStack request, IActionSource src) {
            Preconditions.checkNotNull((Object)energy);
            Preconditions.checkNotNull(cell);
            Preconditions.checkNotNull((Object)request);
            Preconditions.checkNotNull((Object)src);
            return Platform.poweredExtraction(energy, cell, request, src);
        }

        @Override
        public IAEItemStack poweredInsert(IEnergySource energy, IMEInventory<IAEItemStack> cell, IAEItemStack input, IActionSource src) {
            Preconditions.checkNotNull((Object)energy);
            Preconditions.checkNotNull(cell);
            Preconditions.checkNotNull((Object)input);
            Preconditions.checkNotNull((Object)src);
            return Platform.poweredInsert(energy, cell, input, src);
        }
    }
}

