/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.exceptions.MissingIngredientException;
import appeng.api.exceptions.RegistrationException;
import appeng.api.recipes.IIngredient;
import appeng.recipes.game.ShapelessRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;

class ShapelessRecipeWrapper
implements IRecipeWrapper {
    private final ShapelessRecipe recipe;

    public ShapelessRecipeWrapper(ShapelessRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<Object> recipeInput = this.recipe.getInput();
        ArrayList<ArrayList> inputs = new ArrayList<ArrayList>(recipeInput.size());
        for (Object e : recipeInput) {
            if (!(e instanceof IIngredient)) continue;
            IIngredient ingredient = (IIngredient)e;
            try {
                inputs.add(Lists.newArrayList((Object[])ingredient.getItemStackSet()));
            }
            catch (MissingIngredientException | RegistrationException registrationError) {
                throw new RuntimeException("Unable to register recipe with JEI");
            }
        }
        ingredients.setInputLists(ItemStack.class, inputs);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.func_77571_b());
    }
}

