/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import appeng.parts.networking.PartCableSmart;
import appeng.parts.networking.PartDenseCableSmart;
import gnu.trove.map.TObjectByteMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ChannelWailaDataProvider
extends BasePartWailaDataProvider {
    private static final String ID_USED_CHANNELS = "usedChannels";
    private final TObjectByteMap<IPart> cache = new TObjectByteHashMap();

    @Override
    public List<String> getWailaBody(IPart part, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag;
        byte usedChannels;
        if ((part instanceof PartCableSmart || part instanceof PartDenseCableSmart) && (usedChannels = this.getUsedChannels(part, tag = accessor.getNBTData(), this.cache)) >= 0) {
            byte maxChannels = (byte)(part instanceof PartDenseCableSmart ? 32 : 8);
            String formattedToolTip = String.format(WailaText.Channels.getLocal(), usedChannels, maxChannels);
            currentToolTip.add(formattedToolTip);
        }
        return currentToolTip;
    }

    private byte getUsedChannels(IPart part, NBTTagCompound tag, TObjectByteMap<IPart> cache) {
        byte usedChannels;
        if (tag.func_74764_b(ID_USED_CHANNELS)) {
            usedChannels = tag.func_74771_c(ID_USED_CHANNELS);
            this.cache.put((Object)part, usedChannels);
        } else {
            usedChannels = this.cache.containsKey((Object)part) ? this.cache.get((Object)part) : (byte)-1;
        }
        return usedChannels;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, IPart part, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (part instanceof PartCableSmart || part instanceof PartDenseCableSmart) {
            NBTTagCompound tempTag = new NBTTagCompound();
            part.writeToNBT(tempTag);
            if (tempTag.func_74764_b(ID_USED_CHANNELS)) {
                byte usedChannels = tempTag.func_74771_c(ID_USED_CHANNELS);
                tag.func_74774_a(ID_USED_CHANNELS, usedChannels);
            }
        }
        return tag;
    }
}

