/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToolMemoryCard
extends AEBaseItem
implements IMemoryCard {
    public ToolMemoryCard() {
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        lines.add(this.getLocalizedName(this.getSettingsName(stack) + ".name", this.getSettingsName(stack)));
        NBTTagCompound data = this.getData(stack);
        if (data.func_74764_b("tooltip")) {
            lines.add(I18n.func_74838_a((String)this.getLocalizedName(data.func_74779_i("tooltip") + ".name", data.func_74779_i("tooltip"))));
        }
    }

    private String getLocalizedName(String ... name) {
        for (String n3 : name) {
            String l = I18n.func_74838_a((String)n3);
            if (l.equals(n3)) continue;
            return l;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String settingsName, NBTTagCompound data) {
        NBTTagCompound c = Platform.openNbtData(is);
        c.func_74778_a("Config", settingsName);
        c.func_74782_a("Data", (NBTBase)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        String name = c.func_74779_i("Config");
        return name == null || name.isEmpty() ? GuiText.Blank.getUnlocalized() : name;
    }

    @Override
    public NBTTagCompound getData(ItemStack is) {
        NBTTagCompound c = Platform.openNbtData(is);
        NBTTagCompound o = c.func_74775_l("Data");
        if (o == null) {
            o = new NBTTagCompound();
        }
        return o.func_74737_b();
    }

    @Override
    public void notifyUser(EntityPlayer player, MemoryCardMessages msg) {
        if (Platform.isClient()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.func_145747_a(PlayerMessages.SettingCleared.get());
                break;
            }
            case INVALID_MACHINE: {
                player.func_145747_a(PlayerMessages.InvalidMachine.get());
                break;
            }
            case SETTINGS_LOADED: {
                player.func_145747_a(PlayerMessages.LoadedSettings.get());
                break;
            }
            case SETTINGS_SAVED: {
                player.func_145747_a(PlayerMessages.SavedSettings.get());
                break;
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hx, float hy, float hz) {
        if (player.func_70093_af()) {
            if (!w.field_72995_K) {
                IMemoryCard mem = (IMemoryCard)player.func_184586_b(hand).func_77973_b();
                mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
                player.func_184586_b(hand).func_77982_d(null);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, w, pos, hand, side, hx, hy, hz);
    }

    public boolean doesSneakBypassUse(ItemStack itemstack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }
}

