/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.api.exceptions.MissingIngredientException;
import appeng.api.exceptions.RegistrationException;
import appeng.api.recipes.IIngredient;
import appeng.api.recipes.ResolverResultSet;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class IngredientSet
implements IIngredient {
    private final int qty;
    private final String name;
    private final List<ItemStack> items;
    private final boolean isInside = false;
    private ItemStack[] baked;

    public IngredientSet(ResolverResultSet rr, int qty) {
        Preconditions.checkNotNull((Object)rr);
        Preconditions.checkNotNull((Object)rr.name);
        Preconditions.checkNotNull(rr.results);
        Preconditions.checkState((qty > 0 ? 1 : 0) != 0);
        this.name = rr.name;
        this.items = rr.results;
        this.qty = qty;
    }

    @Override
    public ItemStack getItemStack() throws RegistrationException, MissingIngredientException {
        throw new RegistrationException("Cannot pass group of items to a recipe which desires a single recipe item.");
    }

    @Override
    public ItemStack[] getItemStackSet() throws RegistrationException, MissingIngredientException {
        if (this.baked != null) {
            return this.baked;
        }
        this.getClass();
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        out.addAll(this.items);
        if (out.isEmpty()) {
            throw new MissingIngredientException(this.toString() + " - group could not be resolved to any items.");
        }
        for (ItemStack is : out) {
            is.func_190920_e(this.qty);
        }
        return out.toArray(new ItemStack[out.size()]);
    }

    @Override
    public boolean isAir() {
        return false;
    }

    @Override
    public String getNameSpace() {
        return "";
    }

    @Override
    public String getItemName() {
        return this.name;
    }

    @Override
    public int getDamageValue() {
        return Short.MAX_VALUE;
    }

    @Override
    public int getQty() {
        return this.qty;
    }

    @Override
    public void bake() throws RegistrationException, MissingIngredientException {
        this.baked = null;
        this.baked = this.getItemStackSet();
    }
}

