/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientException;
import appeng.api.exceptions.RecipeException;
import appeng.api.exceptions.RegistrationException;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.core.AELog;
import appeng.integration.Integrations;
import appeng.integration.abstraction.IMekanism;
import appeng.recipes.RecipeHandler;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.item.ItemStack;

public class MekCrusher
implements ICraftHandler,
IWebsiteSerializer {
    private IIngredient pro_input;
    private IIngredient[] pro_output;

    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeException {
        if (input.size() == 1 && output.size() == 1) {
            int outs = output.get(0).size();
            if (input.get(0).size() == 1 && outs == 1) {
                this.pro_input = input.get(0).get(0);
                this.pro_output = output.get(0).toArray(new IIngredient[outs]);
                return;
            }
        }
        throw new RecipeException("MekCrusher must have a single input, and single output.");
    }

    @Override
    public void register() throws RegistrationException, MissingIngredientException {
        IMekanism mekanism = Integrations.mekanism();
        for (ItemStack is : this.pro_input.getItemStackSet()) {
            try {
                mekanism.addCrusherRecipe(is, this.pro_output[0].getItemStack());
            }
            catch (RuntimeException err) {
                AELog.info("Mekanism not happy - " + err.getMessage(), new Object[0]);
            }
        }
    }

    @Override
    public String getPattern(RecipeHandler h) {
        return null;
    }

    @Override
    public boolean canCraft(ItemStack output) throws RegistrationException, MissingIngredientException {
        return Platform.itemComparisons().isSameItem(this.pro_output[0].getItemStack(), output);
    }
}

