/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientException;
import appeng.api.exceptions.RecipeException;
import appeng.api.exceptions.RegistrationException;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.recipes.RecipeHandler;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class Shaped
implements ICraftHandler,
IWebsiteSerializer {
    private List<List<IIngredient>> inputs;
    private IIngredient output;
    private int rows;
    private int cols;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeException {
        if (output.size() != 1 || output.get(0).size() != 1) throw new RecipeException("Crafting must produce a single output.");
        this.rows = input.size();
        if (this.rows <= 0 || input.size() > 3) throw new RecipeException("shaped crafting recipes must have 1-3 rows.");
        this.cols = input.get(0).size();
        if (this.cols > 3 || this.cols < 1) throw new RecipeException("Crafting recipes must have 1-3 columns.");
        for (List<IIngredient> anInput : input) {
            if (anInput.size() == this.cols) continue;
            throw new RecipeException("all rows in a shaped crafting recipe must contain the same number of ingredients.");
        }
        this.inputs = input;
        this.output = output.get(0).get(0);
    }

    @Override
    public void register() throws RegistrationException, MissingIngredientException {
        char first = 'A';
        ArrayList<Object> args = new ArrayList<Object>();
        for (int y = 0; y < this.rows; ++y) {
            StringBuilder row = new StringBuilder();
            for (int x = 0; x < this.cols; ++x) {
                if (this.inputs.get(y).get(x).isAir()) {
                    row.append(' ');
                    continue;
                }
                row.append(first);
                args.add(Character.valueOf(first));
                args.add(this.inputs.get(y).get(x));
                first = (char)(first + '\u0001');
            }
            args.add(y, row.toString());
        }
        ItemStack outIS = this.output.getItemStack();
    }

    @Override
    public String getPattern(RecipeHandler h) {
        String o = "shaped " + this.output.getQty() + ' ' + this.cols + 'x' + this.rows + '\n';
        o = o + h.getName(this.output) + '\n';
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                IIngredient i = this.inputs.get(y).get(x);
                o = i.isAir() ? o + "air" + (x + 1 == this.cols ? "\n" : " ") : o + h.getName(i) + (x + 1 == this.cols ? "\n" : " ");
            }
        }
        return o.trim();
    }

    @Override
    public boolean canCraft(ItemStack reqOutput) throws RegistrationException, MissingIngredientException {
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                IIngredient i = this.inputs.get(y).get(x);
                if (i.isAir()) continue;
                for (ItemStack r : i.getItemStackSet()) {
                    if (!Platform.itemComparisons().isSameItem(r, reqOutput)) continue;
                    return false;
                }
            }
        }
        return Platform.itemComparisons().isSameItem(this.output.getItemStack(), reqOutput);
    }
}

