/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.ores;

import appeng.core.AELog;
import appeng.recipes.game.IRecipeBakeable;
import appeng.recipes.ores.IOreListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHandler {
    public static final OreDictionaryHandler INSTANCE = new OreDictionaryHandler();
    private final List<IOreListener> oreListeners = new ArrayList<IOreListener>();
    private boolean enableRebaking = false;

    @SubscribeEvent
    public void onOreDictionaryRegister(OreDictionary.OreRegisterEvent event) {
        if (event.getName() == null || event.getOre().func_190926_b()) {
            return;
        }
        if (this.shouldCare(event.getName())) {
            for (IOreListener v : this.oreListeners) {
                v.oreRegistered(event.getName(), event.getOre());
            }
        }
        if (this.enableRebaking) {
            this.bakeRecipes();
        }
    }

    private boolean shouldCare(String name) {
        return true;
    }

    public void bakeRecipes() {
        this.enableRebaking = true;
        for (Object o : ForgeRegistries.RECIPES.getValues()) {
            if (!(o instanceof IRecipeBakeable)) continue;
            try {
                ((IRecipeBakeable)o).bake();
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
    }

    public void observe(IOreListener n) {
        this.oreListeners.add(n);
        for (String name : OreDictionary.getOreNames()) {
            if (name == null || !this.shouldCare(name)) continue;
            for (ItemStack item : OreDictionary.getOres((String)name)) {
                if (item.func_190926_b()) continue;
                n.oreRegistered(name, item);
            }
        }
    }
}

