/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.IInternalItemHandler;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AppEngInternalInventory
extends ItemStackHandler
implements IInternalItemHandler,
Iterable<ItemStack> {
    private boolean enableClientEvents = false;
    private IAEAppEngInventory te;
    private final int[] maxStack;
    private ItemStack previousStack = ItemStack.field_190927_a;
    private IAEItemFilter filter;
    private boolean dirtyFlag = false;

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size, int maxStack, IAEItemFilter filter) {
        super(size);
        this.setTileEntity(inventory);
        this.setFilter(filter);
        this.maxStack = new int[size];
        Arrays.fill(this.maxStack, maxStack);
    }

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size, int maxStack) {
        this(inventory, size, maxStack, null);
    }

    public AppEngInternalInventory(IAEAppEngInventory inventory, int size) {
        this(inventory, size, 64);
    }

    public void setFilter(IAEItemFilter filter) {
        this.filter = filter;
    }

    public int getSlotLimit(int slot) {
        return this.maxStack[slot];
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.previousStack = this.getStackInSlot(slot).func_77946_l();
        super.setStackInSlot(slot, stack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.filter != null && !this.filter.allowInsert((IItemHandler)this, slot, stack)) {
            return stack;
        }
        if (!simulate) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.filter != null && !this.filter.allowExtract((IItemHandler)this, slot, amount)) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        return super.extractItem(slot, amount, simulate);
    }

    protected void onContentsChanged(int slot) {
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            this.dirtyFlag = true;
            ItemStack newStack = this.getStackInSlot(slot).func_77946_l();
            ItemStack oldStack = this.previousStack;
            InvOperation op = InvOperation.SET;
            if (newStack.func_190926_b() || oldStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)newStack, (ItemStack)oldStack)) {
                if (newStack.func_190916_E() > oldStack.func_190916_E()) {
                    newStack.func_190918_g(oldStack.func_190916_E());
                    oldStack = ItemStack.field_190927_a;
                    op = InvOperation.INSERT;
                } else {
                    oldStack.func_190918_g(newStack.func_190916_E());
                    newStack = ItemStack.field_190927_a;
                    op = InvOperation.EXTRACT;
                }
            }
            this.getTileEntity().onChangeInventory((IItemHandler)this, slot, op, oldStack, newStack);
            this.getTileEntity().saveChanges();
            this.previousStack = ItemStack.field_190927_a;
            this.dirtyFlag = false;
        }
        super.onContentsChanged(slot);
    }

    protected boolean eventsEnabled() {
        return Platform.isServer() || this.isEnableClientEvents();
    }

    public void setMaxStackSize(int slot, int size) {
        this.maxStack[slot] = size;
    }

    @Override
    public void markDirty(int slot) {
        if (this.getTileEntity() != null && this.eventsEnabled() && !this.dirtyFlag) {
            this.dirtyFlag = true;
            this.getTileEntity().onChangeInventory((IItemHandler)this, slot, InvOperation.DIRTY, ItemStack.field_190927_a, ItemStack.field_190927_a);
            this.getTileEntity().saveChanges();
            this.dirtyFlag = false;
        }
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (this.maxStack[slot] == 0) {
            return false;
        }
        if (this.filter != null) {
            return this.filter.allowInsert((IItemHandler)this, slot, stack);
        }
        return true;
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        data.func_74782_a(name, (NBTBase)this.serializeNBT());
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.func_74775_l(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        this.deserializeNBT(data);
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return Collections.unmodifiableList(this.stacks).iterator();
    }

    private boolean isEnableClientEvents() {
        return this.enableClientEvents;
    }

    public void setEnableClientEvents(boolean enableClientEvents) {
        this.enableClientEvents = enableClientEvents;
    }

    private IAEAppEngInventory getTileEntity() {
        return this.te;
    }

    public void setTileEntity(IAEAppEngInventory te) {
        this.te = te;
    }
}

