/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MEMonitorHandler;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEFluidStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class TileChest
extends AENetworkPowerTile
implements IMEChest,
ITerminalHost,
IPriorityHost,
IConfigManagerHost,
IColorableTile,
ITickable {
    private static final ChestNoHandler NO_HANDLER = new ChestNoHandler();
    private final AppEngInternalInventory inputInventory = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory cellInventory = new AppEngInternalInventory(this, 1);
    private final IItemHandler internalInventory = new WrapperChainedItemHandler(new IItemHandler[]{this.inputInventory, this.cellInventory});
    private final IActionSource mySrc = new MachineSource(this);
    private final IConfigManager config = new ConfigManager(this);
    private ItemStack storageType = ItemStack.field_190927_a;
    private long lastStateChange = 0L;
    private int priority = 0;
    private int state = 0;
    private boolean wasActive = false;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isCached = false;
    private ICellHandler cellHandler;
    private MEMonitorHandler itemCell;
    private MEMonitorHandler fluidCell;
    private Accessor accessor;
    private IFluidHandler fluidHandler;

    public TileChest() {
        this.setInternalMaxPower(PowerMultiplier.CONFIG.multiply(40.0));
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.WRITE);
        this.inputInventory.setFilter(new InputInventoryFilter());
        this.cellInventory.setFilter(new CellInventoryFilter());
    }

    public ItemStack getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        if (x == MENetworkPowerStorage.PowerEventType.REQUEST_POWER) {
            try {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            this.recalculateDisplay();
        }
    }

    private void recalculateDisplay() {
        int oldState = this.state;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x) << 3 * x;
        }
        this.state = this.isPowered() ? (this.state |= 0x40) : (this.state &= 0xFFFFFFBF);
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (oldState != this.state) {
            this.markForUpdate();
        }
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    private IMEInventoryHandler getHandler(IStorageChannel channel) throws ChestNoHandler {
        if (!this.isCached) {
            this.itemCell = null;
            this.fluidCell = null;
            this.accessor = null;
            this.fluidHandler = null;
            ItemStack is = this.getCell();
            if (!is.func_190926_b()) {
                this.isCached = true;
                this.cellHandler = AEApi.instance().registries().cell().getHandler(is);
                if (this.cellHandler != null) {
                    double power = 1.0;
                    IMEInventoryHandler<IAEItemStack> itemCell = this.cellHandler.getCellInventory(is, this, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                    IMEInventoryHandler<IAEFluidStack> fluidCell = this.cellHandler.getCellInventory(is, this, AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                    if (itemCell != null) {
                        power += this.cellHandler.cellIdleDrain(is, itemCell);
                    } else if (fluidCell != null) {
                        power += this.cellHandler.cellIdleDrain(is, fluidCell);
                    }
                    this.getProxy().setIdlePowerUsage(power);
                    this.itemCell = this.wrap(itemCell);
                    this.fluidCell = this.wrap(fluidCell);
                    if (this.itemCell != null) {
                        // empty if block
                    }
                    this.accessor = new Accessor();
                    if (this.fluidCell != null) {
                        this.fluidHandler = new FluidHandler();
                    }
                }
            }
        }
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            if (this.itemCell == null) {
                throw NO_HANDLER;
            }
            return this.itemCell;
        }
        if (channel == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class) && this.fluidCell != null) {
            if (this.fluidCell == null) {
                throw NO_HANDLER;
            }
            return this.fluidCell;
        }
        return null;
    }

    private <T extends IAEStack<T>> MEMonitorHandler<T> wrap(IMEInventoryHandler<T> h) {
        if (h == null) {
            return null;
        }
        MEInventoryHandler<T> ih = new MEInventoryHandler<T>(h, h.getChannel());
        ih.setPriority(this.priority);
        ChestMonitorHandler g = new ChestMonitorHandler(ih);
        g.addListener(new ChestNetNotifier(h.getChannel()), g);
        return g;
    }

    @Override
    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            return this.state >> slot * 3 & 3;
        }
        ItemStack cell = this.getCell();
        ICellHandler ch = AEApi.instance().registries().cell().getHandler(cell);
        if (ch != null) {
            IMEInventoryHandler handler2;
            try {
                handler2 = this.getHandler(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                if (handler2 instanceof ChestMonitorHandler) {
                    return ch.getStatusForCell(cell, ((ChestMonitorHandler)handler2).getInternalHandler());
                }
            }
            catch (ChestNoHandler handler2) {
                // empty catch block
            }
            try {
                handler2 = this.getHandler(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                if (handler2 instanceof ChestMonitorHandler) {
                    return ch.getStatusForCell(cell, ((ChestMonitorHandler)handler2).getInternalHandler());
                }
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public boolean isPowered() {
        boolean gridPowered;
        if (Platform.isClient()) {
            return (this.state & 0x40) == 64;
        }
        boolean bl = gridPowered = this.getAECurrentPower() > 64.0;
        if (!gridPowered) {
            try {
                gridPowered = this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return super.getAECurrentPower() > 1.0 || gridPowered;
    }

    @Override
    public boolean isCellBlinking(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            return false;
        }
        return (this.state >> slot * 3 + 2 & 1) == 1;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        double stash = 0.0;
        try {
            IEnergyGrid eg = this.getProxy().getEnergy();
            stash = eg.extractAEPower(amt, mode, PowerMultiplier.ONE);
            if (stash >= amt) {
                return stash;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    public void func_73660_a() {
        block5: {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            double idleUsage = this.getProxy().getIdlePowerUsage();
            try {
                double powerUsed;
                if (!this.getProxy().getEnergy().isNetworkPowered() && (powerUsed = this.extractAEPower(idleUsage, Actionable.MODULATE, PowerMultiplier.CONFIG)) + 0.1 >= idleUsage != (this.state & 0x40) > 0) {
                    this.recalculateDisplay();
                }
            }
            catch (GridAccessException e) {
                double powerUsed = this.extractAEPower(this.getProxy().getIdlePowerUsage(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                if (powerUsed + 0.1 >= idleUsage == (this.state & 0x40) > 0) break block5;
                this.recalculateDisplay();
            }
        }
        if (!ItemHandlerUtil.isEmpty((IItemHandler)this.inputInventory)) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.state = this.field_145850_b.func_82737_E() - this.lastStateChange > 8L ? 0 : (this.state &= 0x24924924);
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x) << 3 * x;
        }
        this.state = this.isPowered() ? (this.state |= 0x40) : (this.state &= 0xFFFFFFBF);
        data.writeByte(this.state);
        data.writeByte(this.paintedColor.ordinal());
        ItemStack is = this.getCell();
        if (is.func_190926_b()) {
            data.writeInt(0);
        } else {
            data.writeInt(is.func_77952_i() << 16 | Item.func_150891_b((Item)is.func_77973_b()));
        }
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        ItemStack oldType = this.storageType;
        this.state = data.readByte();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        int item = data.readInt();
        this.storageType = item == 0 ? ItemStack.field_190927_a : new ItemStack(Item.func_150899_d((int)(item & 0xFFFF)), 1, item >> 16);
        this.lastStateChange = this.field_145850_b.func_82737_E();
        return oldPaintedColor != this.paintedColor || (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB) || !Platform.itemComparisons().isSameItem(oldType, this.storageType) || c;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.config.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
        if (data.func_74764_b("paintedColor")) {
            this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.config.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        data.func_74774_a("paintedColor", (byte)this.paintedColor.ordinal());
        return data;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return this.itemCell;
        }
        if (channel == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
            return this.fluidCell;
        }
        return null;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.cellInventory) {
            this.itemCell = null;
            this.fluidCell = null;
            this.isCached = false;
            try {
                this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
                IStorageGrid gs = this.getProxy().getStorage();
                Platform.postChanges(gs, removed, added, this.mySrc);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            if (this.field_145850_b != null) {
                Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
                this.markForUpdate();
            }
        }
        if (inv == this.inputInventory && mc == InvOperation.INSERT) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected IItemHandler getItemHandlerForSide(@Nonnull EnumFacing side) {
        if (side == this.getForward()) {
            return this.cellInventory;
        }
        return this.inputInventory;
    }

    private void tryToStoreContents() {
        try {
            if (!ItemHandlerUtil.isEmpty((IItemHandler)this.inputInventory)) {
                IMEInventoryHandler cell = this.getHandler(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IAEItemStack returns = (IAEItemStack)Platform.poweredInsert(this, cell, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(this.inputInventory.getStackInSlot(0)), this.mySrc);
                if (returns == null) {
                    this.inputInventory.setStackInSlot(0, ItemStack.field_190927_a);
                } else {
                    this.inputInventory.setStackInSlot(0, returns.createItemStack());
                }
            }
        }
        catch (ChestNoHandler chestNoHandler) {
            // empty catch block
        }
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (this.getProxy().isActive()) {
            try {
                IMEInventoryHandler handler = this.getHandler(channel);
                if (handler != null) {
                    return Collections.singletonList(handler);
                }
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.itemCell = null;
        this.fluidCell = null;
        this.isCached = false;
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void blinkCell(int slot) {
        long now = this.field_145850_b.func_82737_E();
        if (now - this.lastStateChange > 8L) {
            this.state = 0;
        }
        this.lastStateChange = now;
        this.state |= 1 << slot * 3 + 2;
        this.recalculateDisplay();
    }

    public ItemStack getStorageType() {
        if (this.isPowered()) {
            return this.storageType;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public boolean openGui(EntityPlayer p, ICellHandler ch, ItemStack cell, EnumFacing side) {
        IMEInventoryHandler invHandler2;
        try {
            invHandler2 = this.getHandler(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            if (ch != null && invHandler2 != null) {
                ch.openChestGui(p, this, ch, invHandler2, cell, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                return true;
            }
        }
        catch (ChestNoHandler invHandler2) {
            // empty catch block
        }
        try {
            invHandler2 = this.getHandler(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            if (ch != null && invHandler2 != null) {
                ch.openChestGui(p, this, ch, invHandler2, cell, AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                return true;
            }
        }
        catch (ChestNoHandler chestNoHandler) {
            // empty catch block
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(EnumFacing side, AEColor newPaintedColor, EntityPlayer who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.func_70296_d();
        this.markForUpdate();
        return true;
    }

    public void saveChanges(IMEInventory cellInventory) {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.fluidHandler != null && facing != this.getForward()) {
            return true;
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR && this.accessor != null && facing != this.getForward()) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.fluidHandler != null && facing != this.getForward()) {
            return (T)this.fluidHandler;
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR && this.accessor != null && facing != this.getForward()) {
            return (T)this.accessor;
        }
        return super.getCapability(capability, facing);
    }

    private class CellInventoryFilter
    implements IAEItemFilter {
        private CellInventoryFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return AEApi.instance().registries().cell().getCellInventory(stack, TileChest.this, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) != null || AEApi.instance().registries().cell().getCellInventory(stack, TileChest.this, AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) != null;
        }
    }

    private class InputInventoryFilter
    implements IAEItemFilter {
        private InputInventoryFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return false;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            if (TileChest.this.isPowered()) {
                try {
                    IMEInventoryHandler cell = TileChest.this.getHandler(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                    if (cell != null) {
                        IAEItemStack returns = (IAEItemStack)cell.injectItems(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(stack), Actionable.SIMULATE, TileChest.this.mySrc);
                        return returns == null || returns.getStackSize() != (long)stack.func_190916_E();
                    }
                }
                catch (ChestNoHandler chestNoHandler) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public int fill(FluidStack resource, boolean doFill) {
            double req = (double)resource.amount / 500.0;
            double available = TileChest.this.extractAEPower(req, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            if (available >= req - 0.01) {
                try {
                    IMEInventoryHandler h = TileChest.this.getHandler(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                    TileChest.this.extractAEPower(req, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    AEFluidStack results = h.injectItems(AEFluidStack.fromFluidStack(resource), doFill ? Actionable.MODULATE : Actionable.SIMULATE, TileChest.this.mySrc);
                    if (results == null) {
                        return resource.amount;
                    }
                    return resource.amount - (int)results.getStackSize();
                }
                catch (ChestNoHandler chestNoHandler) {
                    // empty catch block
                }
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            try {
                IMEInventoryHandler h = TileChest.this.getHandler(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                if (h.getChannel() == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                    return new IFluidTankProperties[]{new FluidTankProperties(null, 1)};
                }
            }
            catch (ChestNoHandler chestNoHandler) {
                // empty catch block
            }
            return null;
        }
    }

    private class Accessor
    implements IStorageMonitorableAccessor {
        private Accessor() {
        }

        @Override
        @Nullable
        public IStorageMonitorable getInventory(IActionSource src) {
            if (Platform.canAccess(TileChest.this.getProxy(), src)) {
                return TileChest.this;
            }
            return null;
        }
    }

    private class ChestMonitorHandler<T extends IAEStack<T>>
    extends MEMonitorHandler<T> {
        public ChestMonitorHandler(IMEInventoryHandler<T> t) {
            super(t);
        }

        private IMEInventoryHandler<T> getInternalHandler() {
            IMEInventoryHandler h = this.getHandler();
            if (h instanceof MEInventoryHandler) {
                return (IMEInventoryHandler)((MEInventoryHandler)h).getInternal();
            }
            return this.getHandler();
        }

        @Override
        public T injectItems(T input, Actionable mode, IActionSource src) {
            if (src.player().map(player -> !this.securityCheck((EntityPlayer)player, SecurityPermissions.INJECT)).orElse(false).booleanValue()) {
                return input;
            }
            return super.injectItems(input, mode, src);
        }

        private boolean securityCheck(EntityPlayer player, SecurityPermissions requiredPermission) {
            if (TileChest.this.getTile() instanceof IActionHost && requiredPermission != null) {
                IGrid g;
                IGridNode gn = ((IActionHost)TileChest.this.getTile()).getActionableNode();
                if (gn != null && (g = gn.getGrid()) != null) {
                    boolean requirePower = false;
                    ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
                    if (sg.hasPermission(player, requiredPermission)) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public T extractItems(T request, Actionable mode, IActionSource src) {
            if (src.player().map(player -> !this.securityCheck((EntityPlayer)player, SecurityPermissions.EXTRACT)).orElse(false).booleanValue()) {
                return null;
            }
            return super.extractItems(request, mode, src);
        }
    }

    private class ChestNetNotifier<T extends IAEStack<T>>
    implements IMEMonitorHandlerReceiver<T> {
        private final IStorageChannel chan;

        public ChestNetNotifier(IStorageChannel chan) {
            this.chan = chan;
        }

        @Override
        public boolean isValid(Object verificationToken) {
            if (this.chan == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
                return verificationToken == TileChest.this.itemCell;
            }
            if (this.chan == AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)) {
                return verificationToken == TileChest.this.fluidCell;
            }
            return false;
        }

        @Override
        public void postChange(IBaseMonitor<T> monitor, Iterable<T> change, IActionSource source) {
            if (source == TileChest.this.mySrc || source.machine().map(machine -> machine == TileChest.this).orElse(false).booleanValue()) {
                try {
                    if (TileChest.this.getProxy().isActive()) {
                        TileChest.this.getProxy().getStorage().postAlterationOfStoredItems(this.chan, change, TileChest.this.mySrc);
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
            TileChest.this.blinkCell(0);
        }

        @Override
        public void onListUpdate() {
        }
    }

    private static class ChestNoHandler
    extends Exception {
        private static final long serialVersionUID = 7995805326136526631L;

        private ChestNoHandler() {
        }
    }
}

