/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.automation.BlockUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.AEItemFilters;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TileIOPort
extends AENetworkInvTile
implements IUpgradeableHost,
IConfigManagerHost,
IGridTickable {
    private final ConfigManager manager;
    private final AppEngInternalInventory inputCells = new AppEngInternalInventory(this, 6);
    private final AppEngInternalInventory outputCells = new AppEngInternalInventory(this, 6);
    private final IItemHandler combinedInventory = new WrapperChainedItemHandler(new IItemHandler[]{this.inputCells, this.outputCells});
    private final IItemHandler inputCellsExt = new WrapperFilteredItemHandler((IItemHandler)this.inputCells, AEItemFilters.INSERT_ONLY);
    private final IItemHandler outputCellsExt = new WrapperFilteredItemHandler((IItemHandler)this.outputCells, AEItemFilters.EXTRACT_ONLY);
    private final UpgradeInventory upgrades;
    private final IActionSource mySrc;
    private YesNo lastRedstoneState;
    private ItemStack currentCell;
    private IMEInventory<IAEFluidStack> cachedFluid;
    private IMEInventory<IAEItemStack> cachedItem;

    public TileIOPort() {
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.manager = new ConfigManager(this);
        this.manager.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.manager.registerSetting(Settings.FULLNESS_MODE, (Enum)FullnessMode.EMPTY);
        this.manager.registerSetting(Settings.OPERATION_MODE, (Enum)OperationMode.EMPTY);
        this.mySrc = new MachineSource(this);
        this.lastRedstoneState = YesNo.UNDECIDED;
        Block ioPortBlock = AEApi.instance().definitions().blocks().iOPort().maybeBlock().get();
        this.upgrades = new BlockUpgradeInventory(ioPortBlock, this, 3);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.manager.writeToNBT(data);
        this.upgrades.writeToNBT(data, "upgrades");
        data.func_74768_a("lastRedstoneState", this.lastRedstoneState.ordinal());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.manager.readFromNBT(data);
        this.upgrades.readFromNBT(data, "upgrades");
        if (data.func_74764_b("lastRedstoneState")) {
            this.lastRedstoneState = YesNo.values()[data.func_74762_e("lastRedstoneState")];
        }
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    private void updateTask() {
        try {
            if (this.hasWork()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.field_145850_b.func_175687_A(this.field_174879_c) != 0 ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            this.updateTask();
        }
    }

    private boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    private boolean isEnabled() {
        if (this.getInstalledUpgrades(Upgrades.REDSTONE) == 0) {
            return true;
        }
        RedstoneMode rs = (RedstoneMode)this.manager.getSetting(Settings.REDSTONE_CONTROLLED);
        if (rs == RedstoneMode.HIGH_SIGNAL) {
            return this.getRedstoneState();
        }
        return !this.getRedstoneState();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        if (name.equals("cells")) {
            return this.combinedInventory;
        }
        return null;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.updateTask();
    }

    private boolean hasWork() {
        if (this.isEnabled()) {
            return !ItemHandlerUtil.isEmpty((IItemHandler)this.inputCells);
        }
        return false;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.combinedInventory;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.inputCells == inv) {
            this.updateTask();
        }
    }

    @Override
    protected IItemHandler getItemHandlerForSide(EnumFacing facing) {
        if (facing == this.getUp() || facing == this.getUp().func_176734_d()) {
            return this.inputCellsExt;
        }
        return this.outputCellsExt;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.IOPort.getMin(), TickRates.IOPort.getMax(), this.hasWork(), false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isActive()) {
            return TickRateModulation.IDLE;
        }
        long ItemsToMove = 256L;
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            case 1: {
                ItemsToMove *= 2L;
                break;
            }
            case 2: {
                ItemsToMove *= 4L;
                break;
            }
            case 3: {
                ItemsToMove *= 8L;
            }
        }
        try {
            IMEMonitor<IAEItemStack> itemNet = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IMEMonitor<IAEFluidStack> fluidNet = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            IEnergyGrid energy = this.getProxy().getEnergy();
            for (int x = 0; x < 6; ++x) {
                ItemStack is = this.inputCells.getStackInSlot(x);
                if (is.func_190926_b()) continue;
                if (ItemsToMove > 0L) {
                    IMEInventory itemInv = this.getInv(is, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                    IMEInventory fluidInv = this.getInv(is, AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                    if (this.manager.getSetting(Settings.OPERATION_MODE) == OperationMode.EMPTY) {
                        if (itemInv != null) {
                            ItemsToMove = this.transferContents(energy, itemInv, itemNet, ItemsToMove, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                        }
                        if (fluidInv != null) {
                            ItemsToMove = this.transferContents(energy, fluidInv, fluidNet, ItemsToMove, AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                        }
                    } else {
                        if (itemInv != null) {
                            ItemsToMove = this.transferContents(energy, itemNet, itemInv, ItemsToMove, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                        }
                        if (fluidInv != null) {
                            ItemsToMove = this.transferContents(energy, fluidNet, fluidInv, ItemsToMove, AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
                        }
                    }
                    if (ItemsToMove > 0L && this.shouldMove(itemInv, fluidInv) && !this.moveSlot(x)) {
                        return TickRateModulation.IDLE;
                    }
                    return TickRateModulation.URGENT;
                }
                return TickRateModulation.URGENT;
            }
        }
        catch (GridAccessException e) {
            return TickRateModulation.IDLE;
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    private IMEInventory getInv(ItemStack is, IStorageChannel chan) {
        if (this.currentCell != is) {
            this.currentCell = is;
            this.cachedFluid = AEApi.instance().registries().cell().getCellInventory(is, null, AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            this.cachedItem = AEApi.instance().registries().cell().getCellInventory(is, null, AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
        }
        if (AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class) == chan) {
            return this.cachedItem;
        }
        return this.cachedFluid;
    }

    private long transferContents(IEnergySource energy, IMEInventory src, IMEInventory destination, long itemsToMove, IStorageChannel chan) {
        boolean didStuff;
        IItemList myList = src instanceof IMEMonitor ? ((IMEMonitor)src).getStorageList() : src.getAvailableItems(src.getChannel().createList());
        block0: do {
            didStuff = false;
            for (IAEStack s : myList) {
                long totalStackSize = s.getStackSize();
                if (totalStackSize <= 0L) continue;
                IAEStack stack = destination.injectItems(s, Actionable.SIMULATE, this.mySrc);
                long possible = 0L;
                possible = stack == null ? totalStackSize : totalStackSize - stack.getStackSize();
                if (possible <= 0L) continue;
                possible = Math.min(possible, itemsToMove);
                s.setStackSize(possible);
                IAEStack extracted = src.extractItems(s, Actionable.MODULATE, this.mySrc);
                if (extracted == null) continue;
                possible = extracted.getStackSize();
                IAEStack failed = Platform.poweredInsert(energy, destination, extracted, this.mySrc);
                if (failed != null) {
                    possible -= failed.getStackSize();
                    src.injectItems(failed, Actionable.MODULATE, this.mySrc);
                }
                if (possible <= 0L) continue block0;
                itemsToMove -= possible;
                didStuff = true;
                continue block0;
            }
        } while (itemsToMove > 0L && didStuff);
        return itemsToMove;
    }

    private boolean shouldMove(IMEInventory<IAEItemStack> itemInv, IMEInventory<IAEFluidStack> fluidInv) {
        FullnessMode fm = (FullnessMode)this.manager.getSetting(Settings.FULLNESS_MODE);
        if (itemInv != null && fluidInv != null) {
            return this.matches(fm, itemInv) && this.matches(fm, fluidInv);
        }
        if (itemInv != null) {
            return this.matches(fm, itemInv);
        }
        if (fluidInv != null) {
            return this.matches(fm, fluidInv);
        }
        return true;
    }

    private boolean moveSlot(int x) {
        AdaptorItemHandler ad = new AdaptorItemHandler((IItemHandler)this.outputCells);
        if (((InventoryAdaptor)ad).addItems(this.inputCells.getStackInSlot(x)).func_190926_b()) {
            this.inputCells.setStackInSlot(x, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    private boolean matches(FullnessMode fm, IMEInventory src) {
        if (fm == FullnessMode.HALF) {
            return true;
        }
        IItemList myList = src instanceof IMEMonitor ? ((IMEMonitor)src).getStorageList() : src.getAvailableItems(src.getChannel().createList());
        if (fm == FullnessMode.EMPTY) {
            return myList.isEmpty();
        }
        Object test = myList.getFirstItem();
        if (test != null) {
            test.setStackSize(1L);
            return src.injectItems(test, Actionable.SIMULATE, this.mySrc) != null;
        }
        return false;
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        for (int upgradeIndex = 0; upgradeIndex < this.upgrades.getSlots(); ++upgradeIndex) {
            ItemStack stackInSlot = this.upgrades.getStackInSlot(upgradeIndex);
            if (stackInSlot.func_190926_b()) continue;
            drops.add(stackInSlot);
        }
    }
}

