/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.Platform;
import appeng.util.item.AEItemStackRegistry;
import appeng.util.item.AESharedItemStack;
import appeng.util.item.AEStack;
import appeng.util.item.OreHelper;
import appeng.util.item.OreReference;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public final class AEItemStack
extends AEStack<IAEItemStack>
implements IAEItemStack {
    private AESharedItemStack sharedStack;
    private Optional<OreReference> oreReference;
    @SideOnly(value=Side.CLIENT)
    private String displayName;
    @SideOnly(value=Side.CLIENT)
    private List<String> tooltip;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation uniqueID;

    private AEItemStack(AEItemStack is) {
        this.setStackSize(is.getStackSize());
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
        this.sharedStack = is.sharedStack;
        this.oreReference = is.oreReference;
    }

    private AEItemStack(AESharedItemStack is, long size) {
        this.sharedStack = is;
        this.setStackSize(size);
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.oreReference = OreHelper.INSTANCE.getOre(is.getDefinition());
    }

    @Nullable
    public static AEItemStack fromItemStack(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return new AEItemStack(AEItemStackRegistry.getRegisteredStack(stack), stack.func_190916_E());
    }

    public static IAEItemStack fromNBT(NBTTagCompound i) {
        if (i == null) {
            return null;
        }
        ItemStack itemstack = new ItemStack(i);
        if (itemstack.func_190926_b()) {
            return null;
        }
        AEItemStack item = AEItemStack.fromItemStack(itemstack);
        item.setStackSize(i.func_74763_f("Cnt"));
        item.setCountRequestable(i.func_74763_f("Req"));
        item.setCraftable(i.func_74767_n("Craft"));
        return item;
    }

    @Override
    public void writeToNBT(NBTTagCompound i) {
        this.getDefinition().func_77955_b(i);
        i.func_74772_a("Cnt", this.getStackSize());
        i.func_74772_a("Req", this.getCountRequestable());
        i.func_74757_a("Craft", this.isCraftable());
    }

    public static AEItemStack fromPacket(ByteBuf data) {
        byte mask = data.readByte();
        byte stackType = (byte)((mask & 0xC) >> 2);
        byte countReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        ItemStack itemstack = new ItemStack(ByteBufUtils.readTag((ByteBuf)data));
        long stackSize = AEItemStack.getPacketValue(stackType, data);
        long countRequestable = AEItemStack.getPacketValue(countReqType, data);
        if (itemstack.func_190926_b()) {
            return null;
        }
        AEItemStack item = new AEItemStack(AEItemStackRegistry.getRegisteredStack(itemstack), stackSize);
        item.setCountRequestable(countRequestable);
        item.setCraftable(isCraftable);
        return item;
    }

    @Override
    public void writeToPacket(ByteBuf i) {
        byte mask = (byte)(this.getType(this.getStackSize()) << 2 | this.getType(this.getCountRequestable()) << 4 | (byte)(this.isCraftable() ? 1 : 0) << 6 | (this.hasTagCompound() ? 1 : 0) << 7);
        i.writeByte((int)mask);
        ByteBufUtils.writeTag((ByteBuf)i, (NBTTagCompound)this.getDefinition().serializeNBT());
        this.putPacketValue(i, this.getStackSize());
        this.putPacketValue(i, this.getCountRequestable());
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    @Override
    public boolean fuzzyComparison(Object st, FuzzyMode mode) {
        IAEItemStack o;
        if (st instanceof IAEItemStack) {
            o = (IAEItemStack)st;
            if (this.sameOre(o)) {
                return true;
            }
            if (o.getItem() == this.getItem()) {
                if (this.getDefinition().func_77973_b().func_77645_m()) {
                    ItemStack a = this.getDefinition();
                    ItemStack b = o.getDefinition();
                    try {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            Item ai = a.func_77973_b();
                            Item bi = b.func_77973_b();
                            return ai.getDurabilityForDisplay(a) < (double)0.001f == bi.getDurabilityForDisplay(b) < (double)0.001f;
                        }
                        Item ai = a.func_77973_b();
                        Item bi = b.func_77973_b();
                        float percentDamageOfA = 1.0f - (float)ai.getDurabilityForDisplay(a);
                        float percentDamageOfB = 1.0f - (float)bi.getDurabilityForDisplay(b);
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                        }
                        float percentDamageOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
                        float percentDamageOfB = (float)b.func_77952_i() / (float)b.func_77958_k();
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.getItemDamage();
            }
        }
        if (st instanceof ItemStack) {
            o = (ItemStack)st;
            OreHelper.INSTANCE.sameOre(this, (ItemStack)o);
            if (o.func_77973_b() == this.getItem()) {
                if (this.getDefinition().func_77973_b().func_77645_m()) {
                    ItemStack a = this.getDefinition();
                    try {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            Item ai = a.func_77973_b();
                            Item bi = o.func_77973_b();
                            return ai.getDurabilityForDisplay(a) < (double)0.001f == bi.getDurabilityForDisplay((ItemStack)o) < (double)0.001f;
                        }
                        Item ai = a.func_77973_b();
                        Item bi = o.func_77973_b();
                        float percentDamageOfA = 1.0f - (float)ai.getDurabilityForDisplay(a);
                        float percentDamageOfB = 1.0f - (float)bi.getDurabilityForDisplay((ItemStack)o);
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == o.func_77952_i() > 1;
                        }
                        float percentDamageOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
                        float percentDamageOfB = (float)o.func_77952_i() / (float)o.func_77958_k();
                        return percentDamageOfA > mode.breakPoint == percentDamageOfB > mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.func_77952_i();
            }
        }
        return false;
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public boolean isItem() {
        return true;
    }

    @Override
    public boolean isFluid() {
        return false;
    }

    @Override
    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public ItemStack createItemStack() {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)this.getDefinition(), (int)((int)Math.min(Integer.MAX_VALUE, this.getStackSize())));
    }

    @Override
    public Item getItem() {
        return this.getDefinition().func_77973_b();
    }

    @Override
    public int getItemDamage() {
        return this.sharedStack.getItemDamage();
    }

    @Override
    public boolean sameOre(IAEItemStack is) {
        return OreHelper.INSTANCE.sameOre(this, is);
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return Objects.equals(this.sharedStack, ((AEItemStack)otherStack).sharedStack);
    }

    @Override
    public boolean isSameType(ItemStack otherStack) {
        if (otherStack.func_190926_b()) {
            return false;
        }
        int oldSize = otherStack.func_190916_E();
        otherStack.func_190920_e(1);
        boolean ret = ItemStack.func_77989_b((ItemStack)this.getDefinition(), (ItemStack)otherStack);
        otherStack.func_190920_e(oldSize);
        return ret;
    }

    public int hashCode() {
        return this.sharedStack.hashCode();
    }

    @Override
    public boolean equals(Object ia) {
        if (ia instanceof AEItemStack) {
            return this.isSameType((AEItemStack)ia);
        }
        if (ia instanceof ItemStack) {
            return this.isSameType((ItemStack)ia);
        }
        return false;
    }

    public String toString() {
        return this.getDefinition().toString();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getToolTip() {
        if (this.tooltip == null) {
            this.tooltip = Platform.getTooltip(this.asItemStackRepresentation());
        }
        return this.tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Platform.getItemDisplayName(this.asItemStackRepresentation());
        }
        return this.displayName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getModID() {
        if (this.uniqueID == null) {
            this.uniqueID = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.getDefinition().func_77973_b());
        }
        if (this.uniqueID == null) {
            return "** Null";
        }
        return this.uniqueID.func_110624_b() == null ? "** Null" : this.uniqueID.func_110624_b();
    }

    public Optional<OreReference> getOre() {
        return this.oreReference;
    }

    @Override
    public boolean hasTagCompound() {
        return this.getDefinition().func_77942_o();
    }

    @Override
    public ItemStack asItemStackRepresentation() {
        return this.getDefinition().func_77946_l();
    }

    @Override
    public ItemStack getDefinition() {
        return this.sharedStack.getDefinition();
    }

    AESharedItemStack getSharedStack() {
        return this.sharedStack;
    }
}

