/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.debug.CompareVanilla;
import slimeknights.tconstruct.debug.DamageTool;
import slimeknights.tconstruct.debug.DumpMaterialTest;
import slimeknights.tconstruct.debug.FindBestTool;
import slimeknights.tconstruct.debug.GenValidModifiers;
import slimeknights.tconstruct.debug.GetToolGrowth;
import slimeknights.tconstruct.debug.ListValidModifiers;
import slimeknights.tconstruct.debug.LocalizationCheckCommand;
import slimeknights.tconstruct.debug.ReloadResources;
import slimeknights.tconstruct.debug.TestTool;
import slimeknights.tconstruct.debug.TextureDump;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.utils.ListUtil;

@Pulse(id="TinkerDebug", description="Debug utilities", defaultEnable=false)
public class TinkerDebug {
    public static final String PulseId = "TinkerDebug";
    static final Logger log = Util.getLogger("TinkerDebug");

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (Config.dumpTextureMap) {
            MinecraftForge.EVENT_BUS.register((Object)new TextureDump());
        }
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new ReloadResources());
        }
    }

    @Subscribe
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new DamageTool());
        event.registerServerCommand((ICommand)new TestTool());
        event.registerServerCommand((ICommand)new GenValidModifiers());
        if (event.getSide().isClient()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new LocalizationCheckCommand());
            ClientCommandHandler.instance.func_71560_a((ICommand)new DumpMaterialTest());
            ClientCommandHandler.instance.func_71560_a((ICommand)new FindBestTool());
            ClientCommandHandler.instance.func_71560_a((ICommand)new GetToolGrowth());
            ClientCommandHandler.instance.func_71560_a((ICommand)new CompareVanilla());
            ClientCommandHandler.instance.func_71560_a((ICommand)new ListValidModifiers());
        }
        TinkerDebug.sanityCheck();
    }

    public static void sanityCheck() {
        int i;
        for (IModifier iModifier : TinkerRegistry.getAllModifiers()) {
            try {
                iModifier.matches(ListUtil.getListFrom(new ItemStack(Items.field_151055_y)));
                iModifier.matches((NonNullList<ItemStack>)NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a));
            }
            catch (Exception e) {
                log.error("Caught exception in modifier " + iModifier.getIdentifier(), (Throwable)e);
            }
        }
        for (ResourceLocation resourceLocation : Block.field_149771_c.func_148742_b()) {
            if (!resourceLocation.func_110624_b().equals(Util.RESOURCE)) continue;
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)resourceLocation);
            for (i = 0; i < 16; ++i) {
                try {
                    IBlockState state = block.func_176203_a(i);
                    state.func_177230_c().func_176201_c(state);
                    continue;
                }
                catch (Exception e) {
                    log.error("Caught exception when checking block " + resourceLocation + ":" + i, (Throwable)e);
                }
            }
        }
        for (ResourceLocation resourceLocation : Item.field_150901_e.func_148742_b()) {
            if (!resourceLocation.func_110624_b().equals(Util.RESOURCE)) continue;
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation);
            for (i = 0; i < Short.MAX_VALUE; ++i) {
                try {
                    item.func_77647_b(i);
                    continue;
                }
                catch (Exception e) {
                    log.error("Caught exception when checking item " + resourceLocation + ":" + i, (Throwable)e);
                }
            }
        }
        for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
            String name;
            if (entry.getKey() == null || ((String)entry.getKey()).isEmpty()) {
                log.error("Fluid " + ((Fluid)entry.getValue()).getUnlocalizedName() + " has an empty name registered!");
            }
            if ((name = FluidRegistry.getFluidName((Fluid)((Fluid)entry.getValue()))) != null && !name.isEmpty()) continue;
            log.error("Fluid " + ((Fluid)entry.getValue()).getUnlocalizedName() + " is registered with an empty name!");
        }
        log.info("Sanity Check Complete");
    }
}

