/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.library.utils.ListUtil;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.client.SmelteryRenderer;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidClicked;

public class GuiUtil {
    protected static Minecraft mc = Minecraft.func_71410_x();
    private static Map<Fluid, List<FluidGuiEntry>> fluidGui = Maps.newHashMap();
    private static boolean smelteryLoaded = TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");

    private GuiUtil() {
    }

    public static void renderTiledTextureAtlas(int x, int y, int width, int height, float depth, TextureAtlasSprite sprite) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GuiUtil.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GuiUtil.putTiledTextureQuads(worldrenderer, x, y, width, height, depth, sprite);
        tessellator.func_78381_a();
    }

    public static void renderTiledFluid(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        TextureAtlasSprite fluidSprite = mc.func_147117_R().func_110572_b(fluidStack.getFluid().getStill(fluidStack).toString());
        RenderUtil.setColorRGBA(fluidStack.getFluid().getColor(fluidStack));
        GuiUtil.renderTiledTextureAtlas(x, y, width, height, depth, fluidSprite);
    }

    public static void putTiledTextureQuads(BufferBuilder renderer, int x, int y, int width, int height, float depth, TextureAtlasSprite sprite) {
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        do {
            int renderHeight = Math.min(sprite.func_94216_b(), height);
            height -= renderHeight;
            float v2 = sprite.func_94207_b((double)(16.0f * (float)renderHeight / (float)sprite.func_94216_b()));
            int x2 = x;
            int width2 = width;
            do {
                int renderWidth = Math.min(sprite.func_94211_a(), width2);
                width2 -= renderWidth;
                float u2 = sprite.func_94214_a((double)(16.0f * (float)renderWidth / (float)sprite.func_94211_a()));
                renderer.func_181662_b((double)x2, (double)y, (double)depth).func_187315_a((double)u1, (double)v1).func_181675_d();
                renderer.func_181662_b((double)x2, (double)(y + renderHeight), (double)depth).func_187315_a((double)u1, (double)v2).func_181675_d();
                renderer.func_181662_b((double)(x2 + renderWidth), (double)(y + renderHeight), (double)depth).func_187315_a((double)u2, (double)v2).func_181675_d();
                renderer.func_181662_b((double)(x2 + renderWidth), (double)y, (double)depth).func_187315_a((double)u2, (double)v1).func_181675_d();
                x2 += renderWidth;
            } while (width2 > 0);
            y += renderHeight;
        } while (height > 0);
    }

    @Deprecated
    public static List<String> drawTankTooltip(SmelteryTank tank, int mouseX, int mouseY, int xmin, int ymin, int xmax, int ymax) {
        return GuiUtil.getTankTooltip(tank, mouseX, mouseY, xmin, ymin, xmax, ymax);
    }

    public static List<String> getTankTooltip(SmelteryTank tank, int mouseX, int mouseY, int xmin, int ymin, int xmax, int ymax) {
        if (xmin <= mouseX && mouseX < xmax && ymin <= mouseY && mouseY < ymax) {
            Consumer<Integer> stringFn;
            FluidStack hovered = GuiUtil.getFluidHovered(tank, ymax - mouseY - 1, ymax - ymin);
            ArrayList text = Lists.newArrayList();
            Consumer<Integer> consumer = stringFn = Util.isShiftKeyDown() ? i -> GuiUtil.amountToString(i, text) : i -> GuiUtil.amountToIngotString(i, text);
            if (hovered == null) {
                int usedCap = tank.getFluidAmount();
                int maxCap = tank.getCapacity();
                text.add(TextFormatting.WHITE + Util.translate("gui.smeltery.capacity", new Object[0]));
                stringFn.accept(maxCap);
                text.add(Util.translateFormatted("gui.smeltery.capacity_available", new Object[0]));
                stringFn.accept(maxCap - usedCap);
                text.add(Util.translateFormatted("gui.smeltery.capacity_used", new Object[0]));
                stringFn.accept(usedCap);
                if (!Util.isShiftKeyDown()) {
                    text.add("");
                    text.add(Util.translate("tooltip.tank.holdShift", new Object[0]));
                }
            } else {
                text.add(TextFormatting.WHITE + hovered.getLocalizedName());
                GuiUtil.liquidToString(hovered, text);
            }
            return text;
        }
        return null;
    }

    private static FluidStack getFluidHovered(SmelteryTank tank, int y, int height) {
        int[] heights = GuiUtil.calcLiquidHeights(tank.getFluids(), tank.getCapacity(), height);
        for (int i = 0; i < heights.length; ++i) {
            if (y < heights[i]) {
                return tank.getFluids().get(i);
            }
            y -= heights[i];
        }
        return null;
    }

    private static int[] calcLiquidHeights(List<FluidStack> liquids, int capacity, int height) {
        return SmelteryRenderer.calcLiquidHeights(liquids, capacity, height, 3);
    }

    public static void drawGuiTank(SmelteryTank liquids, int x, int y, int w, int height, float zLevel) {
        if (liquids.getFluidAmount() > 0) {
            int capacity = Math.max(liquids.getFluidAmount(), liquids.getCapacity());
            int[] heights = GuiUtil.calcLiquidHeights(liquids.getFluids(), capacity, height);
            int bottom = y + w;
            for (int i = 0; i < heights.length; ++i) {
                int h = heights[i];
                FluidStack liquid = liquids.getFluids().get(i);
                GuiUtil.renderTiledFluid(x, bottom - h, w, h, zLevel, liquid);
                bottom -= h;
            }
        }
    }

    public static FluidStack getFluidStackAtPosition(SmelteryTank tank, int mouseX, int mouseY, int xmin, int ymin, int xmax, int ymax) {
        return GuiUtil.getFluidStackIndexAtPosition(tank, mouseX, mouseY, xmin, ymin, xmax, ymax).map(tank.getFluids()::get).orElse(null);
    }

    public static void handleTankClick(SmelteryTank tank, int mouseX, int mouseY, int xmin, int ymin, int xmax, int ymax) {
        GuiUtil.getFluidStackIndexAtPosition(tank, mouseX, mouseY, xmin, ymin, xmax, ymax).ifPresent(i -> TinkerNetwork.sendToServer((AbstractPacket)new SmelteryFluidClicked((int)i)));
    }

    public static Optional<Integer> getFluidStackIndexAtPosition(SmelteryTank tank, int mouseX, int mouseY, int xmin, int ymin, int xmax, int ymax) {
        if (xmin <= mouseX && mouseX < xmax && ymin <= mouseY && mouseY < ymax) {
            int[] heights = GuiUtil.calcLiquidHeights(tank.getFluids(), tank.getCapacity(), ymax - ymin);
            int y = ymax - mouseY - 1;
            for (int i = 0; i < heights.length; ++i) {
                if (y < heights[i]) {
                    return Optional.of(i);
                }
                y -= heights[i];
            }
        }
        return Optional.empty();
    }

    public static void liquidToString(FluidStack fluid, List<String> text) {
        int amount = fluid.amount;
        if (smelteryLoaded && !Util.isShiftKeyDown()) {
            List<FluidGuiEntry> entries = fluidGui.get(fluid.getFluid());
            if (entries == null) {
                entries = GuiUtil.calcFluidGuiEntries(fluid.getFluid());
                fluidGui.put(fluid.getFluid(), entries);
            }
            for (FluidGuiEntry entry : entries) {
                amount = GuiUtil.calcLiquidText(amount, entry.amount, entry.getText(), text);
            }
        }
        GuiUtil.amountToString(amount, text);
    }

    public static void amountToIngotString(int amount, List<String> text) {
        amount = GuiUtil.calcLiquidText(amount, 144, Util.translate("gui.smeltery.liquid.ingot", new Object[0]), text);
        GuiUtil.amountToString(amount, text);
    }

    public static void amountToString(int amount, List<String> text) {
        amount = GuiUtil.calcLiquidText(amount, 1000000, Util.translate("gui.smeltery.liquid.kilobucket", new Object[0]), text);
        amount = GuiUtil.calcLiquidText(amount, 1000, Util.translate("gui.smeltery.liquid.bucket", new Object[0]), text);
        GuiUtil.calcLiquidText(amount, 1, Util.translate("gui.smeltery.liquid.millibucket", new Object[0]), text);
    }

    private static List<FluidGuiEntry> calcFluidGuiEntries(Fluid fluid) {
        CastingRecipe recipe;
        ArrayList list = Lists.newArrayList();
        for (ICastingRecipe irecipe : TinkerRegistry.getAllBasinCastingRecipes()) {
            if (!(irecipe instanceof CastingRecipe) || (recipe = (CastingRecipe)irecipe).getFluid().getFluid() != fluid || recipe.cast != null) continue;
            list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.block"));
        }
        for (ICastingRecipe irecipe : TinkerRegistry.getAllTableCastingRecipes()) {
            if (!(irecipe instanceof CastingRecipe) || (recipe = (CastingRecipe)irecipe).getFluid().getFluid() != fluid || recipe.cast == null) continue;
            if (recipe.cast.matches(ListUtil.getListFrom(TinkerSmeltery.castNugget)).isPresent()) {
                list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.nugget"));
            }
            if (recipe.cast.matches(ListUtil.getListFrom(TinkerSmeltery.castIngot)).isPresent()) {
                list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.ingot"));
            }
            if (!recipe.cast.matches(ListUtil.getListFrom(TinkerSmeltery.castGem)).isPresent()) continue;
            list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.gem"));
        }
        list.sort((o1, o2) -> o2.amount - o1.amount);
        return ImmutableList.copyOf((Collection)list);
    }

    private static int calcLiquidText(int amount, int divider, String unit, List<String> text) {
        int full = amount / divider;
        if (full > 0) {
            text.add(String.format("%s%d %s", TextFormatting.GRAY, full, unit));
        }
        return amount % divider;
    }

    private static class FluidGuiEntry {
        public final int amount;
        public final String unlocName;

        private FluidGuiEntry(int amount, String unlocName) {
            this.amount = amount;
            this.unlocName = unlocName;
        }

        public String getText() {
            return Util.translate(this.unlocName, new Object[0]);
        }
    }
}

