/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.TinkerIntegration;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.BucketCastingRecipe;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.smeltery.OreCastingRecipe;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.shared.block.BlockSlime;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.block.BlockFaucet;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.smeltery.block.BlockSearedFurnaceController;
import slimeknights.tconstruct.smeltery.block.BlockSearedGlass;
import slimeknights.tconstruct.smeltery.block.BlockSearedSlab;
import slimeknights.tconstruct.smeltery.block.BlockSearedSlab2;
import slimeknights.tconstruct.smeltery.block.BlockSearedStairs;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryController;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryIO;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.block.BlockTinkerTankController;
import slimeknights.tconstruct.smeltery.item.CastCustom;
import slimeknights.tconstruct.smeltery.item.ItemTank;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingBasin;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingTable;
import slimeknights.tconstruct.smeltery.tileentity.TileDrain;
import slimeknights.tconstruct.smeltery.tileentity.TileFaucet;
import slimeknights.tconstruct.smeltery.tileentity.TileSearedFurnace;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;
import slimeknights.tconstruct.smeltery.tileentity.TileTinkerTank;
import slimeknights.tconstruct.tools.TinkerMaterials;

@Pulse(id="TinkerSmeltery", description="The smeltery and items needed for it")
public class TinkerSmeltery
extends TinkerPulse {
    public static final String PulseId = "TinkerSmeltery";
    public static final Logger log = Util.getLogger("TinkerSmeltery");
    @SidedProxy(clientSide="slimeknights.tconstruct.smeltery.SmelteryClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockSeared searedBlock;
    public static BlockSmelteryController smelteryController;
    public static BlockTank searedTank;
    public static BlockFaucet faucet;
    public static BlockCasting castingBlock;
    public static BlockSmelteryIO smelteryIO;
    public static BlockSearedGlass searedGlass;
    public static Block searedFurnaceController;
    public static Block tinkerTankController;
    public static BlockSearedSlab searedSlab;
    public static BlockSearedSlab2 searedSlab2;
    public static Block searedStairsStone;
    public static Block searedStairsCobble;
    public static Block searedStairsPaver;
    public static Block searedStairsBrick;
    public static Block searedStairsBrickCracked;
    public static Block searedStairsBrickFancy;
    public static Block searedStairsBrickSquare;
    public static Block searedStairsBrickTriangle;
    public static Block searedStairsBrickSmall;
    public static Block searedStairsRoad;
    public static Block searedStairsTile;
    public static Block searedStairsCreeper;
    public static Cast cast;
    public static CastCustom castCustom;
    public static Cast clayCast;
    public static ItemStack castIngot;
    public static ItemStack castNugget;
    public static ItemStack castGem;
    public static ItemStack castShard;
    public static ItemStack castPlate;
    public static ItemStack castGear;
    private static Map<Fluid, Set<Pair<List<ItemStack>, Integer>>> knownOreFluids;
    public static List<FluidStack> castCreationFluids;
    public static List<FluidStack> clayCreationFluids;
    public static ImmutableSet<Block> validSmelteryBlocks;
    public static ImmutableSet<Block> searedStairsSlabs;
    public static ImmutableSet<Block> validTinkerTankBlocks;
    public static ImmutableSet<Block> validTinkerTankFloorBlocks;
    public static List<ItemStack> meltingBlacklist;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        searedBlock = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSeared(), "seared");
        smelteryController = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSmelteryController(), "smeltery_controller");
        searedTank = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockTank(), "seared_tank");
        faucet = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockFaucet(), "faucet");
        castingBlock = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockCasting(), "casting");
        smelteryIO = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSmelteryIO(), "smeltery_io");
        searedGlass = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedGlass(), "seared_glass");
        searedFurnaceController = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedFurnaceController(), "seared_furnace_controller");
        tinkerTankController = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockTinkerTankController(), "tinker_tank_controller");
        searedSlab = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedSlab(), "seared_slab");
        searedSlab2 = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedSlab2(), "seared_slab2");
        searedStairsStone = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.STONE, "seared_stairs_stone");
        searedStairsCobble = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.COBBLE, "seared_stairs_cobble");
        searedStairsPaver = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.PAVER, "seared_stairs_paver");
        searedStairsBrick = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK, "seared_stairs_brick");
        searedStairsBrickCracked = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_CRACKED, "seared_stairs_brick_cracked");
        searedStairsBrickFancy = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_FANCY, "seared_stairs_brick_fancy");
        searedStairsBrickSquare = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_SQUARE, "seared_stairs_brick_square");
        searedStairsBrickTriangle = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_TRIANGLE, "seared_stairs_brick_triangle");
        searedStairsBrickSmall = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_SMALL, "seared_stairs_brick_small");
        searedStairsRoad = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.ROAD, "seared_stairs_road");
        searedStairsTile = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.TILE, "seared_stairs_tile");
        searedStairsCreeper = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.CREEPER, "seared_stairs_creeper");
        TinkerSmeltery.registerTE(TileSmeltery.class, "smeltery_controller");
        TinkerSmeltery.registerTE(TileSmelteryComponent.class, "smeltery_component");
        TinkerSmeltery.registerTE(TileTank.class, "tank");
        TinkerSmeltery.registerTE(TileFaucet.class, "faucet");
        TinkerSmeltery.registerTE(TileCastingTable.class, "casting_table");
        TinkerSmeltery.registerTE(TileCastingBasin.class, "casting_basin");
        TinkerSmeltery.registerTE(TileDrain.class, "smeltery_drain");
        TinkerSmeltery.registerTE(TileSearedFurnace.class, "seared_furnace");
        TinkerSmeltery.registerTE(TileTinkerTank.class, "tinker_tank");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        searedBlock = TinkerSmeltery.registerEnumItemBlock((IForgeRegistry<Item>)registry, searedBlock);
        smelteryController = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, smelteryController);
        searedTank = (BlockTank)TinkerSmeltery.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemTank((Block)searedTank), BlockTank.TYPE);
        faucet = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, faucet);
        castingBlock = (BlockCasting)TinkerSmeltery.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockMeta((Block)castingBlock), BlockCasting.TYPE);
        smelteryIO = TinkerSmeltery.registerEnumItemBlock((IForgeRegistry<Item>)registry, smelteryIO);
        searedGlass = TinkerSmeltery.registerEnumItemBlock((IForgeRegistry<Item>)registry, searedGlass);
        searedFurnaceController = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedFurnaceController);
        tinkerTankController = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, tinkerTankController);
        searedSlab = TinkerSmeltery.registerEnumItemBlockSlab((IForgeRegistry<Item>)registry, searedSlab);
        searedSlab2 = TinkerSmeltery.registerEnumItemBlockSlab((IForgeRegistry<Item>)registry, searedSlab2);
        searedStairsStone = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsStone);
        searedStairsCobble = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsCobble);
        searedStairsPaver = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsPaver);
        searedStairsBrick = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrick);
        searedStairsBrickCracked = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickCracked);
        searedStairsBrickFancy = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickFancy);
        searedStairsBrickSquare = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickSquare);
        searedStairsBrickTriangle = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickTriangle);
        searedStairsBrickSmall = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickSmall);
        searedStairsRoad = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsRoad);
        searedStairsTile = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsTile);
        searedStairsCreeper = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsCreeper);
        cast = TinkerSmeltery.registerItem((IForgeRegistry<Item>)registry, new Cast(), "cast");
        castCustom = TinkerSmeltery.registerItem((IForgeRegistry<Item>)registry, new CastCustom(), "cast_custom");
        castIngot = castCustom.addMeta(0, "ingot", 144);
        castNugget = castCustom.addMeta(1, "nugget", 16);
        castGem = castCustom.addMeta(2, "gem", 666);
        castPlate = castCustom.addMeta(3, "plate", 144);
        castGear = castCustom.addMeta(4, "gear", 576);
        clayCast = TinkerSmeltery.registerItem((IForgeRegistry<Item>)registry, new Cast(), "clay_cast");
        if (TinkerRegistry.getShard() != null) {
            TinkerRegistry.addCastForItem(TinkerRegistry.getShard());
            castShard = new ItemStack((Item)cast);
            Cast.setTagForPart(castShard, TinkerRegistry.getShard());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)searedBlock);
        builder.add((Object)searedTank);
        builder.add((Object)smelteryIO);
        builder.add((Object)searedGlass);
        validSmelteryBlocks = builder.build();
        validTinkerTankBlocks = builder.build();
        validTinkerTankFloorBlocks = ImmutableSet.of((Object)((Object)searedBlock), (Object)((Object)searedGlass), (Object)((Object)smelteryIO));
        builder = ImmutableSet.builder();
        builder.add((Object)searedBlock);
        builder.add((Object)searedSlab);
        builder.add((Object)searedSlab2);
        builder.add((Object)searedStairsStone);
        builder.add((Object)searedStairsCobble);
        builder.add((Object)searedStairsPaver);
        builder.add((Object)searedStairsBrick);
        builder.add((Object)searedStairsBrickCracked);
        builder.add((Object)searedStairsBrickFancy);
        builder.add((Object)searedStairsBrickSquare);
        builder.add((Object)searedStairsBrickTriangle);
        builder.add((Object)searedStairsBrickSmall);
        builder.add((Object)searedStairsRoad);
        builder.add((Object)searedStairsTile);
        builder.add((Object)searedStairsCreeper);
        searedStairsSlabs = builder.build();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.gold, 288));
        castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.brass, 144));
        castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.alubrass, 144));
        if (Config.claycasts) {
            clayCreationFluids.add(new FluidStack((Fluid)TinkerFluids.clay, 288));
        }
        this.registerSmelting();
        proxy.init();
    }

    private void registerSmelting() {
        GameRegistry.addSmelting((ItemStack)TinkerCommons.grout, (ItemStack)TinkerCommons.searedBrick, (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK.getMeta()), (ItemStack)new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK_CRACKED.getMeta()), (float)0.1f);
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerSmelteryFuel();
        this.registerMeltingCasting();
        for (FluidStack fs : castCreationFluids) {
            TinkerRegistry.registerTableCasting(new ItemStack((Item)cast), ItemStack.field_190927_a, fs.getFluid(), fs.amount);
            TinkerRegistry.registerTableCasting(new CastingRecipe(castGem, RecipeMatch.of((String)"gemEmerald"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((String)"ingotBrick"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((String)"ingotBrickNether"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, (RecipeMatch)new RecipeMatch.Item(TinkerCommons.searedBrick, 1), fs, true, true));
        }
        proxy.postInit();
        TinkerRegistry.tabSmeltery.setDisplayIcon(new ItemStack((Block)searedTank));
    }

    private void registerSmelteryFuel() {
        TinkerRegistry.registerSmelteryFuel(new FluidStack(FluidRegistry.LAVA, 50), 100);
    }

    private void registerMeltingCasting() {
        ItemStack stack;
        int bucket = 1000;
        TinkerRegistry.registerTableCasting(new BucketCastingRecipe(Items.field_151133_ar));
        Fluid water = FluidRegistry.WATER;
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150432_aD, (int)bucket), water, 305));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150403_cj, (int)(bucket * 2)), water, 310));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150433_aE, (int)bucket), water, 305));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Item)Items.field_151126_ay, (int)(bucket / 8)), water, 301));
        TinkerRegistry.registerMelting(Items.field_151078_bh, (Fluid)TinkerFluids.blood, 5);
        if (TinkerCommons.matSlimeBallBlood != null) {
            TinkerRegistry.registerTableCasting(TinkerCommons.matSlimeBallBlood.func_77946_l(), ItemStack.field_190927_a, TinkerFluids.blood, 160);
        }
        TinkerRegistry.registerMelting(TinkerCommons.matSlimeBallPurple, (Fluid)TinkerFluids.purpleSlime, 250);
        ItemStack slimeblock = new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.PURPLE.meta);
        TinkerRegistry.registerMelting(slimeblock, (Fluid)TinkerFluids.purpleSlime, 1000);
        slimeblock = new ItemStack((Block)TinkerCommons.blockSlime, 1, BlockSlime.SlimeType.PURPLE.meta);
        TinkerRegistry.registerMelting(slimeblock, (Fluid)TinkerFluids.purpleSlime, 2250);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"stone", (int)72), TinkerFluids.searedStone, Material.VALUE_Ore()));
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"cobblestone", (int)72), TinkerFluids.searedStone, Material.VALUE_Ore()));
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"obsidian", (int)Material.VALUE_Ore()), TinkerFluids.obsidian, Material.VALUE_Ore()));
        TinkerSmeltery.registerToolpartMeltingCasting(TinkerMaterials.obsidian);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150343_Z), ItemStack.field_190927_a, TinkerFluids.obsidian, Material.VALUE_Ore());
        TinkerRegistry.registerMelting(Items.field_151138_bX, (Fluid)TinkerFluids.iron, 1152);
        TinkerRegistry.registerMelting(Items.field_151136_bY, (Fluid)TinkerFluids.gold, 1152);
        for (IToolPart toolPart : TinkerRegistry.getToolParts()) {
            if (!toolPart.canBeCasted() || !(toolPart instanceof MaterialItem)) continue;
            stack = toolPart.getItemstackWithMaterial(TinkerMaterials.stone);
            TinkerRegistry.registerMelting(stack, (Fluid)TinkerFluids.searedStone, toolPart.getCost() * 72 / 144);
        }
        ItemStack blockSeared = new ItemStack((Block)searedBlock);
        blockSeared.func_77964_b(BlockSeared.SearedType.STONE.getMeta());
        TinkerRegistry.registerTableCasting(TinkerCommons.searedBrick, castIngot, TinkerFluids.searedStone, 72);
        TinkerRegistry.registerBasinCasting(blockSeared, ItemStack.field_190927_a, TinkerFluids.searedStone, 288);
        ItemStack searedCobble = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.COBBLE.getMeta());
        TinkerRegistry.registerBasinCasting(new CastingRecipe(searedCobble, RecipeMatch.of((String)"cobblestone"), TinkerFluids.searedStone, 216, true, false));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(searedFurnaceController), RecipeMatch.of((Block)Blocks.field_150460_al), new FluidStack((Fluid)TinkerFluids.searedStone, 576), true, true));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)searedGlass, 1, BlockSearedGlass.GlassType.GLASS.getMeta()), RecipeMatch.of((String)"blockGlass"), new FluidStack((Fluid)TinkerFluids.searedStone, 288), true, true));
        TinkerRegistry.registerMelting((Block)searedBlock, (Fluid)TinkerFluids.searedStone, 288);
        TinkerRegistry.registerMelting(TinkerCommons.searedBrick, (Fluid)TinkerFluids.searedStone, 72);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((ItemStack)TinkerCommons.grout, (int)72), TinkerFluids.searedStone, 24));
        stack = new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE);
        RecipeMatch.Item rm = new RecipeMatch.Item(stack, 1, 144);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount((RecipeMatch)rm, TinkerFluids.dirt, 576));
        TinkerRegistry.registerTableCasting(TinkerCommons.mudBrick, castIngot, TinkerFluids.dirt, 144);
        TinkerRegistry.registerMelting(Items.field_151119_aD, (Fluid)TinkerFluids.clay, 144);
        TinkerRegistry.registerMelting(Blocks.field_150435_aG, (Fluid)TinkerFluids.clay, 576);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150405_ch), ItemStack.field_190927_a, TinkerFluids.clay, 576);
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(Blocks.field_150405_ch), RecipeMatch.of((ItemStack)new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE)), new FluidStack(FluidRegistry.WATER, 250), 150, true, false));
        if (Config.castableBricks) {
            TinkerRegistry.registerTableCasting(new ItemStack(Items.field_151118_aC), castIngot, TinkerFluids.clay, 144);
        }
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"gemEmerald", (int)666), TinkerFluids.emerald));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"oreEmerald", (int)((int)(666.0 * Config.oreToIngotRatio))), TinkerFluids.emerald));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"blockEmerald", (int)5994), TinkerFluids.emerald));
        TinkerRegistry.registerTableCasting(new ItemStack(Items.field_151166_bC), castGem, TinkerFluids.emerald, 666);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150475_bE), ItemStack.field_190927_a, TinkerFluids.emerald, 5994);
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"sand", (int)1000), TinkerFluids.glass));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"blockGlass", (int)1000), TinkerFluids.glass));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"paneGlass", (int)375), TinkerFluids.glass));
        TinkerRegistry.registerTableCasting(new CastingRecipe(new ItemStack(Blocks.field_150410_aZ), null, TinkerFluids.glass, 375, 50));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(TinkerCommons.blockClearGlass), null, TinkerFluids.glass, 1000, 120));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(TinkerCommons.lavawood, RecipeMatch.of((String)"plankWood"), new FluidStack(FluidRegistry.LAVA, 250), 100, true, false));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)Blocks.field_150354_m, 1, 1), RecipeMatch.of((ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, 0)), new FluidStack((Fluid)TinkerFluids.blood, 10), true, false));
        TinkerRegistry.registerEntityMelting(EntityIronGolem.class, new FluidStack((Fluid)TinkerFluids.iron, 18));
        TinkerRegistry.registerEntityMelting(EntitySnowman.class, new FluidStack(FluidRegistry.WATER, 100));
        TinkerRegistry.registerEntityMelting(EntityVillager.class, new FluidStack((Fluid)TinkerFluids.emerald, 6));
    }

    public static void registerAlloys() {
        if (!TinkerSmeltery.isSmelteryLoaded()) {
            return;
        }
        if (Config.obsidianAlloy) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.obsidian, 36), new FluidStack(FluidRegistry.WATER, 125), new FluidStack(FluidRegistry.LAVA, 125));
        }
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.clay, 144), new FluidStack(FluidRegistry.WATER, 250), new FluidStack((Fluid)TinkerFluids.searedStone, 72), new FluidStack((Fluid)TinkerFluids.dirt, 144));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.knightslime, 72), new FluidStack((Fluid)TinkerFluids.iron, 72), new FluidStack((Fluid)TinkerFluids.purpleSlime, 125), new FluidStack((Fluid)TinkerFluids.searedStone, 144));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.pigIron, 144), new FluidStack((Fluid)TinkerFluids.iron, 48), new FluidStack((Fluid)TinkerFluids.blood, 33), new FluidStack((Fluid)TinkerFluids.emerald, 74));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.manyullyn, 2), new FluidStack((Fluid)TinkerFluids.cobalt, 2), new FluidStack((Fluid)TinkerFluids.ardite, 2));
        if (TinkerIntegration.isIntegrated(TinkerFluids.bronze) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.tin)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.bronze, 4), new FluidStack((Fluid)TinkerFluids.copper, 3), new FluidStack((Fluid)TinkerFluids.tin, 1));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.electrum) && TinkerIntegration.isIntegrated(TinkerFluids.gold) && TinkerIntegration.isIntegrated(TinkerFluids.silver)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.electrum, 2), new FluidStack((Fluid)TinkerFluids.gold, 1), new FluidStack((Fluid)TinkerFluids.silver, 1));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.alubrass) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.aluminum)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.alubrass, 4), new FluidStack((Fluid)TinkerFluids.copper, 1), new FluidStack((Fluid)TinkerFluids.aluminum, 3));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.brass) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.zinc)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.brass, 3), new FluidStack((Fluid)TinkerFluids.copper, 2), new FluidStack((Fluid)TinkerFluids.zinc, 1));
        }
    }

    public static void registerToolpartMeltingCasting(Material material) {
        Fluid fluid = material.getFluid();
        for (IToolPart toolPart : TinkerRegistry.getToolParts()) {
            if (!toolPart.canBeCasted() || !(toolPart instanceof MaterialItem)) continue;
            ItemStack stack = toolPart.getItemstackWithMaterial(material);
            ItemStack cast = new ItemStack((Item)TinkerSmeltery.cast);
            Cast.setTagForPart(cast, stack.func_77973_b());
            if (fluid != null) {
                TinkerRegistry.registerMelting(stack, fluid, toolPart.getCost());
                TinkerRegistry.registerTableCasting(stack, cast, fluid, toolPart.getCost());
            }
            for (FluidStack fs : castCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(cast, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
            if (!Config.claycasts) continue;
            ItemStack clayCast = new ItemStack((Item)TinkerSmeltery.clayCast);
            Cast.setTagForPart(clayCast, stack.func_77973_b());
            if (fluid != null) {
                RecipeMatch rm = RecipeMatch.ofNBT((ItemStack)clayCast);
                FluidStack fs = new FluidStack(fluid, toolPart.getCost());
                TinkerRegistry.registerTableCasting(new CastingRecipe(stack, rm, fs, true, false));
            }
            for (FluidStack fs : clayCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(clayCast, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
        }
        if (castShard != null) {
            ItemStack stack = TinkerRegistry.getShard(material);
            int cost = TinkerRegistry.getShard().getCost();
            if (fluid != null) {
                TinkerRegistry.registerMelting(stack, fluid, cost);
                TinkerRegistry.registerTableCasting(stack, castShard, fluid, cost);
            }
            for (FluidStack fs : castCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(castShard, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
        }
    }

    public static void registerOredictMeltingCasting(Fluid fluid, String ore) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Pair nuggetOre = Pair.of((Object)OreDictionary.getOres((String)("nugget" + ore)), (Object)16);
        Pair ingotOre = Pair.of((Object)OreDictionary.getOres((String)("ingot" + ore)), (Object)144);
        Pair blockOre = Pair.of((Object)OreDictionary.getOres((String)("block" + ore)), (Object)1296);
        Pair oreOre = Pair.of((Object)OreDictionary.getOres((String)("ore" + ore)), (Object)Material.VALUE_Ore());
        Pair oreNetherOre = Pair.of((Object)OreDictionary.getOres((String)("oreNether" + ore)), (Object)((int)(288.0 * Config.oreToIngotRatio)));
        Pair oreDenseOre = Pair.of((Object)OreDictionary.getOres((String)("denseore" + ore)), (Object)((int)(432.0 * Config.oreToIngotRatio)));
        Pair orePoorOre = Pair.of((Object)OreDictionary.getOres((String)("orePoor" + ore)), (Object)((int)(48.0 * Config.oreToIngotRatio)));
        Pair oreNuggetOre = Pair.of((Object)OreDictionary.getOres((String)("oreNugget" + ore)), (Object)((int)(16.0 * Config.oreToIngotRatio)));
        Pair plateOre = Pair.of((Object)OreDictionary.getOres((String)("plate" + ore)), (Object)144);
        Pair gearOre = Pair.of((Object)OreDictionary.getOres((String)("gear" + ore)), (Object)576);
        Pair dustOre = Pair.of((Object)OreDictionary.getOres((String)("dust" + ore)), (Object)144);
        builder.add((Object[])new Pair[]{nuggetOre, ingotOre, blockOre, oreOre, oreNetherOre, oreDenseOre, orePoorOre, oreNuggetOre, plateOre, gearOre, dustOre});
        ImmutableSet knownOres = builder.build();
        for (Pair pair : knownOres) {
            TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((List)((List)pair.getLeft()), (int)((Integer)pair.getRight())), fluid));
        }
        TinkerRegistry.registerTableCasting(new OreCastingRecipe((List)ingotOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castIngot), fluid, (int)((Integer)ingotOre.getRight())));
        TinkerRegistry.registerTableCasting(new OreCastingRecipe((List)nuggetOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castNugget), fluid, (int)((Integer)nuggetOre.getRight())));
        TinkerRegistry.registerBasinCasting(new OreCastingRecipe((List)blockOre.getLeft(), null, fluid, (int)((Integer)blockOre.getRight())));
        TinkerRegistry.registerTableCasting(new OreCastingRecipe((List)plateOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castPlate), fluid, (int)((Integer)plateOre.getRight())));
        TinkerRegistry.registerTableCasting(new OreCastingRecipe((List)gearOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castGear), fluid, (int)((Integer)gearOre.getRight())));
        for (FluidStack fs : castCreationFluids) {
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((List)((List)ingotOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castNugget, RecipeMatch.of((List)((List)nuggetOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castPlate, RecipeMatch.of((List)((List)plateOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castGear, RecipeMatch.of((List)((List)gearOre.getLeft())), fs, true, true));
        }
        knownOreFluids.put(fluid, (Set<Pair<List<ItemStack>, Integer>>)knownOres);
    }

    public static void registerRecipeOredictMelting() {
        if (!TinkerSmeltery.isSmelteryLoaded()) {
            return;
        }
        for (IRecipe irecipe : CraftingManager.field_193380_a) {
            boolean blacklisted = false;
            for (ItemStack blacklistItem : meltingBlacklist) {
                if (!OreDictionary.itemMatches((ItemStack)blacklistItem, (ItemStack)irecipe.func_77571_b(), (boolean)false)) continue;
                blacklisted = true;
                break;
            }
            if (blacklisted || TinkerRegistry.getMelting(irecipe.func_77571_b()) != null) continue;
            NonNullList inputs = irecipe.func_192400_c();
            HashMap known = Maps.newHashMap();
            for (Ingredient ingredient : inputs) {
                if (ingredient.func_193365_a().length == 0) continue;
                boolean found = false;
                for (Map.Entry<Fluid, Set<Pair<List<ItemStack>, Integer>>> entry : knownOreFluids.entrySet()) {
                    for (Pair<List<ItemStack>, Integer> pair : entry.getValue()) {
                        for (ItemStack itemStack : (List)pair.getLeft()) {
                            if (!ingredient.apply(itemStack)) continue;
                            Integer amount = (Integer)known.get(entry.getKey());
                            if (amount == null) {
                                amount = 0;
                            }
                            amount = amount + (Integer)pair.getRight();
                            known.put(entry.getKey(), amount);
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                known.clear();
                break;
            }
            if (known.keySet().size() != 1) continue;
            Fluid fluid = (Fluid)known.keySet().iterator().next();
            ItemStack output = irecipe.func_77571_b().func_77946_l();
            if (output.func_190926_b()) continue;
            int amount = (Integer)known.get(fluid) / output.func_190916_E();
            output.func_190920_e(1);
            TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((ItemStack)output, (int)amount), fluid));
            log.trace("Added automatic melting recipe for {} ({} {})", (Object)irecipe.func_77571_b().toString(), (Object)amount, (Object)fluid.getName());
        }
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockSearedStairs registerBlockSearedStairsFrom(IForgeRegistry<Block> registry, EnumBlock<E> block, E value, String name) {
        return TinkerSmeltery.registerBlock(registry, new BlockSearedStairs(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    static {
        knownOreFluids = Maps.newHashMap();
        castCreationFluids = Lists.newLinkedList();
        clayCreationFluids = Lists.newLinkedList();
        meltingBlacklist = Lists.newLinkedList();
    }
}

