/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.items;

import com.blakebr0.cucumber.iface.IRepairMaterial;
import com.blakebr0.cucumber.util.ToolTools;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagradditions.MysticalAgradditions;
import com.blakebr0.mysticalagradditions.items.ModItems;
import com.blakebr0.mysticalagriculture.items.ItemCrafting;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.blakebr0.mysticalagriculture.util.NBTHelper;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemPaxel
extends ItemTool
implements IRepairMaterial {
    public ItemStack repairMaterial;
    public TextFormatting color;

    public ItemPaxel(String name, Item.ToolMaterial material, TextFormatting color) {
        super(4.0f, -3.2f, material, new HashSet());
        this.func_77655_b("ma." + name);
        this.func_77637_a(MysticalAgradditions.tabMysticalAgradditions);
        this.setHarvestLevel("pickaxe", material.func_77996_d());
        this.setHarvestLevel("shovel", material.func_77996_d());
        this.setHarvestLevel("axe", material.func_77996_d());
        this.func_77656_e((int)((double)material.func_77997_a() * 1.5));
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int damage = stack.func_77958_k() - stack.func_77952_i();
        tooltip.add(Tooltips.DURABILITY + this.color + (damage > -1 ? Integer.valueOf(damage) : Tooltips.UNLIMITED));
        if (OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)ItemCrafting.itemSupremiumIngot, (boolean)false)) {
            NBTTagCompound tag = NBTHelper.getDataMap((ItemStack)stack);
            if (tag.func_74764_b("ToolType") && tag.func_74762_e("ToolType") == 1000) {
                tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Utils.localize((String)"tooltip.ma.mining_aoe"));
            } else {
                tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Tooltips.EMPTY);
            }
        }
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        float aoeNerf = NBTHelper.getDataMap((ItemStack)stack).func_74764_b("ToolType") ? (NBTHelper.getDataMap((ItemStack)stack).func_74762_e("ToolType") == 1000 ? -15.0f : 0.0f) : 0.0f;
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e && material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l ? super.func_150893_a(stack, state) + aoeNerf : this.field_77864_a + aoeNerf;
    }

    public boolean func_150897_b(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150343_Z) {
            return this.field_77862_b.func_77996_d() == 3;
        }
        if (block != Blocks.field_150484_ah && block != Blocks.field_150482_ag) {
            if (block != Blocks.field_150412_bA && block != Blocks.field_150475_bE) {
                if (block != Blocks.field_150340_R && block != Blocks.field_150352_o) {
                    if (block != Blocks.field_150339_S && block != Blocks.field_150366_p) {
                        if (block != Blocks.field_150368_y && block != Blocks.field_150369_x) {
                            if (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay) {
                                Material material = state.func_185904_a();
                                if (material == Material.field_151576_e) {
                                    return true;
                                }
                                if (material == Material.field_151573_f) {
                                    return true;
                                }
                                return material == Material.field_151574_g;
                            }
                            return this.field_77862_b.func_77996_d() >= 2;
                        }
                        return this.field_77862_b.func_77996_d() >= 1;
                    }
                    return this.field_77862_b.func_77996_d() >= 1;
                }
                return this.field_77862_b.func_77996_d() >= 2;
            }
            return this.field_77862_b.func_77996_d() >= 2;
        }
        return this.field_77862_b.func_77996_d() >= 2;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        NBTTagCompound tag;
        if (stack.func_77973_b() == ModItems.itemSupremiumPaxel && (tag = NBTHelper.getDataMap((ItemStack)stack)).func_74764_b("ToolType") && tag.func_74762_e("ToolType") == 1000) {
            boolean blocks = false;
            RayTraceResult ray = ToolTools.getBlockWithinReach((World)player.func_130014_f_(), (EntityPlayer)player);
            if (ray != null) {
                int side = ray.field_178784_b.ordinal();
                blocks = this.harvest(stack, 1, player.func_130014_f_(), pos, side, player);
            }
            return blocks;
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public boolean harvest(ItemStack stack, int radius, World world, BlockPos pos, int side, EntityPlayer player) {
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side == 0 || side == 1) {
            zRange = radius;
            yRange = 0;
        }
        if (side == 4 || side == 5) {
            xRange = 0;
            zRange = radius;
        }
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        if (!this.canHarvest(world, pos, false, stack, player)) {
            return false;
        }
        if (radius > 0 && hardness >= 0.2f) {
            Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-xRange, -yRange, -zRange), (BlockPos)pos.func_177982_a(xRange, yRange, zRange));
            for (BlockPos aoePos : blocks) {
                if (aoePos == pos) continue;
                IBlockState aoeState = world.func_180495_p(aoePos);
                if (aoeState.func_185887_b(world, aoePos) <= hardness + 5.0f) {
                    this.canHarvest(world, aoePos, true, stack, player);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private boolean canHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, EntityPlayer player) {
        boolean harvest;
        IBlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b(world, pos);
        Block block = state.func_177230_c();
        boolean bl = harvest = !(!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) && !this.canHarvestBlock(state, stack) || extra && !(this.func_150893_a(stack, world.func_180495_p(pos)) > 1.0f));
        if (hardness >= 0.0f && (!extra || harvest)) {
            return ToolTools.breakBlocksAOE((ItemStack)stack, (World)world, (EntityPlayer)player, (BlockPos)pos);
        }
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)repair, (boolean)false);
    }

    public void setRepairMaterial(ItemStack stack) {
        this.repairMaterial = stack;
    }

    public ItemStack getRepairMaterial() {
        return this.repairMaterial;
    }
}

